/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class InsertTaskEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 6954579936773863317L;
    Project project;
    int row;
    Task newTask;

    public InsertTaskEdit(Project project, Task newTask, int row) {
        this.project = project;
        this.row = row;
        this.newTask = newTask.clone();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.project.getController().removeRow(this.row);
        this.project.update();
        this.project.getTaskTableModel().fireTableChanged();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.project.getController().insertTaskAtRow(this.newTask, this.row);
        this.project.update();
        this.project.getTaskTableModel().fireTableChanged();
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
        this.newTask = null;
    }
}

