<?php
/**
 * 実行ファイルを作成します。
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.0.01
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class spider_Builder {

	/** 元の本文文字列	*/
	var $org_body_strings;
	/** 出力する本文文字列	*/
	var $out_body_strings;

	/**
	 * コンストラクタ
	 */
	function spider_Builder() {
	}
	/**
	 * HTMLボディを生成する
	 */
	function convertBody( & $build_information_object ) {
		$action_lines				= file( $build_information_object->execute_file_path );
		$this->out_body_strings		= implode( "", $action_lines );
		$this->org_body_strings		= $this->out_body_strings;
		
		// 改行コード統一と連続改行の削除
		$this->out_body_strings = str_replace( "\r\n", "\n", $this->out_body_strings );
		$this->out_body_strings = str_replace( "\r", "\n", $this->out_body_strings );
		$this->out_body_strings = str_replace( "\n\n\n", "\n", $this->out_body_strings );
		$this->out_body_strings = str_replace( "\n\n", "\n", $this->out_body_strings );
		$this->out_body_strings = str_replace( "\n\n", "\n", $this->out_body_strings );

		// cms.phpインクルード行を削除
		preg_match_all( '/include_once\\([^\\)]*?cms\\.php[^\\)]*?\\)\\;/'
			, $this->out_body_strings
			, $output_array
			, PREG_PATTERN_ORDER );
		foreach ( $output_array as $output ) {
			foreach ( $output as $target ) {
				// 空行にならないよう前後が改行も削除
				$this->out_body_strings = str_replace( "\n".$target."\n", "", $this->out_body_strings );
				$this->out_body_strings = str_replace( $target, "", $this->out_body_strings );
			}
		}
		preg_match_all( '/require_once\\([^\\)]*?cms\\.php[^\\)]*?\\)\\;/'
			, $this->out_body_strings
			, $output_array
			, PREG_PATTERN_ORDER );
		foreach ( $output_array as $output ) {
			foreach ( $output as $target ) {
				// 空行にならないよう前後が改行も削除
				$this->out_body_strings = str_replace( "\n".$target."\n", "", $this->out_body_strings );
				$this->out_body_strings = str_replace( $target, "", $this->out_body_strings );
			}
		}
		// spider.inc.phpインクルード行を削除
		preg_match_all( '/include_once\\([^\\)]*?spider\\.inc\\.php[^\\)]*?\\)\\;/'
			, $this->out_body_strings
			, $output_array
			, PREG_PATTERN_ORDER );
		foreach ( $output_array as $output ) {
			foreach ( $output as $target ) {
				// 空行にならないよう前後が改行も削除
				$this->out_body_strings = str_replace( "\n".$target."\n", "", $this->out_body_strings );
				$this->out_body_strings = str_replace( $target, "", $this->out_body_strings );
			}
		}
		preg_match_all( '/require_once\\([^\\)]*?spider\\.inc\\.php[^\\)]*?\\)\\;/'
			, $this->out_body_strings
			, $output_array
			, PREG_PATTERN_ORDER );
		foreach ( $output_array as $output ) {
			foreach ( $output as $target ) {
				// 空行にならないよう前後が改行も削除
				$this->out_body_strings = str_replace( "\n".$target."\n", "", $this->out_body_strings );
				$this->out_body_strings = str_replace( $target, "", $this->out_body_strings );
			}
		}
		
		// 空PHP部分を削除
		$this->out_body_strings	= preg_replace('/<\\?php[\\s]*\\?>\\n/','',$this->out_body_strings);
		$this->out_body_strings	= preg_replace('/<\\?php[\\s]*\\?>/','',$this->out_body_strings);
		
		// フォルダデフォルトファイルの適用
		$folder_default_path		= null;
		$folder_path				= dirname($build_information_object->execute_file_path);
		// 存在しなかった場合の存在確認比較ファイルパス
		$confirm_default_path_array	= array();
		while( strlen($folder_path) >= strlen(APPLICATION_BASE_PATH) ) {
			$folder_default_path	= $folder_path.DIRECTORY_SEPARATOR.'.default';
			if( file_exists( $folder_default_path ) ) {
				break;
			} else {
				array_push( $confirm_default_path_array, $folder_default_path );
				$folder_default_path	= null;
			}
			$folder_path			= dirname($folder_path);
		}
		if( !is_null( $folder_default_path ) && file_exists($folder_default_path) ) {
			$str	= trim(file_get_contents($folder_default_path));
			$this->out_body_strings	= $str.$this->out_body_strings;
			// フォルダデフォルトファイルをタイムスタンプ比較ファイルに追加
			$build_information_object->addCompareFile( $folder_default_path );
		} else if( count( $confirm_default_path_array ) > 0 ) {
			foreach( $confirm_default_path_array as $path ) {
				$build_information_object->addConfirmFile( $path );
			}
		}

		// 変換タグの読み込みと変換
		$tag_object_array	= array();
		$dir_path_tags	= dirname(__FILE__).DIRECTORY_SEPARATOR."tags".DIRECTORY_SEPARATOR;
		if ( is_dir($dir_path_tags) ) {
			if ( $dh = opendir( $dir_path_tags ) ) {
				while ( ( $file_name = readdir($dh) ) !== false ) {
					if( $file_name != "." && $file_name != ".."
						&& preg_match('/^[0-9a-zA-Z]+?\\.class\\.php$/',$file_name)) {
						require_once( dirname(__FILE__).DIRECTORY_SEPARATOR
							."tags".DIRECTORY_SEPARATOR.$file_name );
						$tag_class_name	= "spider_tags_".substr($file_name,0,strpos($file_name,"."));
						$tag_class_obj	= new $tag_class_name;
						if( !isset($tag_object_array[$tag_class_obj->priority]) || !is_array($tag_object_array[$tag_class_obj->priority]) ) {
							$tag_object_array[$tag_class_obj->priority]	= array();
						}
						array_push( $tag_object_array[$tag_class_obj->priority], $tag_class_obj );
					}
				}
				closedir($dh);
			} else {
			}
		} else {
		}
		// 外部変換タグの読み込みと変換
		$external_tags_conf_file	= dirname(__FILE__)
			.DIRECTORY_SEPARATOR."tags".DIRECTORY_SEPARATOR."externals.conf";
		if( file_exists( $external_tags_conf_file ) ) {
			$lines	= file( $external_tags_conf_file );
			foreach( $lines as $line ) {
				$line	= trim($line);
				$tag_class_name	= $line;
				$tag_class_file	= DIR_PATH_LIB.DIRECTORY_SEPARATOR.str_replace('_',DIRECTORY_SEPARATOR,$line).'.class.php';
				if( file_exists($tag_class_file) ) {
					require_once( $tag_class_file );
					$tag_class_obj	= new $tag_class_name;
					if( !is_array( $tag_object_array[$tag_class_obj->priority]) ) {
						$tag_object_array[$tag_class_obj->priority]	= array();
					}
					array_push( $tag_object_array[$tag_class_obj->priority], $tag_class_obj );
				}
			}
		}
		// 優先順にタグのコンバートメソッドを実行
		ksort($tag_object_array);
		foreach( $tag_object_array as $key => $tag_array ) {
			foreach($tag_array as $tag_obj ) {
				$tag_obj->convert( $this->out_body_strings, $build_information_object );
			}
		}
	}
	/**
	 * 実行ファイル実体を書き出す
	 * @param $bin_file_path 実行ファイルの出力パス
	 */
	function createBinFile( & $build_information_object ) {

		$bin_file_path	= $build_information_object->getAgentPageBuildFilePath();

		// 実行ファイルを解析
		$this->convertBody($build_information_object);

		// 表示前実行部分作成
		$string  = "<?php\n";
		
		// 処理開始前実行コードを記述
		foreach( $build_information_object->preview_process_hash as $code_array ) {
			foreach( $code_array as $code ) {
				$string	.= $code."\n";
			}
		}

		// モジュール実行のスクリプト追加
		foreach( $build_information_object->module_exec_info_hash as $key => $info_hash ) {
			$module_name		= $info_hash['module_name'];
			$force	= 'false';
			if( $info_hash['force'] ) {
				$force	= 'true';
			}
			$attribute_prefix	= '';
			if( isset($info_hash['attribute_prefix']) ) {
				$attribute_prefix	= $info_hash['attribute_prefix'];
				$attribute_prefix	= str_replace('"','\\"',$attribute_prefix);
			}
			$post_contents		= '';
			if( isset($info_hash['post']) ) {
				$post_contents		= $info_hash['post'];
				$post_contents		= str_replace('"','\\"',$post_contents);
			}
			$get_contents		= '';
			if( isset($info_hash['get']) ) {
				$get_contents		= $info_hash['get'];
				$get_contents		= str_replace('"','\\"',$get_contents);
			}
			$string	.= '$controller->loadModule( "' . $module_name . '", '.$force.',"'.$attribute_prefix
				.'","'.$get_contents.'", "'.$post_contents.'" );'."\n";
		}
		
		// モジュール実行結果による分岐処理を記述
		$string	.= 'if ( $request_object->isError() ) {'."\n";
			$string	.= '$is_error = true;'."\n";
			$string	.= '$request_object->setAttribute("IS_ERROR", $is_error );'."\n";
			$string	.= '$tmp_array = $request_object->errors;'."\n";
			$string	.= '$request_object->setAttribute("errors", $tmp_array );'."\n";
		$string	.= '} else {'."\n";
			$string	.= '$is_error = false;'."\n";
			$string	.= '$request_object->setAttribute("IS_ERROR", $is_error );'."\n";
		$string	.= '}'."\n";
		
		// リクエスト属性をグローバル変数に格納する
		$string	.= 'foreach( $request_object->attribute_array as $key => $value ) { ';
		$string	.= ' $GLOBALS[$key] = $value; ';
		$string	.= ' }'."\n";

		// ファイルアウトプット機能の追加
		// リクエストオブジェクトに乗せられたヘッダ
		$string	.= 'if( count( $request_object->headers ) > 0 ) {'."\n";
		$string	.= 'foreach( $request_object->headers as $hkey => $hval ) {'."\n";
		$string	.= 'header("$hkey: $hval");'."\n";
		$string	.= '}'."\n";
		$string	.= '}'."\n";
		
		// リダイレクトの場合		
		$string	.= 'if( !is_null( $request_object->redirect_url ) && strlen($request_object->redirect_url)> 0 ) {'."\n";
		$string	.= 'header("Location: ".$request_object->redirect_url);'."\n";
		$string	.= "die;\n";
		$string	.= '}';
		// レスポンスファイルが指定されている場合
		$string	.= 'else if( !is_null( $request_object->response_file_path ) && strlen( $request_object->response_file_path ) > 0 && file_exists( $request_object->response_file_path ) ){'."\n";
		$string	.= 'readfile($request_object->response_file_path);'."\n";
		// レスポンスボディが指定されている場合
		$string	.= '} else if( !is_null( $request_object->response_body ) && strlen( $request_object->response_body ) > 0 ) {'."\n";
		$string	.= 'echo $request_object->response_body;'."\n";
		// レスポンスが何も指定されていないなら継続処理
		$string	.= "} else { \n\n?>";
		
		// テキスト出力があるなら出力
		$string	.= $this->out_body_strings;
		
		// 出力を文字列に取得する
		$string .= "<?php\n";
		$string .= '$outstr = ob_get_clean();'."\n";

		// 表示文字列に対する処理実行コードを記述
		foreach( $build_information_object->convert_view_process_hash as $code_array ) {
			foreach( $code_array as $code ) {
				$string	.= $code."\n";
			}
		}

		// 最終的にできた表示文字列をフラッシュする
		$string .= "ob_start('".$build_information_object->output_handler."');\n";
		$string .= "ob_implicit_flush( false );\n";
		$string .= "mb_language('".$build_information_object->output_language."');\n";
		$string .= 'echo $outstr;'."\n";
		$string .= "mb_http_output('".$build_information_object->output_charset."');\n\n";
		$string .= 'ob_flush();'."\n";
		$string .= "}\n";

		// 表示後実行コードを記述
		foreach( $build_information_object->postview_process_hash as $code_array ) {
			foreach( $code_array as $code ) {
				$string	.= $code."\n";
			}
		}

		// フラッシュ後にモジュール後処理の実行
		$string .= '$controller->post_process_all(); ';
		$string .= "?>\n";
		
		$fp		= @fopen( $bin_file_path, "w" );
		if( $fp ) {
			if (@flock($fp, LOCK_EX)) {
				fwrite( $fp, $string );
				flock($fp, LOCK_UN);
				@fclose( $fp );
				@chmod( $bin_file_path, 0666 );
			} else {
				@fclose( $fp );
				@chmod( $bin_file_path, 0666 );
				die('Core Error: Can\'t create execute file!!');
			}
		} else {
			die('Core Error: Can\'t create execute file!!');
		}
		
		// ビルドタイムスタンプファイル作成
		$build_file_path	= $bin_file_path.".build.php";
		$bin_file_path	= str_replace('\\','\\\\',$bin_file_path );
		$string	= "<?php\n";
		$string	.= '$build=false;'."\n";
		$target_file_path	= $build_information_object->execute_file_path;
		$target_file_path	= str_replace('\\','\\\\',$target_file_path );
		$string	.= 'if( file_exists("'.$target_file_path.'") ){if( filemtime("'.$bin_file_path.'") < filemtime("'.$target_file_path.'") ) { $build=true; }}'."\n";
		// 比較ファイルとのタイムスタンプ比較
		foreach( $build_information_object->compare_time_file_array as $compare_file_path ) {
			$compare_file_path	= str_replace('\\','\\\\',$compare_file_path);
			$compare_file_path	= str_replace('"','\\"',$compare_file_path);
			// ファイルが存在する場合、ビルドファイルより更新日が新しいなら再ビルド、ファイルがなくなっていても再ビルド
			$string	.= 'if( file_exists("'.$compare_file_path.'") ){if( filemtime("'.$bin_file_path.'") < filemtime("'.$compare_file_path.'") ) { $build=true; }} else { $build=true; }'."\n";
		}
		// 存在確認ファイル確認
		foreach( $build_information_object->confirm_exists_file_array as $compare_file_path ) {
			if( strlen($compare_file_path) > 0 ) {
				$compare_file_path	= str_replace('\\','\\\\',$compare_file_path);
				$compare_file_path	= str_replace('"','\\"',$compare_file_path);
				// ファイルができていたら再ビルド
				$string	.= 'if( file_exists("'.$compare_file_path.'") ){ $build=true; }'."\n";
			}
		}
		
		$string	.= "?>\n";

		$fp		= @fopen( $build_file_path, "w" );
		if( $fp ) {
			if (@flock($fp, LOCK_EX)) {
				fwrite( $fp, $string );
				flock($fp, LOCK_UN);
				@fclose( $fp );
				@chmod( $build_file_path, 0666 );
			} else {
				@fclose( $fp );
				@chmod( $build_file_path, 0666 );
				die('Core Error: Can\'t create build file!!');
			}
		} else {
			die('Core Error: Can\'t create build file!!');
		}
	}
}
?>