/*
 * source code is stolen from
 *   http://www.jah.ne.jp/~naoyuki/Writings/ExtIos.html
 *
 *
 */
#ifndef ZLIBFILTER_H
#define ZLIBFILTER_H

#include <streambuf>
#include <vector>
#include <zlib.h>

template <class Ch,class Tr=std::char_traits<Ch> >
class basic_zfilterbuf : public std::basic_streambuf<Ch,Tr> {
public:
  typedef std::basic_streambuf<Ch,Tr> superclass;

  /* mikita add */
  typedef typename Tr::int_type int_type;

public:
  // o̓RXgN^
  basic_zfilterbuf(std::basic_ostream<Ch,Tr>& os)
  {
    out=&os;
    in=NULL;

    sbuffer.resize(4096);
    dbuffer.resize(sbuffer.size());
    buffer  =sbuffer.begin();
    size    =sbuffer.size();
    setp(sbuffer.begin(),sbuffer.begin(),sbuffer.end());

    // zlib 
    zs.zalloc   =Z_NULL;
    zs.zfree    =Z_NULL;
    zs.opaque   =Z_NULL;
    if(deflateInit(&zs,Z_DEFAULT_COMPRESSION)!=Z_OK){
      throw zlib_exception(zs.msg);
    }
    iflush      =Z_NO_FLUSH;
    oflush      =Z_NO_FLUSH;
  }
  // ̓RXgN^
  basic_zfilterbuf(std::basic_istream<Ch,Tr>& is)
  {
    out=NULL;
    in=&is;

    sbuffer.resize(4096);
    dbuffer.resize(sbuffer.size());
    buffer  =dbuffer.begin();
    size    =dbuffer.size();
    setg(dbuffer.begin(),dbuffer.end(),dbuffer.end());

    // zlib 
    zs.zalloc   =Z_NULL;
    zs.zfree    =Z_NULL;
    zs.opaque   =Z_NULL;
    zs.next_in  =Z_NULL;
    zs.avail_in =0;
    if(inflateInit(&zs)!=Z_OK){
      throw zlib_exception(zs.msg);
    }
    iflush      =Z_NO_FLUSH;
    oflush      =Z_NO_FLUSH;
  }
  // fXgN^
  ~basic_zfilterbuf(void)
  {
    oflush=Z_FINISH;
    iflush=Z_FINISH;
    sync();

    if(out!=NULL){
      if(deflateEnd(&zs)!=Z_OK){
	throw zlib_exception(zs.msg);
      }
    }
    if(in!=NULL){
      if(inflateEnd(&zs)!=Z_OK){
	throw zlib_exception(zs.msg);
      }
    }
  }

protected:
  // setbuf
  std::basic_streambuf<Ch,Tr>* setbuf(Ch* b,int s)
  {
    if(out!=NULL){
      sbuffer.resize(0);
      setp(b,b,b+s);
    }
    if(in!=NULL){
      dbuffer.resize(0);
      setg(b,b,b+s);
    }
    buffer  =b;
    size    =s;
    return this;
  }

  // overflow
  int_type overflow(int_type c=Tr::eof())
  {
    compress();
    if(c!=Tr::eof()){
      *pptr()=Tr::to_char_type(c);
      pbump(1);
      return Tr::not_eof(c);
    } else {
      return Tr::eof();
    }
  }

  // underflow
  int_type underflow(void)
  {
    if(egptr()<=gptr()){
      if(iflush==Z_FINISH){
	return Tr::eof();
      }
      decompress();
      if(egptr()<=gptr()){
	return Tr::eof();
      }
    }
    return Tr::to_int_type(*gptr());
  }

  // sync
  int sync(void)
  {
    if(in!=NULL){
    }
    if(out!=NULL){
      compress();
    }

    return 0;
  }

protected:
  // compress
  void compress(void)
  {
    zs.next_in  =(unsigned char*)buffer;
    zs.avail_in =pptr()-buffer;
    zs.next_out =(unsigned char*)dbuffer.begin();
    zs.avail_out=dbuffer.size();

    for(;;){
      int status = deflate(&zs, oflush);
      if(status==Z_STREAM_END){
	// 
	out->write(dbuffer.begin(),dbuffer.size()-zs.avail_out);
	return;
      }
      if(status!=Z_OK){
	throw zlib_exception(zs.msg);
      }
      if(zs.avail_in==0){
	// ̓obt@s
	out->write(dbuffer.begin(),dbuffer.size()-zs.avail_out);
	setp(buffer,buffer,buffer+size);
	return;
      }
      if(zs.avail_out==0){
	// o̓obt@s
	out->write(dbuffer.begin(),dbuffer.size());
	zs.next_out =(unsigned char*)dbuffer.begin();
	zs.avail_out=dbuffer.size();
      }
    }
  }

  // decompress
  void decompress(void)
  {
    zs.next_out =(unsigned char*)buffer;
    zs.avail_out=size;

    for(;;){
      if(zs.avail_in==0){
	// ̓obt@s
	in->read(sbuffer.begin(),sbuffer.size());
	zs.next_in  =(unsigned char*)sbuffer.begin();
	zs.avail_in =in->gcount();
	if(zs.avail_in==0){
	  iflush=Z_FINISH;
	}
      }
      if(zs.avail_out==0){
	// o̓obt@s
	setg(buffer,buffer,buffer+size);
	return;
      }
      int status = inflate(&zs, iflush);
      if(status==Z_STREAM_END){
	// 
	setg(buffer,buffer,buffer+size-zs.avail_out);
	return;
      }
      if(status!=Z_OK){
	throw zlib_exception(zs.msg);
      }
    }
  }

private:
  std::basic_ostream<Ch,Tr>* out;
  std::basic_istream<Ch,Tr>* in;

  Ch*     buffer;
  int     size;

  std::vector<Ch> sbuffer;
  std::vector<Ch> dbuffer;

  z_stream    zs;
  int         iflush;
  int         oflush;

};

// 񈳏kk
template <class Ch,class Tr=std::char_traits<Ch> >
class basic_ozfilter : public std::basic_ostream<Ch,Tr> {
public:
  basic_ozfilter(std::ostream& os)
    : std::basic_ostream<Ch,Tr>(new basic_zfilterbuf<Ch,Tr>(os))
  {
  }

  ~basic_ozfilter(void)
  {
    flush();
    delete rdbuf();
  }
};

// k񈳏k
template <class Ch,class Tr=std::char_traits<Ch> >
class basic_izfilter : public std::basic_istream<Ch,Tr> {
public:
  basic_izfilter(std::istream& is)
    : std::basic_istream<Ch,Tr>(new basic_zfilterbuf<Ch,Tr>(is))
  {
  }

  ~basic_izfilter(void)
  {
    delete rdbuf();
  }
};

typedef basic_ozfilter<char> ozfilter;
typedef basic_izfilter<char> izfilter;

#endif//ZLIBFILTER_H

