//---------------------------------------------------------------------------

#ifndef SiteH
#define SiteH
//---------------------------------------------------------------------------
#include <string>
#include <vector>

typedef std::string  NameString;
typedef std::wstring URLString;
typedef std::wstring ScriptString;
class Site {
public:
  Site() : id_(-1) {}
  Site( const int newId, const NameString & newName,
        const URLString & newUrl, const std::string & scriptName );

  const int id() const { return id_; }
  const NameString & name() const { return name_; }
  const URLString url( const std::string & word ) const ;
  const ScriptString & script() const { return script_; }
private:
  void loadScript( const std::string & scriptName );
private:
  int id_;
  NameString name_;
  URLString url_;
  ScriptString script_;
};

typedef std::vector<Site> SiteList;

//---------------------------------------------------------------------------
#endif
