//---------------------------------------------------------------------------


#pragma hdrstop

#include "Site.h"
#include <cassert>
#include <vcl.h>
#include <fstream>
#include <windows.h>
//---------------------------------------------------------------------------

#define URL_KEYWORD L"*"

Site::Site( const int newId, const NameString & newName,
 const URLString & newUrl, const std::string & scriptName )
    : id_(newId), name_(newName), url_(newUrl) {
   loadScript( scriptName );
}

const URLString Site::url( const std::string & word ) const {

  URLString result;
  URLString::size_type pos = url_.find( URL_KEYWORD );
  assert( URLString::npos != pos );
  result.insert( result.end(), url_.begin(), url_.begin() + pos );
  result.insert( result.end(), word.begin(), word.end() );
  result.insert( result.end(), url_.begin() + pos+1, url_.end() );
  return result;
}

void Site::loadScript( const std::string & scriptName ) {
  if (scriptName.empty()) { return; }

  std::string filename
    = std::string( ExtractFileDir( Application->ExeName ).c_str() )
      + "\\" + scriptName;

  std::ifstream in ( filename.c_str() );

  while(in) {
    int c = in.get();
    if (in) {
      script_.push_back( c );
    }//if
  }//while


}

#pragma package(smart_init)
