//---------------------------------------------------------------------------


#pragma hdrstop

#include "Preferences.h"
#include <vcl.h>
#include <boost/lexical_cast.hpp>

//---------------------------------------------------------------------------

#pragma package(smart_init)

#define SECTION_BEHAVIOR      "Behavior"
#define ENTRY_READ_CLIPBOARD  "ReadClipboard"
#define ENTRY_SEARCH_ON_FOCUS "SearchOnFocus"
#define ENTRY_SEARCH_ON_DRAG_ENTER "SearchOnDragEnter"
#define ENTRY_CALL_SCRIPT     "CallScript"
#define ENTRY_HISTORY_LIMIT   "HistoryLimit"
#define ENTRY_WINDOW_WIDTH    "WindowWidth"
#define ENTRY_WINDOW_HEIGHT   "WindowHeight"

#define SECTION_SITES         "Sites"
#define ENTRY_NUM_SITES       "NumSites"
#define ENTRY_SITE_PREFIX     "Site"
#define SUBENTRY_NAME         "Name"
#define SUBENTRY_URL          "URL"
#define SUBENTRY_SCRIPT_NAME  "ScriptName"
#define DOT "."

Preferences & Preferences::instance() {
  static Preferences result;
  return result;
}//instance

Preferences::Preferences()
 : inifile_( new TIniFile( ChangeFileExt( Application->ExeName, ".ini" )) ),
   sites_(readSites()),
   readClipboard_
     ( inifile_->ReadBool( SECTION_BEHAVIOR, ENTRY_READ_CLIPBOARD, true ) ),
   searchOnFocus_
     ( inifile_->ReadBool( SECTION_BEHAVIOR, ENTRY_SEARCH_ON_FOCUS, true ) ),
   searchOnDragEnter_
     ( inifile_->ReadBool( SECTION_BEHAVIOR, ENTRY_SEARCH_ON_DRAG_ENTER,
       true ) ),
   callScript_
     ( inifile_->ReadBool( SECTION_BEHAVIOR, ENTRY_CALL_SCRIPT,
       true ) ),
   historyLimit_
     ( inifile_->ReadInteger( SECTION_BEHAVIOR, ENTRY_HISTORY_LIMIT, 20 ) ),
   windowWidth_(inifile_->ReadInteger( SECTION_BEHAVIOR,
                                       ENTRY_WINDOW_WIDTH, 480 ) ),
   windowHeight_(inifile_->ReadInteger( SECTION_BEHAVIOR,
                                        ENTRY_WINDOW_HEIGHT, 320 ) )
{}

SiteList* Preferences::readSites() {
  SiteList* result = new SiteList();

  const int numSites
    = inifile_->ReadInteger( SECTION_SITES, ENTRY_NUM_SITES, 0 );

  for (int i=0; i<numSites; ++i) {
    result->push_back( readSite( i ) );
  }//for

  return result;
}

const Site Preferences::readSite( int index ) {
  const std::string prefix
    = ENTRY_SITE_PREFIX + boost::lexical_cast<std::string>(index) + DOT;
  const std::string nameKey = prefix + SUBENTRY_NAME;
  const std::string urlKey  = prefix + SUBENTRY_URL;
  const std::string scriptNameKey = prefix + SUBENTRY_SCRIPT_NAME;
  const std::string name
    = inifile_->ReadString( SECTION_SITES, nameKey.c_str(), "" ).c_str();
  const std::string url
    = inifile_->ReadString( SECTION_SITES, urlKey.c_str(),  ""  ).c_str();
  const std::string scriptName
    = inifile_->ReadString( SECTION_SITES, scriptNameKey.c_str(),  ""  ).c_str();

  return Site( index, name, URLString( url.begin(), url.end() ), scriptName );
}

void Preferences::readClipboard( bool value ) {
  readClipboard_ = value;
  inifile_->WriteBool( SECTION_BEHAVIOR, ENTRY_READ_CLIPBOARD, value );
}

void Preferences::searchOnFocus( bool value ) {
  searchOnFocus_ = value;
  inifile_->WriteBool( SECTION_BEHAVIOR, ENTRY_SEARCH_ON_FOCUS, value );
}

void Preferences::searchOnDragEnter( bool value ) {
  searchOnDragEnter_ = value;
  inifile_->WriteBool( SECTION_BEHAVIOR, ENTRY_SEARCH_ON_DRAG_ENTER, value );
}

void Preferences::callScript( bool value ) {
  callScript_ = value;
  inifile_->WriteBool( SECTION_BEHAVIOR, ENTRY_CALL_SCRIPT, value );

}

void  Preferences::windowWidth( int value ) {
  windowWidth_ = value;
  inifile_->WriteInteger( SECTION_BEHAVIOR, ENTRY_WINDOW_WIDTH, value );
}

void  Preferences::windowHeight( int value ) {
  windowHeight_ = value;
  inifile_->WriteInteger( SECTION_BEHAVIOR, ENTRY_WINDOW_HEIGHT, value );
}



