//---------------------------------------------------------------------------

#ifndef MainFormH
#define MainFormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include "SHDocVw_OCX.h"
#include <AppEvnts.hpp>
#include <ComCtrls.hpp>
#include <OleCtrls.hpp>

#include "SearchBroker.h"
#include "DropAcceptor.h"
#include "Script.h"
#include <ExtCtrls.hpp>
#include <string>

//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
class TMainFormUI : public TForm
{
__published:	// IDE Ǘ̃R|[lg
        TTabControl *Pages;
        TStatusBar *RecordStatusBar;
        TComboBox *WordEdit;
        TButton *PrefButton;
        TCppWebBrowser *View;
        TApplicationEvents *Events;
        void __fastcall FormResize(TObject *Sender);
        void __fastcall PrefButtonClick(TObject *Sender);
        void __fastcall EventsShortCut(TWMKey &Msg, bool &Handled);
        void __fastcall WordEditEnter(TObject *Sender);
        void __fastcall EventsActivate(TObject *Sender);
        void __fastcall FormActivate(TObject *Sender);
        void __fastcall WordEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall PagesChange(TObject *Sender);
        void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
        void __fastcall FormShow(TObject *Sender);
        void __fastcall ViewDocumentComplete(TObject *Sender,
          LPDISPATCH pDisp, Variant *URL);

public:	// [U[錾
  void dropped( const std::string & word );
private:	// [U[錾
  enum { CLIPBOARD_BUFFER_SIZE = 128 };
  const std::string  readFromClipboard();
  bool tryWordFill( const std::string & word );
  void updateWordList( const std::string word );
  void activate();
  void doSearch();
  void setupDragDrop();

  SearchBroker searchBroker_;
  DropAcceptor dropAcceptor_;
  ScriptRunner scriptRunner_;
public:		// [U[錾
        __fastcall TMainFormUI(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TMainFormUI *MainFormUI;
//---------------------------------------------------------------------------
#endif
