//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MainForm.h"

#include "PrefForm.h"
#include "Preferences.h"
#include <vcl/clipbrd.hpp>
#include <windows.h>
#include <ctype>
#include <cstdlib>
#include <boost/lexical_cast.hpp> //debug
#include <string>
#include <cassert>

#include <mshtmhst.h>

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "SHDocVw_OCX"
#pragma resource "*.dfm"
TMainFormUI *MainFormUI;
//---------------------------------------------------------------------------

static std::string cleanup( const std::string & str ) {
  if (str.empty()) { return str; }

  std::string::const_iterator i = str.begin(), j = str.end();

  while (!std::isalpha(*i)) {
    if (str.end() == i) { return ""; }
    ++i;
  }

  while (!std::isalpha(*j)) {
    if (i >= j) { return ""; }
    --j;
  }

  return std::string( i, boost::next(j) );
}//cleanup

static bool allowed_string ( const std::string & str ) {

  if (str.empty()) { return false; }

  bool contains_alphabet = false;
  for (std::string::const_iterator i = str.begin();
       i != str.end(); ++i) {
       bool isalphabet = std::isalpha( *i );
       bool isblank    = std::isspace( *i );
    if ( !isalphabet && !isblank) {
      return false;
    } else if (isalphabet) {
      contains_alphabet = true;
    }//else
  }//for

  return contains_alphabet;
}

void TMainFormUI::updateWordList( const std::string word ) {

  int index = WordEdit->Items->IndexOf( word.c_str() );
  if (-1 != index) {
    WordEdit->Items->Delete( index );
  }//if

  WordEdit->Items->Insert( 0, word.c_str() );
}

const std::string TMainFormUI::readFromClipboard() {

   if(!IsClipboardFormatAvailable(CF_TEXT)) {
     return "";
   }

   char buf[CLIPBOARD_BUFFER_SIZE];
   memset( buf, 0x00, sizeof(buf) );
   Clipboard()->GetTextBuf( buf, CLIPBOARD_BUFFER_SIZE );
   return std::string( buf );
}//readFromClipboard

bool TMainFormUI::tryWordFill( const std::string & word ) {
   if (!word.empty()  && allowed_string( word )) {
     WordEdit->Text = word.c_str();
     return true;
   } else {
     return false;
   }
}

void TMainFormUI::dropped( const std::string & word ) {
  tryWordFill( cleanup( word ) );
  doSearch();
}


void TMainFormUI::activate() {

  bool read = false;
  if (Preferences::instance().readClipboard()) {
    read = tryWordFill( cleanup( readFromClipboard() ) );
  }//if

  FocusControl( WordEdit );

  if (read && Preferences::instance().searchOnFocus()) {
    doSearch();
  }//if
}

void TMainFormUI::doSearch() {
  searchBroker_.doSearch
    ( SearchRequest( Pages->TabIndex, WordEdit->Text.c_str() ) );

  updateWordList( WordEdit->Text.c_str() );
  WordEdit->ItemIndex = 0;

}
//---------------------------------------------------------------------------
__fastcall TMainFormUI::TMainFormUI(TComponent* Owner)
        : TForm(Owner), searchBroker_(View), dropAcceptor_(this)
{
  Width  = Preferences::instance().windowWidth();
  Height = Preferences::instance().windowHeight();

  for (SiteList::const_iterator i = searchBroker_.sites()->begin();
       i != searchBroker_.sites()->end(); ++i) {
    Pages->Tabs->Insert( i->id(), i->name().c_str() );
  }//for
}
//---------------------------------------------------------------------------
void __fastcall TMainFormUI::FormResize(TObject *Sender)
{
   Pages->Width  = this->ClientWidth  - Pages->Left;
   Pages->Height = this->ClientHeight- ((Pages->Top)+(RecordStatusBar->Height));
   View->Top    = Pages->DisplayRect.Top;
   View->Left   = Pages->DisplayRect.Left;
   View->Width  = Pages->DisplayRect.Width();
   View->Height = Pages->DisplayRect.Height();
}
//---------------------------------------------------------------------------

void __fastcall TMainFormUI::PrefButtonClick(TObject *Sender)
{
  PrefFormUI->ShowModal();
}
//---------------------------------------------------------------------------

void __fastcall TMainFormUI::EventsShortCut(TWMKey &Msg, bool &Handled)
{
  static const int ZERO_CHAR = '0';

  if (0 == HIBYTE(GetKeyState( VK_CONTROL ) )) { return; }

  if (VK_TAB == Msg.CharCode) {
    /* Don't mind: WordEdit ɃtH[JX킹Ȃ̌ۉp */
    FocusControl( PrefButton );
    FocusControl( WordEdit );
    WordEdit->SelectAll();
  } else {
    int num = (Msg.CharCode-1) - ZERO_CHAR;
    if(0 <= num && num < Pages->Tabs->Count) {
      Pages->TabIndex = num;
      PagesChange( Pages );
    }//if
    Handled = true;
  }//if
}

//---------------------------------------------------------------------------


void __fastcall TMainFormUI::WordEditEnter(TObject *Sender)
{
  activate();
}
//---------------------------------------------------------------------------

void __fastcall TMainFormUI::EventsActivate(TObject *Sender)
{
  activate();
}
//---------------------------------------------------------------------------

void __fastcall TMainFormUI::FormActivate(TObject *Sender)
{
  activate();
}
//---------------------------------------------------------------------------

void __fastcall TMainFormUI::WordEditKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
  if (VK_RETURN == Key) { doSearch(); }
}
//---------------------------------------------------------------------------

void __fastcall TMainFormUI::PagesChange(TObject *Sender)
{
  doSearch();
}
//---------------------------------------------------------------------------

void __fastcall TMainFormUI::FormClose(TObject *Sender,
      TCloseAction &Action)
{
  Preferences::instance().windowWidth( Width );
  Preferences::instance().windowHeight( Height );
}
//---------------------------------------------------------------------------

void __fastcall TMainFormUI::FormShow(TObject *Sender)
{
  dropAcceptor_.setupView();
}
//---------------------------------------------------------------------------

//see: http://msdn.microsoft.com/workshop/browser/webbrowser/tutorials/webocstream.asp
bool is_identity( IWebBrowser2* browser, IDispatch* disp ) {
  HRESULT hr;
  IUnknown* pUnkBrowser = NULL;
  IUnknown* pUnkDisp    = NULL;
  bool result = false;

  // Is this the DocumentComplete event for the top frame window?
  // Check COM identity: compare IUnknown interface pointers.
  hr = browser->QueryInterface( IID_IUnknown,  (void**)&pUnkBrowser );
  if ( SUCCEEDED(hr) ) {
    hr = disp->QueryInterface( IID_IUnknown,  (void**)&pUnkDisp );
    if ( SUCCEEDED(hr) )  {
      result = (pUnkBrowser == pUnkDisp);
      pUnkDisp->Release();
    }
    pUnkBrowser->Release();
  }
  return result;
}

//---------------------------------------------------------------------------
void __fastcall TMainFormUI::ViewDocumentComplete
  (TObject *Sender, LPDISPATCH pDisp, Variant *URL) {
  dropAcceptor_.setupDocument();//no longer usefull

  if (Preferences::instance().callScript() &&
      is_identity( View->ControlInterface, pDisp )) {
    scriptRunner_.invoke
      ( Preferences::instance().sites()->at(Pages->TabIndex).script(),
        View->Document );
  }//if
  
}
//---------------------------------------------------------------------------

