/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.validator.type.internal;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.internal.util.AnnotationUtil;
import com.small_it_office.flatserve.validator.rule.DateFormat;
import com.small_it_office.flatserve.validator.type.internal.TypeValidation;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTypeValidation
implements TypeValidation<Date> {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    @Override
    public String getInvalidTypeMessage(MessageResource messageResource, String value, Annotation[] annotations) {
        DateFormat dateFormatAnnotation = AnnotationUtil.findAnnotation(annotations, DateFormat.class);
        String format = dateFormatAnnotation == null ? DEFAULT_DATE_FORMAT : dateFormatAnnotation.value();
        return messageResource.getString("message.error.type.date", value, format);
    }

    @Override
    public Date getNullValue() {
        return null;
    }

    @Override
    public boolean isValidType(String value, Annotation[] annotations) {
        if (value == null) {
            this.logger.debug("FSVLD-LOGD020", new Object[0]);
            return true;
        }
        SimpleDateFormat format = this.createDateFormat(annotations);
        this.logger.debug("FSVLD-LOGD025", new Object[]{value, format.toPattern()});
        ParsePosition position = new ParsePosition(0);
        Date date = format.parse(value, position);
        if (date == null) {
            this.logger.debug("FSVLD-LOGD022", new Object[]{value, position.getErrorIndex() + 1});
            return false;
        }
        if (position.getIndex() < value.length()) {
            this.logger.debug("FSVLD-LOGD023", new Object[]{value, position.getIndex() + 1});
            return false;
        }
        return true;
    }

    @Override
    public Date validTypeValue(String value, Annotation[] annotations) {
        if (value == null) {
            return null;
        }
        SimpleDateFormat format = this.createDateFormat(annotations);
        try {
            return format.parse(value);
        }
        catch (ParseException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    private SimpleDateFormat createDateFormat(Annotation[] annotations) {
        DateFormat dateFormatAnnotation = AnnotationUtil.findAnnotation(annotations, DateFormat.class);
        String formatString = dateFormatAnnotation == null ? DEFAULT_DATE_FORMAT : dateFormatAnnotation.value();
        SimpleDateFormat format = new SimpleDateFormat(formatString);
        format.setLenient(false);
        return format;
    }
}

