/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.validator.internal.util;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.ValidationError;
import com.small_it_office.flatserve.validator.ValidationErrors;
import java.text.MessageFormat;

public class ErrorUtil {
    private ErrorUtil() {
    }

    public static String createMessage(MessageResource messageResource, String specifiedMessage, Object ... params) {
        String result;
        String trimmedMessage = specifiedMessage.trim();
        if (trimmedMessage.matches("^\\{[^\\s\\{\\}].+\\}$")) {
            String key = trimmedMessage.substring(1, trimmedMessage.length() - 1);
            result = messageResource.getString(key, params);
        } else {
            result = MessageFormat.format(specifiedMessage, params);
        }
        return result;
    }

    public static String addItemNameMessage(MessageResource messageResource, String itemName, String message) {
        if (itemName == null) {
            return message;
        }
        String itemNameMessage = messageResource.getString("message.item_name", itemName);
        return itemNameMessage + message;
    }

    public static void createValidationErrorObject(RequestContext context, String paramName, String valueString, String message) {
        ErrorUtil.createValidationErrorObject(context, paramName, new String[]{valueString}, message, 0);
    }

    public static void createValidationErrorObject(RequestContext context, String paramName, String[] valueString, String message, int arrayIndex) {
        ValidationError error = new ValidationError();
        error.setParameterName(paramName);
        error.setValue(valueString[arrayIndex]);
        error.setMessage(message);
        error.setArrayIndex(arrayIndex);
        ((ValidationErrors)context.getAttribute("varidator.errors")).add(error);
    }
}

