/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.validator.internal;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.internal.util.ErrorUtil;
import com.small_it_office.flatserve.validator.internal.util.TypeConvertUtil;
import com.small_it_office.flatserve.validator.rule.ValidationRule;
import com.small_it_office.flatserve.validator.rule.ValidationRuleClass;
import com.small_it_office.flatserve.validator.rule.ValidationRuleException;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationRuleList {
    private List<ValidationRule> rules;
    private List<Annotation> ruleAnnotations;
    private MessageResource messageResource;
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    private ValidationRuleList(List<ValidationRule> rules, List<Annotation> ruleAnnotations, MessageResource messageResource) {
        this.rules = rules;
        this.ruleAnnotations = ruleAnnotations;
        this.messageResource = messageResource;
    }

    public static ValidationRuleList assignRules(Annotation[] annotations, MessageResource messageResource) {
        ArrayList<ValidationRule> rules = new ArrayList<ValidationRule>();
        ArrayList<Annotation> ruleAnnotations = new ArrayList<Annotation>();
        for (Annotation anno : annotations) {
            ValidationRuleClass ruleClassAnnotation = anno.annotationType().getAnnotation(ValidationRuleClass.class);
            if (ruleClassAnnotation == null) continue;
            ValidationRule rule = ValidationRuleList.createRuleInstance(ruleClassAnnotation);
            rules.add(rule);
            ruleAnnotations.add(anno);
        }
        ValidationRuleList instance = new ValidationRuleList(rules, ruleAnnotations, messageResource);
        return instance;
    }

    private static ValidationRule createRuleInstance(ValidationRuleClass ruleClassAnnotation) {
        ValidationRule rule;
        try {
            rule = ruleClassAnnotation.value().newInstance();
        }
        catch (Exception e) {
            throw new ValidationRuleException(Message.get((String)"FSVLD-ERR002", (Object[])new Object[]{ruleClassAnnotation.value().getName()}), e);
        }
        return rule;
    }

    public boolean validateRules(RequestContext context, String paramName, String valueString, Object value, String itemName) {
        for (int i = 0; i < this.rules.size(); ++i) {
            ValidationRule rule = this.rules.get(i);
            this.logger.info("FSVLD-LOGI001", new Object[]{rule.getClass().getName(), paramName, valueString});
            boolean validationResult = rule.isValid(value, valueString, this.ruleAnnotations.get(i));
            this.logger.info("FSVLD-LOGI002", new Object[]{rule.getClass().getName(), paramName, valueString, validationResult});
            if (validationResult) continue;
            String message = rule.getMessage(this.messageResource, valueString, this.ruleAnnotations.get(i));
            message = ErrorUtil.addItemNameMessage(this.messageResource, itemName, message);
            ErrorUtil.createValidationErrorObject(context, paramName, valueString, message);
            return false;
        }
        return true;
    }

    public boolean validateRules(RequestContext context, String paramName, String[] valueString, Object value, String itemName) {
        for (int i = 0; i < this.rules.size(); ++i) {
            Object[] objArray;
            ValidationRule rule = this.rules.get(i);
            Annotation ruleAnnotation = this.ruleAnnotations.get(i);
            if (!(value == null ? !this.validateNull(context, paramName, rule, ruleAnnotation, itemName) : !this.validateArrayElement(context, paramName, valueString, objArray = TypeConvertUtil.autoboxArray(value), rule, ruleAnnotation, itemName))) continue;
            return false;
        }
        return true;
    }

    private boolean validateNull(RequestContext context, String paramName, ValidationRule rule, Annotation ruleAnnotation, String itemName) {
        this.logger.info("FSVLD-LOGI003", new Object[]{rule.getClass().getName(), paramName});
        boolean validationResult = rule.isValid(null, null, ruleAnnotation);
        this.logger.info("FSVLD-LOGI004", new Object[]{rule.getClass().getName(), paramName, validationResult});
        if (!validationResult) {
            String message = rule.getMessage(this.messageResource, null, ruleAnnotation);
            message = ErrorUtil.addItemNameMessage(this.messageResource, itemName, message);
            ErrorUtil.createValidationErrorObject(context, paramName, null, message);
        }
        return validationResult;
    }

    private boolean validateArrayElement(RequestContext context, String paramName, String[] valueString, Object[] value, ValidationRule rule, Annotation ruleAnnotation, String itemName) {
        boolean result = true;
        for (int j = 0; j < valueString.length; ++j) {
            this.logger.info("FSVLD-LOGI005", new Object[]{rule.getClass().getName(), paramName, j, valueString[j]});
            boolean validationResult = rule.isValid(value[j], valueString[j], ruleAnnotation);
            this.logger.info("FSVLD-LOGI006", new Object[]{rule.getClass().getName(), paramName, j, valueString[j], validationResult});
            if (validationResult) continue;
            result = false;
            String message = rule.getMessage(this.messageResource, valueString[j], ruleAnnotation);
            message = ErrorUtil.addItemNameMessage(this.messageResource, itemName, message);
            ErrorUtil.createValidationErrorObject(context, paramName, valueString, message, j);
        }
        return result;
    }

    List<ValidationRule> getRules() {
        return this.rules;
    }

    List<Annotation> getRuleAnnotations() {
        return this.ruleAnnotations;
    }

    MessageResource getMessageResource() {
        return this.messageResource;
    }
}

