/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.validator;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.Populator;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.ValidationErrors;
import com.small_it_office.flatserve.validator.internal.PopulatorValidationException;
import com.small_it_office.flatserve.validator.internal.ValidationRuleList;
import com.small_it_office.flatserve.validator.processor.internal.ParameterValidationProcessorFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatablePopulator
extends Populator {
    private static ValidatablePopulator instance;
    private MessageResource messageResource;
    private ParameterValidationProcessorFactory processorFactory;

    private ValidatablePopulator(MessageResource messageResource) {
        this.messageResource = messageResource;
        this.processorFactory = new ParameterValidationProcessorFactory(messageResource);
    }

    public static void init(MessageResource messageResource) {
        instance = new ValidatablePopulator(messageResource);
    }

    public static ValidatablePopulator getInstance() {
        return instance;
    }

    public <T> T populate(Class<T> beanType) {
        Object bean = super.populate(beanType);
        RequestContext context = RequestContext.get();
        ValidationErrors errors = (ValidationErrors)context.getAttribute("varidator.errors");
        if (errors.hasError()) {
            context.setAttribute("validator.params_on_error", (Object)new Object[]{bean});
            throw new PopulatorValidationException(bean);
        }
        return (T)bean;
    }

    protected void processNullParameter(Object bean, Field field, String requestParamName) {
        super.processNullParameter(bean, field, requestParamName);
        field.setAccessible(true);
        try {
            this.setValueToField(bean, field, requestParamName, null);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    protected void setValueToField(Object bean, Field field, String paramName, String[] paramValues) throws IllegalAccessException {
        RequestContext context = RequestContext.get();
        Annotation[] annotations = field.getAnnotations();
        ValidationRuleList ruleList = ValidationRuleList.assignRules(annotations, this.messageResource);
        Object value = this.processorFactory.get(field.getType()).process(context, ruleList, paramName, annotations);
        if (value != null || !field.getType().isPrimitive()) {
            field.set(bean, value);
        }
    }
}

