/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.core.request.internal;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.Param;
import com.small_it_office.flatserve.core.request.RequestBody;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapping;
import com.small_it_office.flatserve.core.request.internal.util.RequestUtil;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;

public class StringParameterMapping
implements RequestParameterMapping {
    private Config config;
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public StringParameterMapping(Config config) {
        this.config = config;
    }

    public String mapParameter(RequestContext context, Annotation[] annotations) {
        this.logger.debug("FS-LOGD020", "String", this.getClass().getSimpleName());
        HttpServletRequest request = context.getHttpServletRequest();
        String param = null;
        for (Annotation anno : annotations) {
            if (anno.annotationType() == Param.class) {
                String requestParamName = ((Param)anno).value();
                param = request.getParameter(((Param)anno).value());
                if (param == null) {
                    this.logger.debug("FS-LOGD025", "String", requestParamName);
                } else {
                    this.logger.debug("FS-LOGD026", "String", requestParamName);
                }
                return param;
            }
            if (anno.annotationType() != RequestBody.class) continue;
            String encoding = this.config.getRequestEncoding();
            try {
                param = new String(RequestUtil.readBody(request), encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new UnexpectedException(e);
            }
            this.logger.debug("FS-LOGD028", encoding);
            return param;
        }
        this.logger.debug("FS-LOGD027", "String");
        return null;
    }
}

