/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.core.request.internal;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.ParameterMappingException;
import com.small_it_office.flatserve.core.request.internal.FlatServeRequest;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapping;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMappingFactory;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMappingFactoryImpl;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.shared.meslog.message.Message;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestParameterReaderImpl
implements RequestParameterReader {
    private static final int PLUGIN_PRIORITY = 1024;
    private RequestParameterMappingFactory mappingFactory;

    @Override
    public Object[] process(RequestContext context, Class<?> serviceClass, Method method) {
        HttpServletRequest request = context.getHttpServletRequest();
        context.setHttpServletRequest(this.wrapRequest(request));
        Object[] params = this.createParams(context, method);
        context.setHttpServletRequest(request);
        return params;
    }

    private Object[] createParams(RequestContext context, Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> type = paramTypes[i];
            Annotation[] annotations = paramAnnotations[i];
            RequestParameterMapping paramMapping = this.getMappingFactory().getMapping(type);
            try {
                params[i] = paramMapping.mapParameter(context, annotations);
                continue;
            }
            catch (ParameterMappingException e) {
                throw new ParameterMappingException(Message.get("FS-ERR011", method.getDeclaringClass().getName(), method.getName(), e.getMessage()));
            }
        }
        return params;
    }

    protected HttpServletRequest wrapRequest(HttpServletRequest request) {
        return new FlatServeRequest(request);
    }

    @Override
    public boolean nest() {
        return false;
    }

    @Override
    public void setNestedObject(PluginPart o) {
    }

    @Override
    public void init(Config config) {
        this.setMappingFactory(new RequestParameterMappingFactoryImpl(config));
    }

    protected RequestParameterMappingFactory getMappingFactory() {
        return this.mappingFactory;
    }

    protected void setMappingFactory(RequestParameterMappingFactory mappingFactory) {
        this.mappingFactory = mappingFactory;
    }

    @Override
    public int priority() {
        return 1024;
    }
}

