/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.core.request.internal;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.request.internal.BeanParameterMapping;
import com.small_it_office.flatserve.core.request.internal.ByteArrayParameterMapping;
import com.small_it_office.flatserve.core.request.internal.HttpServletRequestParameterMapping;
import com.small_it_office.flatserve.core.request.internal.HttpServletResponseParameterMapping;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapping;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMappingFactory;
import com.small_it_office.flatserve.core.request.internal.ServletConfigParameterMapping;
import com.small_it_office.flatserve.core.request.internal.StringArrayParameterMapping;
import com.small_it_office.flatserve.core.request.internal.StringParameterMapping;
import com.small_it_office.flatserve.core.request.internal.UnsupportedParameterMapping;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestParameterMappingFactoryImpl
implements RequestParameterMappingFactory {
    private Map<Class<?>, RequestParameterMapping> typeMapping = new HashMap();

    public RequestParameterMappingFactoryImpl(Config config) {
        this.typeMapping.put(String.class, new StringParameterMapping(config));
        this.typeMapping.put(String[].class, new StringArrayParameterMapping());
        this.typeMapping.put(HttpServletRequest.class, new HttpServletRequestParameterMapping());
        this.typeMapping.put(HttpServletResponse.class, new HttpServletResponseParameterMapping());
        this.typeMapping.put(ServletConfig.class, new ServletConfigParameterMapping());
        this.typeMapping.put(byte[].class, new ByteArrayParameterMapping());
    }

    @Override
    public RequestParameterMapping getMapping(Class<?> type) {
        RequestParameterMapping mapping = this.typeMapping.get(type);
        if (mapping == null) {
            if (type.isPrimitive() || type.getPackage().getName().startsWith("java")) {
                return new UnsupportedParameterMapping(type);
            }
            return new BeanParameterMapping(type);
        }
        return mapping;
    }
}

