/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.core.process.internal;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestContext {
    private static ThreadLocal<RequestContext> threadLocalInstance = new ThreadLocal();
    private HttpServletRequest httpServletRequest;
    private HttpServletResponse httpServletResponse;
    private ServletConfig servletConfig;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    private RequestContext(HttpServletRequest request, HttpServletResponse response, ServletConfig servletConfig) {
        this.httpServletRequest = request;
        this.httpServletResponse = response;
        this.servletConfig = servletConfig;
    }

    public static RequestContext create(HttpServletRequest request, HttpServletResponse response, ServletConfig servletConfig) {
        RequestContext context = new RequestContext(request, response, servletConfig);
        threadLocalInstance.set(context);
        return context;
    }

    public static RequestContext get() {
        return threadLocalInstance.get();
    }

    public static void clear() {
        threadLocalInstance.remove();
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpServletResponse;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    public void setHttpServletResponse(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }
}

