/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.core.config;

import com.small_it_office.flatserve.core.config.InitializationException;
import com.small_it_office.flatserve.core.plugin.Plugin;
import com.small_it_office.flatserve.core.plugin.core.internal.Core;
import com.small_it_office.shared.meslog.message.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private String packageHeadName;
    private Map<String, Class<?>> requestPathMappings = new HashMap();
    private String requestEncoding = "UTF-8";
    private Locale locale = Locale.getDefault();
    private List<String> availablePlugins = new ArrayList<String>();
    private boolean pluginAutoDetect = true;
    private Map<Class<?>, Object> optionalConfig = new HashMap();

    public String getPackageHeadName() {
        return this.packageHeadName;
    }

    public Class<?> pathToClass(String requestPath) {
        return this.requestPathMappings.get(requestPath);
    }

    public String getRequestEncoding() {
        return this.requestEncoding;
    }

    public <T> T getOptionalConfig(Class<T> configType) {
        return configType.cast(this.optionalConfig.get(configType));
    }

    public void addRequestPathMapping(String requestPath, Class<?> serviceClass) {
        this.requestPathMappings.put(requestPath, serviceClass);
    }

    public void addRequestPathMapping(Map<String, Class<?>> mapping) {
        this.requestPathMappings.putAll(mapping);
    }

    public void addRequestPathMapping(Properties properties) {
        Set<Object> keySet = properties.keySet();
        for (Object key : keySet) {
            Class<?> serviceClass;
            String requestPath = (String)key;
            String serviceClassName = properties.getProperty(requestPath);
            try {
                serviceClass = Class.forName(serviceClassName);
            }
            catch (ClassNotFoundException e) {
                throw new InitializationException(Message.get("FS-ERR007", requestPath, serviceClassName), e);
            }
            this.addRequestPathMapping(requestPath, serviceClass);
        }
    }

    public void setPackageHeadName(String packageHeadName) {
        this.packageHeadName = packageHeadName;
    }

    public void setRequestEncoding(String requestEncoding) {
        this.requestEncoding = requestEncoding;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void addAvailablePlugin(Class<? extends Plugin> pluginClass) {
        this.pluginAutoDetect = false;
        this.availablePlugins.add(pluginClass.getName());
    }

    public boolean isAvailablePlugin(String pluginClassName) {
        if (Core.class.getName().equals(pluginClassName)) {
            return true;
        }
        return this.availablePlugins.contains(pluginClassName);
    }

    public void setPluginAutoDetect(boolean autoDetect) {
        this.pluginAutoDetect = autoDetect;
    }

    public boolean isPluginAutoDetect() {
        return this.pluginAutoDetect;
    }

    public void addOptionalConfig(Object config) {
        this.optionalConfig.put(config.getClass(), config);
    }

    public String toString() {
        String configString = "packageHeadName:" + this.packageHeadName + " , requestEncoding:" + this.requestEncoding + " , requestPathMappings includes " + this.requestPathMappings.size() + "mappings , optionalConfig:{";
        Set<Class<?>> configClasses = this.optionalConfig.keySet();
        for (Class<?> configClass : configClasses) {
            configString = configString + configClass.getSimpleName() + " ";
        }
        configString = configString + "}";
        return configString;
    }
}

