/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.utility;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.tk_factory.fivestar.utility.FileUtility;

public class ZipUtility {
    private static final int BUFFER_SIZE = 4096;
    private static final int BUFFER_READ_SIZE = 1024;

    protected ZipUtility() {
        throw new UnsupportedOperationException();
    }

    public static void processingZip(String zipFileName, String targetFolder) throws IOException {
        List<String> fileList;
        ZipOutputStream zos;
        block4: {
            zos = null;
            fileList = ZipUtility.getFileList(targetFolder);
            if (!fileList.isEmpty()) break block4;
            FileUtility.closeOutputStream(zos);
            return;
        }
        try {
            File zipFile = new File(zipFileName);
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            for (String fileName : fileList) {
                StringBuffer filePath = new StringBuffer();
                filePath.append(targetFolder).append(File.separator).append(fileName);
                ZipUtility.addTargetFile(zos, fileName, filePath.toString());
            }
            zos.close();
            zos = null;
        }
        catch (Throwable throwable) {
            FileUtility.closeOutputStream(zos);
            throw throwable;
        }
        FileUtility.closeOutputStream(zos);
    }

    private static void addTargetFile(ZipOutputStream zos, String targetFileName, String targetFilePath) throws IOException {
        BufferedInputStream bis = null;
        try {
            int count;
            File file = new File(targetFilePath);
            bis = new BufferedInputStream(new FileInputStream(file));
            ZipEntry target = new ZipEntry(targetFileName);
            zos.putNextEntry(target);
            byte[] buf = new byte[4096];
            while ((count = bis.read(buf, 0, 1024)) != -1) {
                zos.write(buf, 0, count);
            }
            bis.close();
            bis = null;
            zos.closeEntry();
        }
        catch (Throwable throwable) {
            FileUtility.closeInputStream(bis);
            throw throwable;
        }
        FileUtility.closeInputStream(bis);
    }

    private static List<String> getFileList(String folderPath) {
        File folder = new File(folderPath);
        File[] files = folder.listFiles();
        ArrayList<String> fileList = new ArrayList<String>();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                fileList.add(files[i].getName());
            }
            ++i;
        }
        return fileList;
    }
}

