/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.utility;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class StringUtility {
    private static final String[][] KANA_HANZEN_TBL = new String[][]{{"\u30ac", "\u30ac"}, {"\u30ae", "\u30ae"}, {"\u30b0", "\u30b0"}, {"\u30b2", "\u30b2"}, {"\u30b4", "\u30b4"}, {"\u30b6", "\u30b6"}, {"\u30b8", "\u30b8"}, {"\u30ba", "\u30ba"}, {"\u30bc", "\u30bc"}, {"\u30be", "\u30be"}, {"\u30c0", "\u30c0"}, {"\u30c2", "\u30c2"}, {"\u30c5", "\u30c5"}, {"\u30c7", "\u30c7"}, {"\u30c9", "\u30c9"}, {"\u30d0", "\u30d0"}, {"\u30d3", "\u30d3"}, {"\u30d6", "\u30d6"}, {"\u30d9", "\u30d9"}, {"\u30dc", "\u30dc"}, {"\u30d1", "\u30d1"}, {"\u30d4", "\u30d4"}, {"\u30d7", "\u30d7"}, {"\u30da", "\u30da"}, {"\u30dd", "\u30dd"}, {"\u30f4", "\u30f4"}, {"\u30a2", "\u30a2"}, {"\u30a4", "\u30a4"}, {"\u30a6", "\u30a6"}, {"\u30a8", "\u30a8"}, {"\u30aa", "\u30aa"}, {"\u30ab", "\u30ab"}, {"\u30ad", "\u30ad"}, {"\u30af", "\u30af"}, {"\u30b1", "\u30b1"}, {"\u30b3", "\u30b3"}, {"\u30b5", "\u30b5"}, {"\u30b7", "\u30b7"}, {"\u30b9", "\u30b9"}, {"\u30bb", "\u30bb"}, {"\u30bd", "\u30bd"}, {"\u30bf", "\u30bf"}, {"\u30c1", "\u30c1"}, {"\u30c4", "\u30c4"}, {"\u30c6", "\u30c6"}, {"\u30c8", "\u30c8"}, {"\u30ca", "\u30ca"}, {"\u30cb", "\u30cb"}, {"\u30cc", "\u30cc"}, {"\u30cd", "\u30cd"}, {"\u30ce", "\u30ce"}, {"\u30cf", "\u30cf"}, {"\u30d2", "\u30d2"}, {"\u30d5", "\u30d5"}, {"\u30d8", "\u30d8"}, {"\u30db", "\u30db"}, {"\u30de", "\u30de"}, {"\u30df", "\u30df"}, {"\u30e0", "\u30e0"}, {"\u30e1", "\u30e1"}, {"\u30e2", "\u30e2"}, {"\u30e4", "\u30e4"}, {"\u30e6", "\u30e6"}, {"\u30e8", "\u30e8"}, {"\u30e9", "\u30e9"}, {"\u30ea", "\u30ea"}, {"\u30eb", "\u30eb"}, {"\u30ec", "\u30ec"}, {"\u30ed", "\u30ed"}, {"\u30ef", "\u30ef"}, {"\u30f2", "\u30f2"}, {"\u30f3", "\u30f3"}, {"\u30a1", "\u30a1"}, {"\u30a3", "\u30a3"}, {"\u30a5", "\u30a5"}, {"\u30a7", "\u30a7"}, {"\u30a9", "\u30a9"}, {"\u30e3", "\u30e3"}, {"\u30e5", "\u30e5"}, {"\u30e7", "\u30e7"}, {"\u30c3", "\u30c3"}, {"\u3002", "\u3002"}, {"\u300c", "\u300c"}, {"\u300d", "\u300d"}, {"\u3001", "\u3001"}, {"\u30fb", "\u30fb"}, {"\u30fc", "\u30fc"}};

    protected StringUtility() {
        throw new UnsupportedOperationException();
    }

    public static boolean isNull(String value) {
        return value == null;
    }

    public static boolean isBlank(String value) {
        return value == null || "".equals(value);
    }

    public static String defaultValue(String value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String lPad(String value, int length, String addition) {
        StringBuffer returnValue = new StringBuffer();
        if (value != null) {
            returnValue.append(value);
        }
        while (returnValue.length() < length) {
            returnValue.insert(0, addition);
        }
        return returnValue.toString();
    }

    public static String lPad(String value, int length) {
        return StringUtility.lPad(value, length, " ");
    }

    public static String lPadB(String value, int length, String addition) {
        StringBuffer returnValue = new StringBuffer();
        if (value != null) {
            returnValue.append(value);
        }
        int byteLength = StringUtility.getByteLength(returnValue);
        while (byteLength < length) {
            returnValue.insert(0, addition);
            byteLength = StringUtility.getByteLength(returnValue);
        }
        return returnValue.toString();
    }

    public static String lPadB(String value, int length) {
        return StringUtility.lPadB(value, length, " ");
    }

    public static String rPad(String value, int length, String addition) {
        StringBuffer returnValue = new StringBuffer();
        if (value != null) {
            returnValue.append(value);
        }
        while (returnValue.length() < length) {
            returnValue.append(addition);
        }
        return returnValue.toString();
    }

    public static String rPad(String value, int length) {
        return StringUtility.rPad(value, length, " ");
    }

    public static String rPadB(String value, int length, String addition) {
        StringBuffer returnValue = new StringBuffer();
        if (value != null) {
            returnValue.append(value);
        }
        int byteLength = StringUtility.getByteLength(returnValue);
        while (byteLength < length) {
            returnValue.append(addition);
            byteLength = StringUtility.getByteLength(returnValue);
        }
        return returnValue.toString();
    }

    public static String rPadB(String value, int length) {
        return StringUtility.rPadB(value, length, " ");
    }

    public static String escapeHtml(String htmlString) {
        StringBuffer sb = new StringBuffer();
        if (htmlString == null) {
            return "";
        }
        int i = 0;
        while (i < htmlString.length()) {
            char originalCharacter = htmlString.charAt(i);
            switch (originalCharacter) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\'': {
                    sb.append("&#39;");
                    break;
                }
                case ' ': {
                    sb.append("&nbsp;");
                    break;
                }
                case '\t': {
                    sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    break;
                }
                default: {
                    sb.append(originalCharacter);
                }
            }
            ++i;
        }
        return sb.toString().replaceAll("(\r\n|\r|\n)", "<br/>");
    }

    public static String string2null(String value) {
        if ("null".equals(value)) {
            return null;
        }
        return value;
    }

    public static String string2Blank(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static int string2Int(String value) {
        int returnValue;
        try {
            returnValue = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            returnValue = 0;
        }
        return returnValue;
    }

    public static long string2Long(String value) {
        long returnValue;
        try {
            returnValue = Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            returnValue = 0L;
        }
        return returnValue;
    }

    public static double string2Double(String value) {
        double returnValue;
        try {
            returnValue = Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            returnValue = 0.0;
        }
        if (Double.isInfinite(returnValue)) {
            returnValue = 0.0;
        }
        return returnValue;
    }

    public static byte string2Byte(String value) {
        byte returnValue;
        try {
            returnValue = Byte.parseByte(value);
        }
        catch (NumberFormatException ex) {
            returnValue = 0;
        }
        return returnValue;
    }

    public static short string2Short(String value) {
        short returnValue;
        try {
            returnValue = Short.parseShort(value);
        }
        catch (NumberFormatException ex) {
            returnValue = 0;
        }
        return returnValue;
    }

    public static float string2Float(String value) {
        float returnValue;
        try {
            returnValue = Float.parseFloat(value);
        }
        catch (NumberFormatException ex) {
            returnValue = 0.0f;
        }
        if (Float.isInfinite(returnValue)) {
            returnValue = 0.0f;
        }
        return returnValue;
    }

    public static BigInteger string2BigInteger(String value) {
        BigInteger returnValue;
        try {
            returnValue = new BigInteger(value);
        }
        catch (NumberFormatException ex) {
            returnValue = BigInteger.ZERO;
        }
        return returnValue;
    }

    public static BigDecimal string2BigDecimal(String value) {
        BigDecimal returnValue;
        try {
            returnValue = new BigDecimal(value);
        }
        catch (NumberFormatException ex) {
            returnValue = BigDecimal.ZERO;
        }
        return returnValue;
    }

    public static String hanKana2ZenKana(String value) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int j = 0;
        i = 0;
        while (i < value.length()) {
            Character character = new Character(value.charAt(i));
            if (StringUtility.isHanKanaCharacter(character)) {
                j = 0;
                while (j < KANA_HANZEN_TBL.length) {
                    if (value.substring(i).startsWith(KANA_HANZEN_TBL[j][0])) {
                        sb.append(KANA_HANZEN_TBL[j][1]);
                        i += KANA_HANZEN_TBL[j][0].length() - 1;
                        break;
                    }
                    ++j;
                }
                if (j >= KANA_HANZEN_TBL.length) {
                    sb.append(character);
                }
            } else {
                sb.append(character);
            }
            ++i;
        }
        return sb.toString();
    }

    private static boolean isHanKanaCharacter(Character character) {
        if (character == null) {
            return false;
        }
        return character.compareTo(new Character('\uff61')) >= 0 && character.compareTo(new Character('\uff9f')) <= 0;
    }

    public static String zenKana2HanKana(String value) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int j = 0;
        i = 0;
        while (i < value.length()) {
            Character character = new Character(value.charAt(i));
            if (StringUtility.isZenKanaCharacter(character)) {
                j = 0;
                while (j < KANA_HANZEN_TBL.length) {
                    if (value.substring(i).startsWith(KANA_HANZEN_TBL[j][1])) {
                        sb.append(KANA_HANZEN_TBL[j][0]);
                        break;
                    }
                    ++j;
                }
                if (j >= KANA_HANZEN_TBL.length) {
                    sb.append(character);
                }
            } else {
                sb.append(character);
            }
            ++i;
        }
        return sb.toString();
    }

    private static boolean isZenKanaCharacter(Character character) {
        if (character == null) {
            return false;
        }
        if (character.compareTo(new Character('\u30a1')) >= 0 && character.compareTo(new Character('\u30fc')) <= 0) {
            return true;
        }
        return new Character('\u3002').equals(character) || new Character('\u300c').equals(character) || new Character('\u300d').equals(character) || new Character('\u3001').equals(character) || new Character('\u30fb').equals(character) || new Character('\u30fc').equals(character);
    }

    public static String hanLatin2ZenLatin(String value) {
        StringBuffer returnValue = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            Character character = new Character(value.charAt(i));
            if (StringUtility.isHanLatinCharacter(character)) {
                char c = (char)(character.charValue() + new Character('\ufee0').charValue());
                Character x = new Character(c);
                returnValue.append(x);
            } else {
                returnValue.append(character);
            }
            ++i;
        }
        return returnValue.toString();
    }

    private static boolean isHanLatinCharacter(Character character) {
        if (character == null) {
            return false;
        }
        return character.compareTo(new Character('!')) >= 0 && character.compareTo(new Character('~')) <= 0;
    }

    public static String zenLatin2HanLatin(String value) {
        StringBuffer returnValue = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            Character character = new Character(value.charAt(i));
            if (StringUtility.isZenLatinCharacter(character)) {
                char c = (char)(character.charValue() - new Character('\ufee0').charValue());
                Character x = new Character(c);
                returnValue.append(x);
            } else {
                returnValue.append(character);
            }
            ++i;
        }
        return returnValue.toString();
    }

    private static boolean isZenLatinCharacter(Character character) {
        if (character == null) {
            return false;
        }
        return character.compareTo(new Character('\uff01')) >= 0 && character.compareTo(new Character('\uff5e')) <= 0;
    }

    public static String trim(String value) {
        if (value == null) {
            return null;
        }
        return value.trim();
    }

    public static String rtrim(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll(" *$", "");
    }

    public static String ltrim(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll("^ *", "");
    }

    public static String leftB(String value, int length) {
        int counter;
        StringBuffer returnValue;
        block7: {
            returnValue = new StringBuffer();
            counter = 0;
            if (value != null) break block7;
            return "";
        }
        try {
            int i = 0;
            while (i < value.length()) {
                byte[] work = null;
                try {
                    work = value.substring(i, i + 1).getBytes("MS932");
                }
                catch (UnsupportedEncodingException ex) {
                    work = value.substring(i, i + 1).getBytes();
                }
                if (counter + work.length <= length) {
                    returnValue.append(new String(work));
                    counter += work.length;
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            returnValue = new StringBuffer(value);
        }
        return returnValue.toString();
    }

    public static String rightB(String value, int length) {
        int counter;
        StringBuffer returnValue;
        block7: {
            returnValue = new StringBuffer();
            counter = 0;
            if (value != null) break block7;
            return "";
        }
        try {
            int i = value.length();
            while (i > 0) {
                byte[] work = null;
                try {
                    work = value.substring(i - 1, i).getBytes("MS932");
                }
                catch (UnsupportedEncodingException ex) {
                    work = value.substring(i - 1, i).getBytes();
                }
                if (counter + work.length <= length) {
                    returnValue.insert(0, new String(work));
                    counter += work.length;
                    --i;
                    continue;
                }
                break;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            returnValue = new StringBuffer(value);
        }
        return returnValue.toString();
    }

    public static int lengthB(String value) {
        if (value == null) {
            return 0;
        }
        int length = 0;
        try {
            length = value.getBytes("MS932").length;
        }
        catch (UnsupportedEncodingException ex) {
            length = value.getBytes().length;
        }
        return length;
    }

    private static int getByteLength(StringBuffer value) {
        int byteLength = 0;
        if (value == null) {
            return byteLength;
        }
        try {
            byteLength = value.toString().getBytes("MS932").length;
        }
        catch (UnsupportedEncodingException ex) {
            byteLength = value.toString().getBytes().length;
        }
        return byteLength;
    }

    public static String subString(String value, int startIndex) {
        String returnValue;
        block3: {
            returnValue = null;
            if (value != null) break block3;
            return "";
        }
        try {
            returnValue = value.substring(startIndex);
        }
        catch (IndexOutOfBoundsException ex) {
            returnValue = value;
        }
        return returnValue;
    }

    public static String subString(String value, int startIndex, int endIndex) {
        String returnValue;
        block3: {
            returnValue = null;
            if (value != null) break block3;
            return "";
        }
        try {
            returnValue = value.substring(startIndex, endIndex);
        }
        catch (IndexOutOfBoundsException ex) {
            returnValue = value;
        }
        return returnValue;
    }

    public static String toUpperCase(String value) {
        if (value == null) {
            return "";
        }
        return value.toUpperCase();
    }

    public static String toLowerCase(String value) {
        if (value == null) {
            return "";
        }
        return value.toLowerCase();
    }

    public static String dump(String value) {
        StringBuffer returnValue = new StringBuffer();
        char[] buf = value.toCharArray();
        int i = 0;
        while (i < buf.length) {
            returnValue.append(String.valueOf(Integer.toString(buf[i], 16)) + "\n");
            ++i;
        }
        return returnValue.toString();
    }
}

