/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.utility;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;

public class POIUtility {
    protected POIUtility() {
        throw new UnsupportedOperationException();
    }

    public static String getCellValue(HSSFCell cell) throws Exception {
        String value;
        int type = cell.getCellType();
        switch (type) {
            case 3: {
                value = "";
                break;
            }
            case 4: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 5: {
                value = String.valueOf(cell.getErrorCellValue());
                break;
            }
            case 2: {
                value = String.valueOf(cell.getCellFormula());
                break;
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((HSSFCell)cell)) {
                    value = String.valueOf(cell.getDateCellValue());
                    break;
                }
                value = String.valueOf(cell.getNumericCellValue());
                break;
            }
            case 1: {
                value = cell.getRichStringCellValue().getString();
                break;
            }
            default: {
                value = cell.getRichStringCellValue().getString();
            }
        }
        return value;
    }
}

