/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.utility;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Random;

public class NumberUtility {
    private static final String DEFAULT_FORMAT = "##,###.###";

    protected NumberUtility() {
        throw new UnsupportedOperationException();
    }

    public static String format(Object value) {
        return NumberUtility.format(value, null);
    }

    public static String format(Object value, String format) {
        String result = "";
        try {
            DecimalFormat formatter = format == null ? new DecimalFormat(DEFAULT_FORMAT) : new DecimalFormat(format);
            result = formatter.format(value);
        }
        catch (IllegalArgumentException iaex) {
            result = String.valueOf(value);
        }
        return result;
    }

    public static BigDecimal calculateRound(BigDecimal value) {
        return NumberUtility.calculateRound(value, 0, RoundingMode.HALF_UP);
    }

    public static BigDecimal calculateRound(BigDecimal value, int scale) {
        return NumberUtility.calculateRound(value, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal calculateRound(BigDecimal value, int scale, RoundingMode mode) {
        return value.setScale(scale, mode);
    }

    public static int getRandomInt(int value) {
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        return random.nextInt(value);
    }
}

