/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.utility;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.tk_factory.fivestar.utility.FileUtility;

public class ImageUtility {
    protected ImageUtility() {
        throw new UnsupportedOperationException();
    }

    public static void createThumbnail(String inFileName, String outFileName, double rate) throws IOException {
        FileOutputStream out = null;
        try {
            String extension = "";
            int index = inFileName.lastIndexOf(".");
            if (index != -1) {
                extension = inFileName.substring(index + 1);
            }
            if (!ImageUtility.isReaderFormat(extension)) {
                StringBuffer msg = new StringBuffer();
                msg.append("\u62e1\u5f35\u5b50\uff1a").append(extension).append("\u306f\u8aad\u307f\u8fbc\u307f\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                throw new IOException(msg.toString());
            }
            BufferedImage image1 = ImageIO.read(new File(inFileName));
            if (image1 == null) {
                StringBuffer msg = new StringBuffer();
                msg.append("\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\uff08").append(inFileName).append("\uff09\u3002");
                throw new IOException("");
            }
            int type = image1.getType();
            if (type == 0) {
                type = 1;
            }
            int width2 = (int)((double)image1.getWidth() * rate);
            int height2 = (int)((double)image1.getHeight() * rate);
            BufferedImage image2 = new BufferedImage(width2, height2, type);
            AffineTransform at = AffineTransform.getScaleInstance(rate, rate);
            AffineTransformOp ato = new AffineTransformOp(at, null);
            ato.filter(image1, image2);
            index = outFileName.lastIndexOf(".");
            if (index != -1) {
                extension = outFileName.substring(index + 1);
            }
            if (!ImageUtility.isWriterFormat(extension)) {
                extension = "jpg";
            }
            out = new FileOutputStream(outFileName);
            ImageIO.write((RenderedImage)image2, extension, out);
        }
        catch (Throwable throwable) {
            FileUtility.closeOutputStream(out);
            throw throwable;
        }
        FileUtility.closeOutputStream(out);
    }

    public static boolean isReaderFormat(String extension) {
        String[] readerFormatNames = ImageIO.getReaderFormatNames();
        int i = 0;
        while (i < readerFormatNames.length) {
            if (readerFormatNames[i].equalsIgnoreCase(extension)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isWriterFormat(String extension) {
        String[] writerFormatNames = ImageIO.getWriterFormatNames();
        int i = 0;
        while (i < writerFormatNames.length) {
            if (writerFormatNames[i].equalsIgnoreCase(extension)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

