/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.utility;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.tk_factory.fivestar.utility.FileUtility;

public class GZipUtility {
    protected GZipUtility() {
        throw new UnsupportedOperationException();
    }

    public static void proccessGZip(String zipFileName, String targetFileName) throws IOException {
        byte[] buf = new byte[1024];
        BufferedInputStream bin = null;
        GZIPOutputStream gzos = null;
        try {
            int size;
            bin = new BufferedInputStream(new FileInputStream(targetFileName));
            gzos = new GZIPOutputStream(new FileOutputStream(zipFileName));
            while ((size = bin.read(buf, 0, buf.length)) != -1) {
                gzos.write(buf, 0, size);
            }
            gzos.flush();
        }
        catch (Throwable throwable) {
            FileUtility.closeOutputStream(gzos);
            FileUtility.closeInputStream(bin);
            throw throwable;
        }
        FileUtility.closeOutputStream(gzos);
        FileUtility.closeInputStream(bin);
    }

    public static void proccessUnGZip(String zipFileName, String targetFileName) throws IOException {
        byte[] buf = new byte[1024];
        GZIPInputStream gzin = null;
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            int size;
            gzin = new GZIPInputStream(new FileInputStream(zipFileName));
            fos = new FileOutputStream(targetFileName);
            bos = new BufferedOutputStream(fos);
            while ((size = gzin.read(buf, 0, buf.length)) != -1) {
                bos.write(buf, 0, size);
            }
            bos.flush();
        }
        catch (Throwable throwable) {
            FileUtility.closeOutputStream(bos);
            FileUtility.closeOutputStream(fos);
            FileUtility.closeInputStream(gzin);
            throw throwable;
        }
        FileUtility.closeOutputStream(bos);
        FileUtility.closeOutputStream(fos);
        FileUtility.closeInputStream(gzin);
    }
}

