/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.utility;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import net.tk_factory.fivestar.utility.FileUtility;

public class FTPUtility {
    private static final int PORT = 21;
    private static PrintWriter ctrlPrintWriter;
    private static byte[] localHostAddress;

    protected FTPUtility() {
        throw new UnsupportedOperationException();
    }

    public static void upload(String host, String user, String password, int mode, String uploadDir, String fileName) throws IOException {
        FTPUtility.upload(host, 21, user, password, mode, uploadDir, fileName);
    }

    public static void upload(String host, int port, String user, String password, int mode, String uploadDir, String fileName) throws IOException {
        Socket ctrlSocket = null;
        BufferedReader ctrlBufferedReader = null;
        try {
            ctrlSocket = new Socket(host, port);
            localHostAddress = ctrlSocket.getLocalAddress().getAddress();
            ctrlPrintWriter = new PrintWriter(ctrlSocket.getOutputStream());
            InputStreamReader isr = new InputStreamReader(ctrlSocket.getInputStream());
            ctrlBufferedReader = new BufferedReader(isr);
            ctrlPrintWriter.println("USER " + user);
            ctrlPrintWriter.flush();
            ctrlPrintWriter.println("PASS " + password);
            ctrlPrintWriter.flush();
            ctrlPrintWriter.println("CWD " + uploadDir);
            ctrlPrintWriter.flush();
            if (mode == 0) {
                ctrlPrintWriter.println("TYPE A");
            } else {
                ctrlPrintWriter.println("TYPE I");
            }
            ctrlPrintWriter.flush();
            FTPUtility.uploadFile(fileName);
        }
        catch (Throwable throwable) {
            FileUtility.closeWriter(ctrlPrintWriter);
            FileUtility.closeReader(ctrlBufferedReader);
            FTPUtility.closeSocket(ctrlSocket);
            throw throwable;
        }
        FileUtility.closeWriter(ctrlPrintWriter);
        FileUtility.closeReader(ctrlBufferedReader);
        FTPUtility.closeSocket(ctrlSocket);
    }

    private static void uploadFile(String fileName) throws IOException {
        FileInputStream fileInputStream = null;
        Socket dataSocket = null;
        OutputStream outputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(fileName);
            dataSocket = FTPUtility.dataConnection("STOR " + fileName);
            outputStream = dataSocket.getOutputStream();
            byte[] buff = new byte[1024];
            while ((n = fileInputStream.read(buff)) > 0) {
                outputStream.write(buff, 0, n);
            }
            dataSocket.close();
            fileInputStream.close();
        }
        catch (Throwable throwable) {
            FileUtility.closeInputStream(fileInputStream);
            FTPUtility.closeSocket(dataSocket);
            throw throwable;
        }
        FileUtility.closeInputStream(fileInputStream);
        FTPUtility.closeSocket(dataSocket);
    }

    private static Socket dataConnection(String ctrlCmd) throws IOException {
        StringBuffer cmd = new StringBuffer();
        ServerSocket serverDataSocket = new ServerSocket(0, 1);
        cmd.append("PORT ");
        int i = 0;
        while (i < 4) {
            cmd.append(String.valueOf(localHostAddress[i] & 0xFF) + ",");
            ++i;
        }
        cmd.append(serverDataSocket.getLocalPort() / 256 & 0xFF).append(",").append(serverDataSocket.getLocalPort() & 0xFF);
        ctrlPrintWriter.println(cmd.toString());
        ctrlPrintWriter.flush();
        ctrlPrintWriter.println(ctrlCmd);
        ctrlPrintWriter.flush();
        Socket dataSocket = serverDataSocket.accept();
        serverDataSocket.close();
        return dataSocket;
    }

    private static void closeSocket(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

