/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.utility;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.tk_factory.fivestar.check.DateCheck;
import net.tk_factory.fivestar.utility.StringUtility;

public class DateUtility {
    private static final String DEFAULT_FORMAT = "yyyy'/'MM'/'dd";
    public static final String WAREKI_MEIJI = "M";
    public static final String WAREKI_TAISHO = "T";
    public static final String WAREKI_SHOWA = "S";
    public static final String WAREKI_HEISEI = "H";
    public static final String ETO_NE = "\u5b50";
    public static final String ETO_USHI = "\u4e11";
    public static final String ETO_TORA = "\u5bc5";
    public static final String ETO_U = "\u536f";
    public static final String ETO_TATSU = "\u8fb0";
    public static final String ETO_MI = "\u5df3";
    public static final String ETO_UMA = "\u5348";
    public static final String ETO_HITSUJI = "\u672a";
    public static final String ETO_SARU = "\u7533";
    public static final String ETO_TORI = "\u9149";
    public static final String ETO_INU = "\u620c";
    public static final String ETO_I = "\u4ea5";
    public static final String SUNDAY_JA = "\u65e5";
    public static final String MONDAY_JA = "\u6708";
    public static final String TUESDAY_JA = "\u706b";
    public static final String WEDNESDAY_JA = "\u6c34";
    public static final String THURSDAY_JA = "\u6728";
    public static final String FRIDAY_JA = "\u91d1";
    public static final String SATURDAY_JA = "\u571f";
    private static final String[][] WAREKI_TABLE = new String[][]{{"18680908", "19120729", "M"}, {"19120730", "19261224", "T"}, {"19261225", "19890107", "S"}, {"19890108", "99991231", "H"}};
    private static final String[] ETO_TABLE = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    private static final String[] WEEK_JA_TABLE = new String[]{"\u65e5", "\u6708", "\u706b", "\u6c34", "\u6728", "\u91d1", "\u571f"};

    protected DateUtility() {
        throw new UnsupportedOperationException();
    }

    public static String format(Date value) {
        return DateUtility.format(value, null);
    }

    public static String format(Date value, String format) {
        GregorianCalendar calendar = new GregorianCalendar();
        Date date = value;
        if (date == null) {
            return "";
        }
        calendar.setTime(date);
        int year1 = calendar.get(1);
        int month1 = calendar.get(2) + 1;
        int day1 = calendar.get(5);
        return DateUtility.insideFormat(year1, month1, day1, format);
    }

    public static String format(String year, String month, String day) {
        return DateUtility.format(year, month, day, null);
    }

    public static String format(int year, int month, int day) {
        return DateUtility.format(year, month, day, null);
    }

    public static String format(String year, String month, String day, String format) {
        int year1 = Integer.parseInt(year);
        int month1 = Integer.parseInt(month);
        int day1 = Integer.parseInt(day);
        return DateUtility.insideFormat(year1, month1, day1, format);
    }

    public static String format(int year, int month, int day, String format) {
        return DateUtility.insideFormat(year, month, day, format);
    }

    private static String insideFormat(int year, int month, int day, String format) {
        String result = "";
        try {
            GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day);
            calendar.setLenient(false);
            SimpleDateFormat formatter = format == null ? new SimpleDateFormat(DEFAULT_FORMAT) : new SimpleDateFormat(format);
            result = formatter.format(calendar.getTime());
        }
        catch (IllegalArgumentException iaex) {
            result = String.valueOf(year) + "/" + month + "/" + day;
        }
        return result;
    }

    public static String getSystemDate() {
        return DateUtility.getCurrentDateTime().substring(0, 10);
    }

    public static String getSystemDateTime() {
        return DateUtility.getCurrentDateTime().substring(0, 19);
    }

    public static String getSystemDateMilliTime() {
        return DateUtility.getCurrentDateTime();
    }

    public static String getSystemTime() {
        return DateUtility.getCurrentDateTime().substring(11, 19);
    }

    public static String getSystemMilliTime() {
        return DateUtility.getCurrentDateTime().substring(11);
    }

    public static int getLastDay(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int iYear = calendar.get(1);
        int iMonth = calendar.get(2) + 1;
        return DateUtility.getLastDay(iYear, iMonth);
    }

    public static int getLastDay(String sYear, String sMonth) {
        int iYear = Integer.parseInt(sYear);
        int iMonth = Integer.parseInt(sMonth);
        return DateUtility.getLastDay(iYear, iMonth);
    }

    public static int getLastDay(int iYear, int iMonth) {
        DateCheck check = new DateCheck(iYear, iMonth, 1);
        if (check.validate() != 0) {
            return 0;
        }
        GregorianCalendar gc = new GregorianCalendar(iYear, iMonth - 1, 1);
        return gc.getActualMaximum(5);
    }

    public static int getAge(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int iYear = calendar.get(1);
        int iMonth = calendar.get(2) + 1;
        int iDay = calendar.get(5);
        return DateUtility.getAge(iYear, iMonth, iDay);
    }

    public static int getAge(String sYear, String sMonth, String sDay) {
        int iYear = Integer.parseInt(sYear);
        int iMonth = Integer.parseInt(sMonth);
        int iDay = Integer.parseInt(sDay);
        return DateUtility.getAge(iYear, iMonth, iDay);
    }

    public static int getAge(int iYear, int iMonth, int iDay) {
        DateCheck dateCheck = new DateCheck(iYear, iMonth, iDay);
        int checkResult = dateCheck.validate();
        if (checkResult != 0) {
            return -1;
        }
        Calendar now = Calendar.getInstance();
        int nowYear = now.get(1);
        int nowMonth = now.get(2);
        int nowDay = now.get(5);
        GregorianCalendar birth = new GregorianCalendar();
        birth.set(iYear, iMonth - 1, iDay);
        int birthYear = birth.get(1);
        int birthMonth = birth.get(2);
        int birthDay = birth.get(5);
        int age = nowYear - birthYear;
        if (nowMonth < birthMonth) {
            --age;
        } else if (nowMonth == birthMonth && nowDay < birthDay) {
            --age;
        }
        if (age < 0) {
            return -1;
        }
        return age;
    }

    public static boolean isLeapYear(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return DateUtility.isLeapYear(calendar.get(1));
    }

    public static boolean isLeapYear(String sYear) {
        return DateUtility.isLeapYear(Integer.parseInt(sYear));
    }

    public static boolean isLeapYear(int iYear) {
        GregorianCalendar cal = new GregorianCalendar(iYear, 1, 1);
        return cal.isLeapYear(iYear);
    }

    public static String getEto(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return DateUtility.getEto(calendar.get(1));
    }

    public static String getEto(String sYear) {
        return DateUtility.getEto(Integer.parseInt(sYear));
    }

    public static String getEto(int iYear) {
        int i = (iYear + 8) % 12;
        return ETO_TABLE[i];
    }

    public static String getSeirekiToWareki(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int iYear = calendar.get(1);
        int iMonth = calendar.get(2) + 1;
        int iDay = calendar.get(5);
        return DateUtility.getSeirekiToWareki(iYear, iMonth, iDay);
    }

    public static String getSeirekiToWareki(String sYear, String sMonth, String sDay) {
        int iYear = Integer.parseInt(sYear);
        int iMonth = Integer.parseInt(sMonth);
        int iDay = Integer.parseInt(sDay);
        return DateUtility.getSeirekiToWareki(iYear, iMonth, iDay);
    }

    public static String getSeirekiToWareki(int iYear, int iMonth, int iDay) {
        DateCheck dateCheck = new DateCheck(iYear, iMonth, iDay);
        int checkResult = dateCheck.validate();
        if (checkResult != 0) {
            return null;
        }
        String ymd = DateUtility.format(iYear, iMonth, iDay, "yyyyMMdd");
        int index = 0;
        while (index < WAREKI_TABLE.length) {
            if (ymd.compareTo(WAREKI_TABLE[index][0]) >= 0 && ymd.compareTo(WAREKI_TABLE[index][1]) <= 0) break;
            ++index;
        }
        if (index < WAREKI_TABLE.length) {
            String sYear = WAREKI_TABLE[index][0].substring(0, 4);
            int year = iYear - Integer.parseInt(sYear) + 1;
            StringBuffer wareki = new StringBuffer();
            wareki.append(WAREKI_TABLE[index][2]).append(StringUtility.lPad(String.valueOf(year), 2, "0")).append("/").append(StringUtility.lPad(String.valueOf(iMonth), 2, "0")).append("/").append(StringUtility.lPad(String.valueOf(iDay), 2, "0"));
            return wareki.toString();
        }
        return null;
    }

    public static String getWarekiToSeireki(String gengou, String sYear, String sMonth, String sDay) {
        int iYear = Integer.parseInt(sYear);
        int iMonth = Integer.parseInt(sMonth);
        int iDay = Integer.parseInt(sDay);
        return DateUtility.getWarekiToSeireki(gengou, iYear, iMonth, iDay);
    }

    public static String getWarekiToSeireki(String gengou, int iYear, int iMonth, int iDay) {
        int index = 0;
        while (index < WAREKI_TABLE.length) {
            if (WAREKI_TABLE[index][2].equals(gengou)) break;
            ++index;
        }
        if (index >= WAREKI_TABLE.length) {
            return null;
        }
        String sYear = WAREKI_TABLE[index][0].substring(0, 4);
        int year = Integer.parseInt(sYear) + iYear - 1;
        DateCheck dateCheck = new DateCheck(iYear, iMonth, iDay);
        int checkResult = dateCheck.validate();
        if (checkResult != 0) {
            return null;
        }
        return DateUtility.format(year, iMonth, iDay);
    }

    public static String addDate(Date date, int amount) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int iYear = calendar.get(1);
        int iMonth = calendar.get(2) + 1;
        int iDay = calendar.get(5);
        return DateUtility.addDate(iYear, iMonth, iDay, amount);
    }

    public static String addDate(String sYear, String sMonth, String sDay, int amount) {
        int iYear = Integer.parseInt(sYear);
        int iMonth = Integer.parseInt(sMonth);
        int iDay = Integer.parseInt(sDay);
        return DateUtility.addDate(iYear, iMonth, iDay, amount);
    }

    public static String addDate(int iYear, int iMonth, int iDay, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(iYear, iMonth - 1, iDay);
        calendar.add(5, amount);
        int iYear1 = calendar.get(1);
        int iMonth1 = calendar.get(2) + 1;
        int iDay1 = calendar.get(5);
        return DateUtility.format(iYear1, iMonth1, iDay1);
    }

    public static int getDiffDate(Date dateFrom, Date dateTo) {
        long diff = dateTo.getTime() - dateFrom.getTime();
        return (int)(diff / 1000L / 60L / 60L / 24L);
    }

    public static String getWeekToJa(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int iYear = calendar.get(1);
        int iMonth = calendar.get(2) + 1;
        int iDay = calendar.get(5);
        return DateUtility.getWeekToJa(iYear, iMonth, iDay);
    }

    public static String getWeekToJa(String sYear, String sMonth, String sDay) {
        int iYear = Integer.parseInt(sYear);
        int iMonth = Integer.parseInt(sMonth);
        int iDay = Integer.parseInt(sDay);
        return DateUtility.getWeekToJa(iYear, iMonth, iDay);
    }

    public static String getWeekToJa(int iYear, int iMonth, int iDay) {
        Calendar cal = Calendar.getInstance();
        cal.set(iYear, iMonth - 1, iDay);
        return WEEK_JA_TABLE[cal.get(7) - 1];
    }

    private static String getCurrentDateTime() {
        StringBuffer sb = new StringBuffer();
        GregorianCalendar calendar = new GregorianCalendar();
        Date date = new Date();
        calendar.setTime(date);
        String year = String.valueOf(calendar.get(1));
        String month = String.valueOf(calendar.get(2) + 1);
        month = StringUtility.lPad(month, 2, "0");
        String day = String.valueOf(calendar.get(5));
        day = StringUtility.lPad(day, 2, "0");
        String hour = String.valueOf(calendar.get(11));
        hour = StringUtility.lPad(hour, 2, "0");
        String minute = String.valueOf(calendar.get(12));
        minute = StringUtility.lPad(minute, 2, "0");
        String second = String.valueOf(calendar.get(13));
        second = StringUtility.lPad(second, 2, "0");
        String milliSecond = String.valueOf(calendar.get(14));
        milliSecond = StringUtility.lPad(milliSecond, 3, "0");
        sb.append(year).append("/").append(month).append("/").append(day).append(" ").append(hour).append(":").append(minute).append(":").append(second).append(".").append(milliSecond);
        return sb.toString();
    }
}

