/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class ProcessExec {
    public static final int END_NORMAL = 0;
    public static final int END_WARNING = 1;
    public static final int END_ERROR = 2;
    private static final Logger LOGGER = Logger.getLogger((String)ProcessExec.class.getName());
    private String[] command;
    private boolean wait;
    private int result;

    public ProcessExec(String[] values) {
        String[] cloneValues = (String[])values.clone();
        this.command = cloneValues;
    }

    public int execute(boolean flg) {
        this.setWait(flg);
        int resultVale = 0;
        try {
            Process proc = Runtime.getRuntime().exec(this.command);
            if (this.wait) {
                StreamPumper inputPumper = new StreamPumper(proc.getInputStream());
                StreamPumper errorPumper = new StreamPumper(proc.getErrorStream());
                inputPumper.start();
                errorPumper.start();
                proc.waitFor();
                inputPumper.join();
                errorPumper.join();
                proc.destroy();
            }
            this.result = proc.exitValue();
        }
        catch (IOException ioex) {
            resultVale = 2;
        }
        catch (InterruptedException iex) {
            resultVale = 1;
        }
        catch (IllegalThreadStateException itsex) {
            resultVale = 1;
        }
        return resultVale;
    }

    public int execute() {
        return this.execute(false);
    }

    public void setCommand(String[] values) {
        this.command = values;
    }

    public String[] getCommand() {
        return this.command;
    }

    public void setWait(boolean flg) {
        this.wait = flg;
    }

    public boolean getWait() {
        return this.wait;
    }

    public void setResult(int value) {
        this.result = value;
    }

    public int getResult() {
        return this.result;
    }

    private class StreamPumper
    extends Thread {
        private static final int SLEEP_TIME = 5;
        private BufferedReader br;
        private boolean endOfStream;

        public StreamPumper(InputStream is) {
            this.br = new BufferedReader(new InputStreamReader(is));
        }

        public void pumpStream() throws IOException {
            if (!this.endOfStream) {
                String line = this.br.readLine();
                if (line != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)line);
                    }
                } else {
                    this.endOfStream = true;
                }
            }
        }

        @Override
        public void run() {
            try {
                try {
                    while (!this.endOfStream) {
                        this.pumpStream();
                        StreamPumper.sleep(5L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.br.close();
                this.br = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void setBr(BufferedReader value) {
            this.br = value;
        }

        public BufferedReader getBr() {
            return this.br;
        }

        public void setEndOfStream(boolean value) {
            this.endOfStream = value;
        }

        public boolean getEndOfStream() {
            return this.endOfStream;
        }
    }
}

