/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.csv;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class CsvTokenizer
implements Enumeration<Object> {
    private static final char DEFAULT_SEPARATOR = ',';
    private String source;
    private int currentPosition;
    private int maxPosition;
    private char separator;

    public CsvTokenizer(String value) {
        this(value, ',');
    }

    public CsvTokenizer(String value, char separator) {
        this.source = value;
        this.currentPosition = 0;
        this.maxPosition = this.source.length();
        this.separator = separator;
    }

    public int countTokens() {
        int i = 0;
        int ret = 1;
        while ((i = this.nextComma(i)) < this.maxPosition) {
            ++i;
            ++ret;
        }
        return ret;
    }

    public String nextToken() {
        if (this.currentPosition > this.maxPosition) {
            throw new NoSuchElementException(String.valueOf(this.toString()) + "#nextToken");
        }
        int st = this.currentPosition;
        this.currentPosition = this.nextComma(this.currentPosition);
        if (this.currentPosition - st == 2 && this.source.charAt(st) == '\"' && this.source.charAt(st + 1) == '\"') {
            ++this.currentPosition;
            return "";
        }
        StringBuffer sb = new StringBuffer();
        while (st < this.currentPosition) {
            char ch;
            if ((ch = this.source.charAt(st++)) == '\"') {
                if (st >= this.currentPosition || this.source.charAt(st) != '\"') continue;
                sb.append(ch);
                ++st;
                continue;
            }
            sb.append(ch);
        }
        ++this.currentPosition;
        return sb.toString();
    }

    @Override
    public Object nextElement() {
        return this.nextToken();
    }

    public boolean hasMoreTokens() {
        return this.nextComma(this.currentPosition) <= this.maxPosition;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public void setSource(String value) {
        this.source = value;
    }

    public String getSource() {
        return this.source;
    }

    public void setCurrentPosition(int value) {
        this.currentPosition = value;
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public void setMaxPosition(int value) {
        this.maxPosition = value;
    }

    public int getMaxPosition() {
        return this.maxPosition;
    }

    public void setSeparator(char value) {
        this.separator = value;
    }

    public char getSeparator() {
        return this.separator;
    }

    public String toString() {
        return this.source;
    }

    private int nextComma(int startIndex) {
        int index = startIndex;
        boolean inquote = false;
        while (index < this.maxPosition) {
            char ch = this.source.charAt(index);
            if (!inquote && ch == this.separator) break;
            if ('\"' == ch) {
                inquote ^= true;
            }
            ++index;
        }
        return index;
    }
}

