/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.csv;

import java.util.ArrayList;
import java.util.Enumeration;
import net.tk_factory.fivestar.csv.CsvTokenizer;

public class CsvLine {
    private static final char DEFAULT_SEPARATOR = ',';
    private ArrayList<Element> items = new ArrayList();
    private char separator;

    public CsvLine() {
        this(',');
    }

    public CsvLine(char separator) {
        this.separator = separator;
    }

    public void addItem(String value) {
        this.addItem(value, false);
    }

    public void addItem(String value, boolean flg) {
        this.items.add(new Element(value, flg, this.separator));
    }

    public void addItem(CsvTokenizer ct) {
        while (ct.hasMoreTokens()) {
            String item = ct.nextToken();
            this.items.add(new Element(item, this.separator));
        }
    }

    public String getLine() {
        StringBuffer list = new StringBuffer();
        int i = 0;
        while (i < this.items.size()) {
            Element element = this.items.get(i);
            String item = element.getItem();
            list.append(item);
            if (this.items.size() - 1 != i) {
                list.append(this.separator);
            }
            ++i;
        }
        return new String(list);
    }

    public int getSize() {
        return this.items.size();
    }

    public String getItem(int index) {
        try {
            Element element = this.items.get(index);
            return element.getRawItem();
        }
        catch (IndexOutOfBoundsException iobex) {
            return null;
        }
    }

    public void removeItem(int index) {
        try {
            this.items.remove(index);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public Enumeration<Object> getElements() {
        return new CsvLineEnumerator(this.items);
    }

    public static String enquote(String value) {
        return CsvLine.enquote(value, false, ',');
    }

    public static String enquote(String value, boolean flg) {
        return CsvLine.enquote(value, flg, ',');
    }

    public static String enquote(String value, boolean flg, char separator) {
        if (value.length() == 0) {
            return value;
        }
        if (value.indexOf(34) < 0 && value.indexOf(separator) < 0 && !flg) {
            return value;
        }
        StringBuffer sb = new StringBuffer(value.length() * 2 + 2);
        sb.append('\"');
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if ('\"' == ch) {
                sb.append("\"\"");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }

    private static final class CsvLineEnumerator
    implements Enumeration<Object> {
        private ArrayList<Element> items;
        private int count;

        private CsvLineEnumerator(ArrayList<Element> value) {
            this.items = value;
            this.count = 0;
        }

        @Override
        public Object nextElement() {
            ++this.count;
            Element element = this.items.get(this.count - 1);
            return element.getRawItem();
        }

        @Override
        public boolean hasMoreElements() {
            return this.count < this.items.size();
        }
    }

    private static final class Element {
        private String item;
        private boolean enquote;
        private char separator;

        private Element(String value, char separator) {
            this(value, false, separator);
        }

        private Element(String value, boolean flg, char separator) {
            this.item = value;
            this.enquote = flg;
            this.separator = separator;
        }

        public String getItem() {
            return CsvLine.enquote(this.item, this.enquote, this.separator);
        }

        public String getRawItem() {
            return this.item;
        }
    }
}

