/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.connection;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;

public class Query {
    private Connection connection;
    private Statement statement;
    private ResultSet resultSet;
    private String sql;
    private boolean nullAction;

    public Query(Connection value) throws SQLException {
        this.connection = value;
    }

    public void setConnection(Connection value) {
        this.connection = value;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setStatement(Statement value) {
        this.statement = value;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setResultSet(ResultSet value) {
        this.resultSet = value;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void setSql(String value) throws SQLException {
        this.sql = value;
        this.statement = this.connection.createStatement();
    }

    public String getSql() {
        return this.sql;
    }

    public void setNullAction(boolean flg) {
        this.nullAction = flg;
    }

    public boolean getNullAction() {
        return this.nullAction;
    }

    public void executeQuery() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        this.resultSet = this.statement.executeQuery(this.sql);
    }

    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        if (this.statement != null) {
            this.statement.close();
        }
    }

    public int findColumn(String columnName) throws SQLException {
        return this.resultSet.findColumn(columnName);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSet.getMetaData();
    }

    public void update4BLOB(String columnName, InputStream is) throws SQLException, IOException {
        if (this.resultSet.next()) {
            OutputStream os = this.resultSet.getBlob(columnName).setBinaryStream(0L);
            byte[] inBytes = new byte[65534];
            int numBytes = is.read(inBytes);
            while (numBytes > 0) {
                os.write(inBytes, 0, numBytes);
                numBytes = is.read(inBytes);
            }
            os.flush();
            os.close();
        }
        is.close();
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        InputStream col = this.resultSet.getAsciiStream(columnIndex);
        if (col == null && this.nullAction) {
            byte[] buf = new byte[]{};
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            col = bais;
        }
        return col;
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        InputStream col = this.resultSet.getAsciiStream(columnName);
        if (col == null && this.nullAction) {
            byte[] buf = new byte[]{};
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            col = bais;
        }
        return col;
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.resultSet.getBigDecimal(columnIndex);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.resultSet.getBigDecimal(columnName);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.resultSet.getBigDecimal(columnIndex, scale);
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.resultSet.getBigDecimal(columnName, scale);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        InputStream col = this.resultSet.getBinaryStream(columnIndex);
        if (col == null && this.nullAction) {
            byte[] buf = new byte[]{};
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            col = bais;
        }
        return col;
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        InputStream col = this.resultSet.getBinaryStream(columnName);
        if (col == null && this.nullAction) {
            byte[] buf = new byte[]{};
            return new ByteArrayInputStream(buf);
        }
        return col;
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.resultSet.getBoolean(columnIndex);
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.resultSet.getBoolean(columnName);
    }

    public byte getByte(int columnIndex) throws SQLException {
        return this.resultSet.getByte(columnIndex);
    }

    public byte getByte(String columnName) throws SQLException {
        return this.resultSet.getByte(columnName);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.resultSet.getBytes(columnIndex);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.resultSet.getBytes(columnName);
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.resultSet.getDate(columnIndex);
    }

    public Date getDate(String columnName) throws SQLException {
        return this.resultSet.getDate(columnName);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.resultSet.getDouble(columnIndex);
    }

    public double getDouble(String columnName) throws SQLException {
        return this.resultSet.getDouble(columnName);
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this.resultSet.getFloat(columnIndex);
    }

    public float getFloat(String columnName) throws SQLException {
        return this.resultSet.getFloat(columnName);
    }

    public int getInt(int columnIndex) throws SQLException {
        return this.resultSet.getInt(columnIndex);
    }

    public int getInt(String columnName) throws SQLException {
        return this.resultSet.getInt(columnName);
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.resultSet.getLong(columnIndex);
    }

    public long getLong(String columnName) throws SQLException {
        return this.resultSet.getLong(columnName);
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.resultSet.getObject(columnIndex);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.resultSet.getObject(columnName);
    }

    public short getShort(int columnIndex) throws SQLException {
        return this.resultSet.getShort(columnIndex);
    }

    public short getShort(String columnName) throws SQLException {
        return this.resultSet.getShort(columnName);
    }

    public String getString(int columnIndex) throws SQLException {
        String col = this.resultSet.getString(columnIndex);
        if (col == null && this.nullAction) {
            return "";
        }
        return col;
    }

    public String getString(String columnName) throws SQLException {
        String col = this.resultSet.getString(columnName);
        if (col == null && this.nullAction) {
            return "";
        }
        return col;
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this.resultSet.getTime(columnIndex);
    }

    public Time getTime(String columnName) throws SQLException {
        return this.resultSet.getTime(columnName);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.resultSet.getTimestamp(columnIndex);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.resultSet.getTimestamp(columnName);
    }

    public void setCursorName(String cursorName) throws SQLException {
        this.statement.setCursorName(cursorName);
    }

    public String getCursorName() throws SQLException {
        return this.resultSet.getCursorName();
    }

    public void clearWarnings() throws SQLException {
        this.resultSet.clearWarnings();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    public boolean first() throws SQLException {
        return this.resultSet.first();
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public boolean previous() throws SQLException {
        return this.resultSet.previous();
    }

    public boolean last() throws SQLException {
        return this.resultSet.last();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.resultSet.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        return this.resultSet.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.resultSet.isLast();
    }

    public boolean isNull(int columnIndex) throws SQLException {
        return this.resultSet.getString(columnIndex) == null;
    }

    public boolean isNull(String columnName) throws SQLException {
        return this.resultSet.getString(columnName) == null;
    }

    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String separator = System.getProperty("line.separator");
        sb.append(this.sql);
        sb.append(separator);
        return sb.toString();
    }
}

