/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.connection;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.tk_factory.fivestar.connection.Query;
import net.tk_factory.fivestar.connection.TagNotFoundException;

public class PreparedQuery
extends Query {
    private PreparedStatement pstmt;
    private HashMap<String, Integer> tagTable;
    private HashMap<String, Object> sqlParameters = new HashMap();
    private String tagSql;

    public PreparedQuery(Connection value) throws SQLException {
        super(value);
    }

    public void setTagSql(String value) throws SQLException {
        this.tagSql = value;
        super.setSql(this.tagDivide(value));
        this.pstmt = this.getConnection().prepareStatement(super.getSql());
    }

    public String getTagSql() {
        return this.tagSql;
    }

    public Map<String, Object> getSQLParameters() {
        return this.sqlParameters;
    }

    public void execute() throws SQLException {
        this.pstmt.execute();
    }

    public int executeUpdate() throws SQLException {
        return this.pstmt.executeUpdate();
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.pstmt != null) {
            this.pstmt.close();
        }
    }

    public void setAsciiStream(int index, InputStream value, int length) throws SQLException {
        this.pstmt.setAsciiStream(index, value, length);
    }

    public void setAsciiStream(String key, InputStream value, int length) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, "AsciiStream Length = " + String.valueOf(length));
        this.pstmt.setAsciiStream(index, value, length);
    }

    public void setBinaryStream(int index, InputStream value, int length) throws SQLException {
        this.pstmt.setBinaryStream(index, value, length);
    }

    public void setBinaryStream(String key, InputStream value, int length) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, "BinaryStream Length = " + String.valueOf(length));
        this.pstmt.setBinaryStream(index, value, length);
    }

    public void setNull(int index, int value) throws SQLException {
        this.pstmt.setNull(index, value);
    }

    public void setNull(String key, int value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, "null");
        this.pstmt.setNull(index, value);
    }

    public void setBoolean(int index, boolean value) throws SQLException {
        this.pstmt.setBoolean(index, value);
    }

    public void setBoolean(String key, boolean value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.pstmt.setBoolean(index, value);
    }

    public void setByte(int index, byte value) throws SQLException {
        this.pstmt.setByte(index, value);
    }

    public void setByte(String key, byte value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, new Byte(value));
        this.pstmt.setByte(index, value);
    }

    public void setBytes(int index, byte[] value) throws SQLException {
        this.pstmt.setBytes(index, value);
    }

    public void setBytes(String key, byte[] value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, new String(value));
        this.pstmt.setBytes(index, value);
    }

    public void setString(int index, String value) throws SQLException {
        this.pstmt.setString(index, value);
    }

    public void setString(String key, String value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.pstmt.setString(index, value);
    }

    public void setShort(int index, short value) throws SQLException {
        this.pstmt.setShort(index, value);
    }

    public void setShort(String key, short value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, new Short(value));
        this.pstmt.setShort(index, value);
    }

    public void setInt(int index, int value) throws SQLException {
        this.pstmt.setInt(index, value);
    }

    public void setInt(String key, int value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, new Integer(value));
        this.pstmt.setInt(index, value);
    }

    public void setLong(int index, long value) throws SQLException {
        this.pstmt.setLong(index, value);
    }

    public void setLong(String key, long value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, new Long(value));
        this.pstmt.setLong(index, value);
    }

    public void setDouble(int index, double value) throws SQLException {
        this.pstmt.setDouble(index, value);
    }

    public void setDouble(String key, double value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, new Double(value));
        this.pstmt.setDouble(index, value);
    }

    public void setFloat(int index, float value) throws SQLException {
        this.pstmt.setFloat(index, value);
    }

    public void setFloat(String key, float value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, new Float(value));
        this.pstmt.setFloat(index, value);
    }

    public void setBigDecimal(int index, BigDecimal value) throws SQLException {
        this.pstmt.setBigDecimal(index, value);
    }

    public void setBigDecimal(String key, BigDecimal value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.pstmt.setBigDecimal(index, value);
    }

    public void setDate(int index, Date value) throws SQLException {
        this.pstmt.setDate(index, value);
    }

    public void setDate(String key, Date value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.pstmt.setDate(index, value);
    }

    public void setTime(int index, Time value) throws SQLException {
        this.pstmt.setTime(index, value);
    }

    public void setTime(String key, Time value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.pstmt.setTime(index, value);
    }

    public void setTimestamp(int index, Timestamp value) throws SQLException {
        this.pstmt.setTimestamp(index, value);
    }

    public void setTimestamp(String key, Timestamp value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.pstmt.setTimestamp(index, value);
    }

    public void setObject(int index, Object value) throws SQLException {
        this.pstmt.setObject(index, value);
    }

    public void setObject(String key, Object value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.pstmt.setObject(index, value);
    }

    public void setObject(int index, Object value, int types) throws SQLException {
        this.pstmt.setObject(index, value, types);
    }

    public void setObject(String key, Object value, int types) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.pstmt.setObject(index, value, types);
    }

    public void setObject(int index, Object value, int types, int scale) throws SQLException {
        this.pstmt.setObject(index, value, types, scale);
    }

    public void setObject(String key, Object value, int types, int scale) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.pstmt.setObject(index, value, types, scale);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        String separator = System.getProperty("line.separator");
        sb.append(this.tagSql);
        sb.append(separator);
        sb.append(this.sqlParameters);
        sb.append(separator);
        return sb.toString();
    }

    private String tagDivide(String value) {
        StringTokenizer st = new StringTokenizer(value, "'!/+-*|{},()<>=\t\n\r\f ", true);
        StringBuffer preparedSql = new StringBuffer();
        int hashCount = 1;
        boolean isChar = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("'")) {
                isChar = !isChar;
            }
            if (!isChar) {
                if (token.startsWith(":") && token.length() > 1) {
                    this.tagTable.put(token.substring(1), new Integer(hashCount));
                    ++hashCount;
                    preparedSql.append("?");
                    continue;
                }
                preparedSql.append(token);
                continue;
            }
            preparedSql.append(token);
        }
        return preparedSql.toString();
    }

    private int getTagIndex(String key) throws TagNotFoundException {
        try {
            return this.tagTable.get(key);
        }
        catch (Exception ex) {
            StringBuffer msg = new StringBuffer();
            msg.append("SQL\u6587\u306e\u4e2d\u306b").append(key).append("\u3068\u3044\u3046\u30bf\u30b0\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            throw new TagNotFoundException(msg.toString());
        }
    }
}

