/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.connection;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.tk_factory.fivestar.connection.TagNotFoundException;

public class PreparedCall {
    private Connection connection;
    private CallableStatement cstmt;
    private HashMap<String, Integer> tagTable;
    private String sql;
    private HashMap<String, Object> sqlParameters = new HashMap();

    public PreparedCall(Connection value) throws SQLException {
        this.tagTable = new HashMap();
        this.connection = value;
    }

    public void setSql(String value) throws SQLException {
        this.sql = value;
        this.cstmt = this.connection.prepareCall(this.sql);
    }

    public void setTagSql(String value) throws SQLException {
        this.sql = this.tagDivide(value);
        this.cstmt = this.connection.prepareCall(this.sql);
    }

    public String getSql() {
        return this.sql;
    }

    public Map<String, Object> getSQLParameters() {
        return this.sqlParameters;
    }

    public void execute() throws SQLException {
        this.cstmt.execute();
    }

    public void close() throws SQLException {
        if (this.cstmt != null) {
            this.cstmt.close();
        }
    }

    public void setAsciiStream(int index, InputStream value, int length) throws SQLException {
        this.cstmt.setAsciiStream(index, value, length);
    }

    public void setAsciiStream(String key, InputStream value, int length) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, "AsciiStream Length = " + String.valueOf(length));
        this.cstmt.setAsciiStream(index, value, length);
    }

    public void setBinaryStream(int index, InputStream value, int length) throws SQLException {
        this.cstmt.setBinaryStream(index, value, length);
    }

    public void setBinaryStream(String key, InputStream value, int length) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, "BinaryStream Length = " + String.valueOf(length));
        this.cstmt.setBinaryStream(index, value, length);
    }

    public void setNull(int index, int value) throws SQLException {
        this.cstmt.setNull(index, value);
    }

    public void setNull(String key, int value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, "null");
        this.cstmt.setNull(index, value);
    }

    public void setBoolean(int index, boolean value) throws SQLException {
        this.cstmt.setBoolean(index, value);
    }

    public void setBoolean(String key, boolean value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.cstmt.setBoolean(index, value);
    }

    public boolean getBoolean(int index) throws SQLException {
        return this.cstmt.getBoolean(index);
    }

    public boolean getBoolean(String key) throws SQLException {
        int index = this.tagTable.get(key);
        return this.cstmt.getBoolean(index);
    }

    public void setByte(int index, byte value) throws SQLException {
        this.cstmt.setByte(index, value);
    }

    public void setByte(String key, byte value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, new Byte(value));
        this.cstmt.setByte(index, value);
    }

    public byte getByte(int index) throws SQLException {
        return this.cstmt.getByte(index);
    }

    public byte getByte(String key) throws SQLException {
        int index = this.tagTable.get(key);
        return this.cstmt.getByte(index);
    }

    public void setBytes(int index, byte[] value) throws SQLException {
        this.cstmt.setBytes(index, value);
    }

    public void setBytes(String key, byte[] value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, new String(value));
        this.cstmt.setBytes(index, value);
    }

    public byte[] getBytes(int index) throws SQLException {
        return this.cstmt.getBytes(index);
    }

    public byte[] getBytes(String key) throws SQLException {
        int index = this.tagTable.get(key);
        return this.cstmt.getBytes(index);
    }

    public void setString(int index, String value) throws SQLException {
        this.cstmt.setString(index, value);
    }

    public void setString(String key, String value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.setString(index, value);
    }

    public String getString(int index) throws SQLException {
        return this.cstmt.getString(index);
    }

    public String getString(String key) throws SQLException {
        int index = this.tagTable.get(key);
        return this.cstmt.getString(index);
    }

    public void setShort(int index, short value) throws SQLException {
        this.cstmt.setShort(index, value);
    }

    public void setShort(String key, short value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, new Short(value));
        this.cstmt.setShort(index, value);
    }

    public short getShort(int index) throws SQLException {
        return this.cstmt.getShort(index);
    }

    public short getShort(String key) throws SQLException {
        int index = this.tagTable.get(key);
        return this.cstmt.getShort(index);
    }

    public void setInt(int index, int value) throws SQLException {
        this.cstmt.setInt(index, value);
    }

    public void setInt(String key, int value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, new Integer(value));
        this.cstmt.setInt(index, value);
    }

    public int getInt(int index) throws SQLException {
        return this.cstmt.getInt(index);
    }

    public int getInt(String key) throws SQLException {
        int index = this.tagTable.get(key);
        return this.cstmt.getInt(index);
    }

    public void setLong(int index, long value) throws SQLException {
        this.cstmt.setLong(index, value);
    }

    public void setLong(String key, long value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, new Long(value));
        this.cstmt.setLong(index, value);
    }

    public long getLong(int index) throws SQLException {
        return this.cstmt.getLong(index);
    }

    public long getLong(String key) throws SQLException {
        int index = this.tagTable.get(key);
        return this.cstmt.getLong(index);
    }

    public void setBigDecimal(int index, BigDecimal value) throws SQLException {
        this.cstmt.setBigDecimal(index, value);
    }

    public void setBigDecimal(String key, BigDecimal value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.cstmt.setBigDecimal(index, value);
    }

    public BigDecimal getBigDecimal(int index) throws SQLException {
        return this.cstmt.getBigDecimal(index);
    }

    public BigDecimal getBigDecimal(String key) throws SQLException {
        int index = this.tagTable.get(key);
        return this.cstmt.getBigDecimal(index);
    }

    public BigDecimal getBigDecimal(int index, int scale) throws SQLException {
        return this.cstmt.getBigDecimal(index, scale);
    }

    public BigDecimal getBigDecimal(String key, int scale) throws SQLException {
        int index = this.tagTable.get(key);
        return this.cstmt.getBigDecimal(index, scale);
    }

    public void setDouble(int index, double value) throws SQLException {
        this.cstmt.setDouble(index, value);
    }

    public void setDouble(String key, double value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, new Double(value));
        this.cstmt.setDouble(index, value);
    }

    public double getDouble(int index) throws SQLException {
        return this.cstmt.getDouble(index);
    }

    public double getDouble(String key) throws SQLException {
        int index = this.tagTable.get(key);
        return this.cstmt.getDouble(index);
    }

    public void setFloat(int index, float value) throws SQLException {
        this.cstmt.setFloat(index, value);
    }

    public void setFloat(String key, float value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, new Float(value));
        this.cstmt.setFloat(index, value);
    }

    public float getFloat(int index) throws SQLException {
        return this.cstmt.getFloat(index);
    }

    public float getFloat(String key) throws SQLException {
        int index = this.tagTable.get(key);
        return this.cstmt.getFloat(index);
    }

    public void setDate(int index, Date value) throws SQLException {
        this.cstmt.setDate(index, value);
    }

    public void setDate(String key, Date value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.cstmt.setDate(index, value);
    }

    public Date getDate(int index) throws SQLException {
        return this.cstmt.getDate(index);
    }

    public Date getDate(String key) throws SQLException {
        int index = this.tagTable.get(key);
        return this.cstmt.getDate(index);
    }

    public void setTime(int index, Time value) throws SQLException {
        this.cstmt.setTime(index, value);
    }

    public void setTime(String key, Time value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.cstmt.setTime(index, value);
    }

    public Time getTime(int index) throws SQLException {
        return this.cstmt.getTime(index);
    }

    public Time getTime(String key) throws SQLException {
        int index = this.tagTable.get(key);
        return this.cstmt.getTime(index);
    }

    public void setTimestamp(int index, Timestamp value) throws SQLException {
        this.cstmt.setTimestamp(index, value);
    }

    public void setTimestamp(String key, Timestamp value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.cstmt.setTimestamp(index, value);
    }

    public Timestamp getTimestamp(int index) throws SQLException {
        return this.cstmt.getTimestamp(index);
    }

    public Timestamp getTimestamp(String key) throws SQLException {
        int index = this.tagTable.get(key);
        return this.cstmt.getTimestamp(index);
    }

    public void setObject(int index, Object value) throws SQLException {
        this.cstmt.setObject(index, value);
    }

    public void setObject(String key, Object value) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.cstmt.setObject(index, value);
    }

    public void setObject(int index, Object value, int types) throws SQLException {
        this.cstmt.setObject(index, value, types);
    }

    public void setObject(String key, Object value, int types) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.cstmt.setObject(index, value, types);
    }

    public void setObject(int index, Object value, int types, int scale) throws SQLException {
        this.cstmt.setObject(index, value, types, scale);
    }

    public void setObject(String key, Object value, int types, int scale) throws SQLException {
        int index = this.getTagIndex(key);
        this.sqlParameters.put(key, value);
        this.cstmt.setObject(index, value, types, scale);
    }

    public Object getObject(int index) throws SQLException {
        return this.cstmt.getObject(index);
    }

    public Object getObject(String key) throws SQLException {
        int index = this.tagTable.get(key);
        return this.cstmt.getObject(index);
    }

    public void registerOutParameter(int index, int types) throws SQLException {
        this.cstmt.registerOutParameter(index, types);
    }

    public void registerOutParameter(String key, int types) throws SQLException {
        int index = this.tagTable.get(key);
        this.cstmt.registerOutParameter(index, types);
    }

    public void registerOutParameter(int index, int types, int scale) throws SQLException {
        this.cstmt.registerOutParameter(index, types, scale);
    }

    public void registerOutParameter(String key, int types, int scale) throws SQLException {
        int index = this.tagTable.get(key);
        this.cstmt.registerOutParameter(index, types, scale);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String separator = System.getProperty("line.separator");
        sb.append(this.sql).append(separator);
        sb.append(this.tagTable).append(separator);
        return sb.toString();
    }

    private String tagDivide(String value) {
        StringTokenizer st = new StringTokenizer(value, "'!/+-*|{},()<>=\t\n\r\f ", true);
        StringBuffer preparedSql = new StringBuffer();
        int hashCount = 1;
        boolean isChar = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("'")) {
                isChar = !isChar;
            }
            if (!isChar) {
                if (token.startsWith(":") && token.length() > 1) {
                    this.tagTable.put(token.substring(1), new Integer(hashCount));
                    ++hashCount;
                    preparedSql.append("?");
                    continue;
                }
                preparedSql.append(token);
                continue;
            }
            preparedSql.append(token);
        }
        return preparedSql.toString();
    }

    private int getTagIndex(String key) throws TagNotFoundException {
        try {
            return this.tagTable.get(key);
        }
        catch (Exception ex) {
            StringBuffer msg = new StringBuffer();
            msg.append("SQL\u6587\u306e\u4e2d\u306b").append(key).append("\u3068\u3044\u3046\u30bf\u30b0\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            throw new TagNotFoundException(msg.toString());
        }
    }
}

