/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.check;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.tk_factory.fivestar.check.AbstractCheck;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLCheck
extends AbstractCheck {
    public static final int NONE = 0;
    public static final int FATAL = 1;
    public static final int ERROR = 2;
    public static final int WARNING = 3;
    public static final int NOT_EXISTS_FILE = 4;
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private File xml;
    private File schema;
    private SAXHandler handler;

    public XMLCheck() {
        this.handler = new SAXHandler();
    }

    public XMLCheck(String xmlFilePath, String schemaFilePath) {
        this(new File(xmlFilePath), new File(schemaFilePath));
    }

    public XMLCheck(File xml, File schema) {
        this.setXml(xml);
        this.setSchema(schema);
        this.handler = new SAXHandler();
    }

    public void setXml(File xml) {
        this.xml = xml;
    }

    public File getXml() {
        return this.xml;
    }

    public String getXmlName() {
        if (this.xml == null) {
            return null;
        }
        return this.xml.getName();
    }

    public void setSchema(File schema) {
        this.schema = schema;
    }

    public File getSchema() {
        return this.schema;
    }

    public String getSchemaName() {
        if (this.schema == null) {
            return null;
        }
        return this.schema.getName();
    }

    public void setHandler(SAXHandler handler) {
        this.handler = handler;
    }

    public SAXHandler getHandler() {
        return this.handler;
    }

    public List<String> getListFatal() {
        if (this.handler == null) {
            return null;
        }
        return this.handler.getListFatal();
    }

    public List<String> getListError() {
        if (this.handler == null) {
            return null;
        }
        return this.handler.getListError();
    }

    public List<String> getListWarning() {
        if (this.handler == null) {
            return null;
        }
        return this.handler.getListWarning();
    }

    public void clearAllList() {
        if (this.handler != null) {
            this.handler.clearAllList();
        }
    }

    @Override
    public int validate() throws ParserConfigurationException, SAXException, IOException {
        if (this.xml == null) {
            return 4;
        }
        if (!this.xml.exists()) {
            return 4;
        }
        if (this.schema == null) {
            return 4;
        }
        if (!this.schema.exists()) {
            return 4;
        }
        this.clearAllList();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.setProperty(SCHEMA_LANGUAGE, XML_SCHEMA);
        saxParser.setProperty(SCHEMA_SOURCE, this.schema);
        saxParser.parse((InputStream)new FileInputStream(this.xml), (DefaultHandler)this.handler);
        if (!this.handler.getListFatal().isEmpty()) {
            return 1;
        }
        if (!this.handler.getListError().isEmpty()) {
            return 2;
        }
        if (!this.handler.getListWarning().isEmpty()) {
            return 3;
        }
        return 0;
    }

    private class SAXHandler
    extends DefaultHandler {
        private List<String> listWarning = new ArrayList<String>();
        private List<String> listError = new ArrayList<String>();
        private List<String> listFatal = new ArrayList<String>();

        public List<String> getListWarning() {
            return this.listWarning;
        }

        public void setListWarning(List<String> values) {
            this.listWarning = values;
        }

        public void clearListWarning() {
            if (this.listWarning != null) {
                this.listWarning.clear();
            }
        }

        public List<String> getListError() {
            return this.listError;
        }

        public void setListError(List<String> values) {
            this.listError = values;
        }

        public void clearListError() {
            if (this.listError != null) {
                this.listError.clear();
            }
        }

        public List<String> getListFatal() {
            return this.listFatal;
        }

        public void setListFatal(List<String> values) {
            this.listFatal = values;
        }

        public void clearListFatal() {
            if (this.listFatal != null) {
                this.listFatal.clear();
            }
        }

        @Override
        public void warning(SAXParseException saxpe) {
            StringBuffer msg = new StringBuffer();
            msg.append("[WARNING:").append(saxpe.getLineNumber()).append("]").append(saxpe.getMessage());
            this.listWarning.add(msg.toString());
        }

        @Override
        public void error(SAXParseException saxpe) {
            StringBuffer msg = new StringBuffer();
            msg.append("[ERROR  :").append(saxpe.getLineNumber()).append("]").append(saxpe.getMessage());
            this.listError.add(msg.toString());
        }

        @Override
        public void fatalError(SAXParseException saxpe) {
            StringBuffer msg = new StringBuffer();
            msg.append("[FATAL  :").append(saxpe.getLineNumber()).append("]").append(saxpe.getMessage());
            this.listFatal.add(msg.toString());
        }

        public void clearAllList() {
            this.clearListWarning();
            this.clearListError();
            this.clearListFatal();
        }
    }
}

