/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.check;

import java.io.UnsupportedEncodingException;
import net.tk_factory.fivestar.check.AbstractCheck;

public class StringCheck
extends AbstractCheck {
    public static final int TYPE_ANY = 0;
    public static final int TYPE_ALPHABET = 1;
    public static final int TYPE_NUMERIC = 2;
    public static final int TYPE_ALPHABET_NUMERIC = 3;
    public static final int TYPE_KANA = 4;
    public static final int TYPE_ANK = 7;
    public static final int TYPE_SJIS = 8;
    public static final int TYPE_SYMBOL = 16;
    public static final int TYPE_ASCII = 19;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_NULL_VALUE = 1;
    public static final int ERROR_INVALID_CHARACTER_TYPE = 2;
    public static final int ERROR_TOO_SHORT = 3;
    public static final int ERROR_TOO_LONG = 4;
    private int characterType = 0;
    private boolean limitLength;
    private int minLength;
    private int maxLength = Integer.MAX_VALUE;
    private String value;
    private boolean trim;

    public StringCheck(String value, boolean notNull) {
        this.setValue(value);
        this.setNotNull(notNull);
    }

    public StringCheck(String value, int characterType) {
        this.setValue(value);
        this.setCharacterType(characterType);
    }

    public StringCheck(String value, boolean notNull, int characterType) {
        this.setValue(value);
        this.setNotNull(notNull);
        this.setCharacterType(characterType);
    }

    public StringCheck(String value, int characterType, int minLength, int maxLength) {
        this.setValue(value);
        this.setCharacterType(characterType);
        this.setLimitLength(minLength, maxLength);
    }

    public StringCheck(String value, boolean notNull, int characterType, int minLength, int maxLength) {
        this.setValue(value);
        this.setNotNull(notNull);
        this.setCharacterType(characterType);
        this.setLimitLength(minLength, maxLength);
    }

    public StringCheck(String value, boolean notNull, int characterType, int minLength, int maxLength, boolean trim) {
        this.setValue(value);
        this.setNotNull(notNull);
        this.setCharacterType(characterType);
        this.setLimitLength(minLength, maxLength);
        this.setTrim(trim);
    }

    public void setCharacterType(int characterType) {
        this.characterType = characterType;
    }

    public int getCharacterType() {
        return this.characterType;
    }

    public void setLimitLength(int minLength, int maxLength) {
        if (maxLength < minLength) {
            StringBuffer msg = new StringBuffer();
            msg.append("minLength=").append(minLength).append(",maxLength=").append(maxLength);
            throw new IllegalArgumentException(msg.toString());
        }
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.limitLength = true;
    }

    public void setUnlimitStringLength() {
        this.minLength = 0;
        this.maxLength = Integer.MAX_VALUE;
        this.limitLength = false;
    }

    public boolean isLimitLength() {
        return this.limitLength;
    }

    public void setMinLength(int minLength) {
        if (this.maxLength < minLength) {
            StringBuffer msg = new StringBuffer();
            msg.append("minLength=").append(minLength).append(",maxLength=").append(this.maxLength);
            throw new IllegalArgumentException(msg.toString());
        }
        this.minLength = minLength;
        this.limitLength = true;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMaxLength(int maxLength) {
        if (maxLength < this.minLength) {
            StringBuffer msg = new StringBuffer();
            msg.append("minLength=").append(this.minLength).append(",maxLength=").append(maxLength);
            throw new IllegalArgumentException(msg.toString());
        }
        this.maxLength = maxLength;
        this.limitLength = true;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setValue(String value) {
        this.value = value != null && this.trim ? value.trim() : value;
    }

    public String getValue() {
        return this.value;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public boolean isTrim() {
        return this.trim;
    }

    @Override
    public int validate() {
        if (!this.isNotNullValue()) {
            if (this.isNotNull()) {
                return 1;
            }
        } else {
            if (!this.isValidCharacterType()) {
                return 2;
            }
            int result = this.validateLimitLength();
            if (result != 0) {
                return result;
            }
        }
        return 0;
    }

    public String toString() {
        return this.value;
    }

    private boolean isValidCharacterType() {
        if (this.getCharacterType() == 0) {
            return true;
        }
        if (!this.isNotNullValue()) {
            return true;
        }
        int length = this.value.length();
        int i = 0;
        while (i < length) {
            if ((this.getType(this.value.charAt(i)) & this.getCharacterType()) == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int getType(char character) {
        byte[] sjisCharacter;
        try {
            String sjisString = new Character(character).toString();
            sjisCharacter = sjisString.getBytes("MS932");
        }
        catch (UnsupportedEncodingException ex) {
            return 0;
        }
        if (sjisCharacter.length == 2) {
            return 8;
        }
        int type = Character.getType(character);
        if (type == 5 || type == 4) {
            return 4;
        }
        if (Character.isDigit(character)) {
            return 2;
        }
        if (Character.isLetter(character)) {
            return 1;
        }
        return 16;
    }

    private int getValueByteSize() {
        int byteSize = 0;
        if (this.value != null) {
            byteSize = this.value.getBytes().length;
        }
        return byteSize;
    }

    private boolean isNotNullValue() {
        return this.value != null && this.value.length() > 0;
    }

    private int validateLimitLength() {
        if (this.isLimitLength()) {
            int byteSize = this.getValueByteSize();
            if (byteSize < this.getMinLength()) {
                return 3;
            }
            if (byteSize > this.getMaxLength()) {
                return 4;
            }
        }
        return 0;
    }
}

