/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.check;

import java.io.UnsupportedEncodingException;
import net.tk_factory.fivestar.check.AbstractCheck;

public class NumberCheck
extends AbstractCheck {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_NULL_VALUE = 1;
    public static final int ERROR_NOT_NUMERIC = 2;
    public static final int ERROR_TOO_SMALL = 3;
    public static final int ERROR_TOO_BIG = 4;
    private boolean limitValue;
    private long minValue = Long.MIN_VALUE;
    private long maxValue = Long.MAX_VALUE;
    private String value;

    public NumberCheck(String value) {
        this.setValue(value);
    }

    public NumberCheck(long value) {
        this.setValue(value);
    }

    public NumberCheck(String value, boolean notNull) {
        this.setValue(value);
        this.setNotNull(notNull);
    }

    public NumberCheck(long value, boolean notNull) {
        this.setValue(value);
        this.setNotNull(notNull);
    }

    public NumberCheck(String value, long minValue, long maxValue) {
        this.setValue(value);
        this.setLimitValue(minValue, maxValue);
    }

    public NumberCheck(long value, long minValue, long maxValue) {
        this.setValue(value);
        this.setLimitValue(minValue, maxValue);
    }

    public NumberCheck(String value, boolean notNull, long minValue, long maxValue) {
        this.setValue(value);
        this.setNotNull(notNull);
        this.setLimitValue(minValue, maxValue);
    }

    public NumberCheck(long value, boolean notNull, long minValue, long maxValue) {
        this.setValue(value);
        this.setNotNull(notNull);
        this.setLimitValue(minValue, maxValue);
    }

    public void setLimitValue(long minValue, long maxValue) {
        if (maxValue < minValue) {
            StringBuffer msg = new StringBuffer();
            msg.append("minValue=").append(minValue).append(",maxValue=").append(maxValue);
            throw new IllegalArgumentException(msg.toString());
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.limitValue = true;
    }

    public void setUnLimitNumberLength() {
        this.minValue = Long.MIN_VALUE;
        this.maxValue = Long.MAX_VALUE;
        this.limitValue = false;
    }

    public boolean isLimitValue() {
        return this.limitValue;
    }

    public void setMinValue(long minValue) {
        if (this.maxValue < minValue) {
            StringBuffer msg = new StringBuffer();
            msg.append("minValue=").append(minValue).append(",maxValue=").append(this.maxValue);
            throw new IllegalArgumentException(msg.toString());
        }
        this.minValue = minValue;
        this.limitValue = true;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(long maxValue) {
        if (maxValue < this.minValue) {
            StringBuffer msg = new StringBuffer();
            msg.append("minValue=").append(this.minValue).append(",maxValue=").append(maxValue);
            throw new IllegalArgumentException(msg.toString());
        }
        this.maxValue = maxValue;
        this.limitValue = true;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setValue(long value) {
        this.value = Long.toString(value);
    }

    public void setValue(String value) {
        this.value = value != null ? value.trim() : null;
    }

    public String getValueAsString() {
        return this.value;
    }

    public long getValue() {
        long longValue = 0L;
        if (this.isNumericValue()) {
            try {
                longValue = Long.valueOf(this.value);
            }
            catch (NumberFormatException ex) {
                longValue = 0L;
            }
        }
        return longValue;
    }

    @Override
    public int validate() {
        if (!this.isNotNullValue()) {
            if (this.isNotNull()) {
                return 1;
            }
        } else {
            if (!this.isNumericValue()) {
                return 2;
            }
            int result = this.validateLimitValue();
            if (result != 0) {
                return result;
            }
        }
        return 0;
    }

    public String toString() {
        return this.value;
    }

    private boolean isNotNullValue() {
        return this.value != null && this.value.trim().length() > 0;
    }

    private boolean isNumericValue() {
        if (this.value == null) {
            return false;
        }
        int length = this.value.length();
        int i = 0;
        while (i < length) {
            byte[] sjisCharacter;
            try {
                char c = this.value.charAt(i);
                String sjisString = new Character(c).toString();
                sjisCharacter = sjisString.getBytes("MS932");
            }
            catch (UnsupportedEncodingException ex) {
                return false;
            }
            if (sjisCharacter.length > 1) {
                return false;
            }
            ++i;
        }
        try {
            Long.valueOf(this.value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private int validateLimitValue() {
        if (this.isLimitValue()) {
            long longValue = this.getValue();
            if (longValue < this.getMinValue()) {
                return 3;
            }
            if (longValue > this.getMaxValue()) {
                return 4;
            }
        }
        return 0;
    }
}

