/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.check;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.GregorianCalendar;
import net.tk_factory.fivestar.check.AbstractCheck;

public class DateCheck
extends AbstractCheck {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_NULL_VALUE = 1;
    public static final int ERROR_INVALID_DATE = 2;
    private Date date;
    private String year;
    private String month;
    private String day;
    private String hour;
    private String minute;
    private String second;

    public DateCheck(Date date) {
        this.setDate(date);
    }

    public DateCheck(Date date, boolean notNull) {
        this.setDate(date);
        this.setNotNull(notNull);
    }

    public DateCheck(String year, String month, String day) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setHour("0");
        this.setMinute("0");
        this.setSecond("0");
    }

    public DateCheck(String year, String month, String day, boolean notNull) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setHour("0");
        this.setMinute("0");
        this.setSecond("0");
        this.setNotNull(notNull);
    }

    public DateCheck(int year, int month, int day) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setHour(0);
        this.setMinute(0);
        this.setSecond(0);
    }

    public DateCheck(int year, int month, int day, boolean notNull) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setHour(0);
        this.setMinute(0);
        this.setSecond(0);
        this.setNotNull(notNull);
    }

    public DateCheck(String year, String month, String day, String hour, String minute, String second) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
    }

    public DateCheck(String year, String month, String day, String hour, String minute, String second, boolean notNull) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
        this.setNotNull(notNull);
    }

    public DateCheck(int year, int month, int day, int hour, int minute, int second) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
    }

    public DateCheck(int year, int month, int day, int hour, int minute, int second, boolean notNull) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
        this.setNotNull(notNull);
    }

    public boolean isNull() {
        boolean hms;
        boolean ymd = this.isNullYear() && this.isNullMonth() && this.isNullDay();
        boolean bl = hms = this.isNullHour() && this.isNullMinute() && this.isNullSecond();
        return ymd && hms;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public void setYear(int year) {
        this.year = String.valueOf(year);
    }

    public int getYearToNumber() {
        if (!this.isNarrow(this.year)) {
            throw new IllegalArgumentException("Year = " + this.year);
        }
        int year = Integer.parseInt(this.year);
        if (year < 0) {
            throw new IllegalArgumentException("Year = " + this.year);
        }
        return year;
    }

    public String getYear() {
        return this.year;
    }

    public boolean isNullYear() {
        if (this.date != null) {
            return false;
        }
        return this.year == null || this.year.trim().length() == 0;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public void setMonth(int month) {
        this.month = String.valueOf(month);
    }

    public int getMonthToNumber() {
        if (!this.isNarrow(this.month)) {
            throw new IllegalArgumentException("Month = " + this.month);
        }
        int month = Integer.parseInt(this.month);
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Month = " + this.month);
        }
        return month;
    }

    public String getMonth() {
        return this.month;
    }

    public boolean isNullMonth() {
        if (this.date != null) {
            return false;
        }
        return this.month == null || this.month.trim().length() == 0;
    }

    public void setDay(String day) {
        this.day = day;
    }

    public void setDay(int day) {
        this.day = String.valueOf(day);
    }

    public int getDayToNumber() {
        if (!this.isNarrow(this.day)) {
            throw new IllegalArgumentException("Day = " + this.day);
        }
        int day = Integer.parseInt(this.day);
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("Day = " + this.day);
        }
        return day;
    }

    public String getDay() {
        return this.day;
    }

    public boolean isNullDay() {
        if (this.date != null) {
            return false;
        }
        return this.day == null || this.day.trim().length() == 0;
    }

    public void setHour(String hour) {
        this.hour = hour;
    }

    public void setHour(int hour) {
        this.hour = String.valueOf(hour);
    }

    public int getHourToNumber() {
        if (!this.isNarrow(this.hour)) {
            throw new IllegalArgumentException("Hour = " + this.hour);
        }
        int hour = Integer.parseInt(this.hour);
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Hour = " + this.hour);
        }
        return hour;
    }

    public String getHour() {
        return this.hour;
    }

    public boolean isNullHour() {
        if (this.date != null) {
            return false;
        }
        return this.hour == null || this.hour.trim().length() == 0;
    }

    public void setMinute(String minute) {
        this.minute = minute;
    }

    public void setMinute(int minute) {
        this.minute = String.valueOf(minute);
    }

    public int getMinuteToNumber() {
        if (!this.isNarrow(this.minute)) {
            throw new IllegalArgumentException("Minute = " + this.minute);
        }
        int minute = Integer.parseInt(this.minute);
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Minute = " + this.minute);
        }
        return minute;
    }

    public String getMinute() {
        return this.minute;
    }

    public boolean isNullMinute() {
        if (this.date != null) {
            return false;
        }
        return this.minute == null || this.minute.trim().length() == 0;
    }

    public void setSecond(String second) {
        this.second = second;
    }

    public void setSecond(int second) {
        this.second = String.valueOf(second);
    }

    public int getSecondToNumber() {
        if (!this.isNarrow(this.second)) {
            throw new IllegalArgumentException("Second = " + this.second);
        }
        int second = Integer.parseInt(this.second);
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("Second = " + this.second);
        }
        return second;
    }

    public String getSecond() {
        return this.second;
    }

    public boolean isNullSecond() {
        if (this.date != null) {
            return false;
        }
        return this.second == null || this.second.trim().length() == 0;
    }

    public void setDate(Date date) {
        if (date == null) {
            return;
        }
        this.date = new Date(date.getTime());
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        this.year = String.valueOf(calendar.get(1));
        this.month = String.valueOf(calendar.get(2) + 1);
        this.day = String.valueOf(calendar.get(5));
        this.hour = String.valueOf(calendar.get(10));
        this.minute = String.valueOf(calendar.get(12));
        this.second = String.valueOf(calendar.get(13));
    }

    public Date getDate() {
        if (this.date != null) {
            return new Date(this.date.getTime());
        }
        int year = this.getYearToNumber();
        int month = this.getMonthToNumber() - 1;
        int day = this.getDayToNumber();
        int hour = this.getHourToNumber();
        int minute = this.getMinuteToNumber();
        int second = this.getSecondToNumber();
        try {
            GregorianCalendar calendar = new GregorianCalendar(year, month, day, hour, minute, second);
            calendar.setLenient(false);
            this.date = calendar.getTime();
            return new Date(this.date.getTime());
        }
        catch (IllegalArgumentException ex) {
            StringBuffer msg = new StringBuffer();
            msg.append("Year = ").append(this.year).append(", ").append("Month = ").append(this.month).append(", ").append("Day = ").append(this.day).append(", ").append("Hour = ").append(this.hour).append(", ").append("Minute = ").append(this.minute).append(", ").append("Second = ").append(this.second);
            throw new IllegalArgumentException(msg.toString());
        }
    }

    @Override
    public int validate() {
        if (!this.isNotNullValue()) {
            if (this.isNotNull()) {
                return 1;
            }
        } else {
            try {
                this.getDate();
            }
            catch (NumberFormatException ex) {
                return 2;
            }
            catch (IllegalArgumentException ex) {
                return 2;
            }
        }
        return 0;
    }

    public String toString() {
        return this.date.toString();
    }

    private boolean isNarrow(String value) {
        if (value == null) {
            return false;
        }
        int length = value.length();
        int i = 0;
        while (i < length) {
            byte[] sjisCharacter;
            try {
                char c = value.charAt(i);
                String sjisString = new Character(c).toString();
                sjisCharacter = sjisString.getBytes("MS932");
            }
            catch (UnsupportedEncodingException ex) {
                return false;
            }
            if (sjisCharacter.length > 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isNotNullValue() {
        return this.date != null || !this.isNullYear() || !this.isNullMonth() || !this.isNullDay();
    }
}

