/*
 * Decompiled with CFR 0.152.
 */
package net.tk_factory.fivestar.check;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import net.tk_factory.fivestar.check.AbstractCheck;

public class BigDecimalCheck
extends AbstractCheck {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_NULL_VALUE = 1;
    public static final int ERROR_NOT_NUMERIC = 2;
    public static final int ERROR_TOO_SCALE_SMALL = 3;
    public static final int ERROR_TOO_SCALE_BIG = 4;
    public static final int ERROR_TOO_SMALL = 5;
    public static final int ERROR_TOO_BIG = 6;
    private boolean limitScaleValue;
    private int minScaleValue;
    private int maxScaleValue = Integer.MAX_VALUE;
    private boolean limitValue;
    private BigDecimal minValue;
    private BigDecimal maxValue;
    private String value;

    public BigDecimalCheck(String value) {
        this.setValue(value);
    }

    public BigDecimalCheck(BigDecimal value) {
        this.setValue(value);
    }

    public BigDecimalCheck(String value, boolean notNull) {
        this.setValue(value);
        this.setNotNull(notNull);
    }

    public BigDecimalCheck(BigDecimal value, boolean notNull) {
        this.setValue(value);
        this.setNotNull(notNull);
    }

    public BigDecimalCheck(String value, BigDecimal minValue, BigDecimal maxValue) {
        this.setValue(value);
        this.setLimitValue(minValue, maxValue);
    }

    public BigDecimalCheck(BigDecimal value, BigDecimal minValue, BigDecimal maxValue) {
        this.setValue(value);
        this.setLimitValue(minValue, maxValue);
    }

    public BigDecimalCheck(String value, BigDecimal minValue, BigDecimal maxValue, int minScaleValue, int maxScaleValue) {
        this.setValue(value);
        this.setLimitValue(minValue, maxValue);
        this.setLimitScaleValue(minScaleValue, maxScaleValue);
    }

    public BigDecimalCheck(BigDecimal value, BigDecimal minValue, BigDecimal maxValue, int minScaleValue, int maxScaleValue) {
        this.setValue(value);
        this.setLimitValue(minValue, maxValue);
        this.setLimitScaleValue(minScaleValue, maxScaleValue);
    }

    public BigDecimalCheck(String value, boolean notNull, BigDecimal minValue, BigDecimal maxValue, int minScaleValue, int maxScaleValue) {
        this.setValue(value);
        this.setNotNull(notNull);
        this.setLimitValue(minValue, maxValue);
        this.setLimitScaleValue(minScaleValue, maxScaleValue);
    }

    public BigDecimalCheck(BigDecimal value, boolean notNull, BigDecimal minValue, BigDecimal maxValue, int minScaleValue, int maxScaleValue) {
        this.setValue(value);
        this.setNotNull(notNull);
        this.setLimitValue(minValue, maxValue);
        this.setLimitScaleValue(minScaleValue, maxScaleValue);
    }

    public void setLimitValue(BigDecimal minValue, BigDecimal maxValue) {
        if (minValue != null && maxValue != null && minValue.compareTo(maxValue) > 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("minValue=").append(minValue).append(",maxValue=").append(maxValue);
            throw new IllegalArgumentException(msg.toString());
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.limitValue = true;
    }

    public void setUnLimitValue() {
        this.minValue = null;
        this.maxValue = null;
        this.limitValue = false;
    }

    public boolean isLimitValue() {
        return this.limitValue;
    }

    public void setMinValue(BigDecimal minValue) {
        if (minValue != null && this.maxValue != null && minValue.compareTo(this.maxValue) > 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("minValue=").append(minValue).append(",maxValue=").append(this.maxValue);
            throw new IllegalArgumentException(msg.toString());
        }
        this.minValue = minValue;
        this.limitValue = true;
    }

    public BigDecimal getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(BigDecimal maxValue) {
        if (this.minValue != null && maxValue != null && this.minValue.compareTo(maxValue) > 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("minValue=").append(this.minValue).append(",maxValue=").append(maxValue);
            throw new IllegalArgumentException();
        }
        this.maxValue = maxValue;
        this.limitValue = true;
    }

    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public void setLimitScaleValue(int minScaleValue, int maxScaleValue) {
        if (minScaleValue < 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("minScaleValue=").append(minScaleValue);
            throw new IllegalArgumentException(msg.toString());
        }
        if (maxScaleValue < 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("maxScaleValue=").append(maxScaleValue);
            throw new IllegalArgumentException(msg.toString());
        }
        if (maxScaleValue < minScaleValue) {
            StringBuffer msg = new StringBuffer();
            msg.append("minScaleValue=").append(minScaleValue).append(",maxScaleValue=").append(maxScaleValue);
            throw new IllegalArgumentException(msg.toString());
        }
        this.minScaleValue = minScaleValue;
        this.maxScaleValue = maxScaleValue;
        this.limitScaleValue = true;
    }

    public void setUnLimitScaleValue() {
        this.minScaleValue = 0;
        this.maxScaleValue = Integer.MAX_VALUE;
        this.limitScaleValue = false;
    }

    public boolean isLimitScaleValue() {
        return this.limitScaleValue;
    }

    public void setMinScaleValue(int minScaleValue) {
        if (minScaleValue < 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("minScaleValue=").append(minScaleValue);
            throw new IllegalArgumentException(msg.toString());
        }
        if (this.maxScaleValue < minScaleValue) {
            StringBuffer msg = new StringBuffer();
            msg.append("minScaleValue=").append(minScaleValue).append(",maxScaleValue=").append(this.maxScaleValue);
            throw new IllegalArgumentException(msg.toString());
        }
        this.minScaleValue = minScaleValue;
        this.limitScaleValue = true;
    }

    public int getMinScaleValue() {
        return this.minScaleValue;
    }

    public void setMaxScaleValue(int maxScaleValue) {
        if (maxScaleValue < 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("maxScaleValue=").append(maxScaleValue);
            throw new IllegalArgumentException(msg.toString());
        }
        if (maxScaleValue < this.minScaleValue) {
            StringBuffer msg = new StringBuffer();
            msg.append("minScaleValue=").append(this.minScaleValue).append(",maxScaleValue=").append(maxScaleValue);
            throw new IllegalArgumentException(msg.toString());
        }
        this.maxScaleValue = maxScaleValue;
        this.limitScaleValue = true;
    }

    public int getMaxScaleValue() {
        return this.maxScaleValue;
    }

    public void setValue(BigDecimal value) {
        this.value = value == null ? null : value.toString();
    }

    public void setValue(String value) {
        this.value = value != null ? value.trim() : null;
    }

    public String getValueAsString() {
        return this.value;
    }

    public BigDecimal getValue() {
        BigDecimal bigDecimalValue = null;
        if (this.isNumericValue()) {
            try {
                bigDecimalValue = new BigDecimal(this.value);
            }
            catch (NumberFormatException ex) {
                bigDecimalValue = null;
            }
        }
        return bigDecimalValue;
    }

    @Override
    public int validate() {
        if (!this.isNotNullValue()) {
            if (this.isNotNull()) {
                return 1;
            }
        } else {
            if (!this.isNumericValue()) {
                return 2;
            }
            int result = this.validateLimitScale();
            if (result != 0) {
                return result;
            }
            result = this.validateLimitValue();
            if (result != 0) {
                return result;
            }
        }
        return 0;
    }

    public String toString() {
        return this.value;
    }

    private boolean isNotNullValue() {
        return this.value != null && this.value.trim().length() > 0;
    }

    private boolean isNumericValue() {
        if (this.value == null) {
            return false;
        }
        if (this.value.indexOf("--") != -1) {
            return false;
        }
        int length = this.value.length();
        if (length == 0) {
            return false;
        }
        int i = 0;
        while (i < length) {
            byte[] sjisCharacter;
            try {
                char c = this.value.charAt(i);
                String sjisString = new Character(c).toString();
                sjisCharacter = sjisString.getBytes("MS932");
            }
            catch (UnsupportedEncodingException ex) {
                return false;
            }
            if (sjisCharacter.length > 1) {
                return false;
            }
            ++i;
        }
        try {
            new BigDecimal(this.value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private int validateLimitScale() {
        if (this.isLimitScaleValue()) {
            if (this.getValue().scale() < this.getMinScaleValue()) {
                return 3;
            }
            if (this.getValue().scale() > this.getMaxScaleValue()) {
                return 4;
            }
        }
        return 0;
    }

    private int validateLimitValue() {
        if (this.isLimitValue()) {
            BigDecimal bigDecimalMinValue = this.getMinValue();
            if (bigDecimalMinValue != null && this.getValue().compareTo(bigDecimalMinValue) < 0) {
                return 5;
            }
            BigDecimal bigDecimalMaxValue = this.getMaxValue();
            if (bigDecimalMaxValue != null && this.getValue().compareTo(bigDecimalMaxValue) > 0) {
                return 6;
            }
        }
        return 0;
    }
}

