
#include "defextern.h"

#ifndef STRICT
    #define STRICT
#endif
#include <windows.h>
#include <iostream.h>
#include <fstream.h>
#include "resource.h"
#include "myfilemv.h"
#include "initial.h"
#include "file.h"
#include "main.h"
#include "edit.h"
#include "spi.h"
#include "paintflag.h"
#include "status.h"
#include "tab.h"
#include "mciplay.h"

WORD GetListKeyCmd( UINT msg, WORD ky);
extern void AddListItem(HWND hList, char *szfname, int &iItemNo, int ,WORD);
extern char *GetTabPath(int num);
extern int GetItemCount(HWND hTab);
extern void AddTab(HWND hTab, char *name);



char cdir[MAX_PATH];
char buffer[BUFFER_LEN];
char buffer2[BUFFER_LEN];
char cmdline[BUFFER_LEN];
char initfile[]="filemv.ini";
char logfile[]="filemvlog.txt";
char ldirfile[]="filemvdir.txt";
char listfile[]="filemvlist.ini";
char hislfile[]="filemvhisL.ini";
char hisrfile[]="filemvhisR.ini";
char autofile[]="filemvauto.ini";
char keyfile[]="filemvkey.ini";
char keytxt[]="filemvkey.txt";
char initdirfile[MAX_PATH];
char listdirfile[MAX_PATH];
char hisldirfile[MAX_PATH];
char hisrdirfile[MAX_PATH];
char logdirfile[MAX_PATH];
char localdirfile[MAX_PATH];
char autodirfile[MAX_PATH];
char keydirfile[MAX_PATH];

char sendtoPath[MAX_PATH];

char picExts[ExtsLen]="jpg;gif;png";//jpg;png";//"jpg;jpeg;png"

char cmdstr[1000];
char defCmdstr[1000];

//ftHgŐFgq
#define extDefSpColor ""

char keymouseg[]="mouseTrans";
char keykey[]="key";
char keyenv[]="env";
char keywindow[]="setting";
char keystart[]="start";
char keyfilter[]="filter";
char keydirboth[]="dir set";
char keydirlocal[]="dir left";
char keydirremote[]="dir right";
char keycommand[]="command";
char keyhis[]="his";
int localdirnum;
int bothdirnum;
int remotedirnum;
int sendmenunum;
int findmenunum;

void setExtPaint(char *txt);



#define MAX_NAME 50
#define autofilesavemax 10
const int namenummax=50;
char namelist[namenummax][MAX_NAME];

DWORD keydic[8000];



// switch

class sw
{
	BOOL fl;
	char *key;
	char name[60];
	char *initfile;
public:
	sw() { initfile =NULL; init(); };
	sw(char *k, char *nam, BOOL f) {sw();load(k,nam,f);};
	void init(){ setInit(initdirfile); setKey(keywindow); setFlag(TRUE); }; //default
	void init(char *i, char *k){ setInit(i); setKey(k); setFlag(TRUE); }; //default
	void load(char *k, char *nam, BOOL f) { setName(nam); setKey(k); setFlag(f); initfile=NULL; };
	BOOL load(char *nam, BOOL f=FALSE) 
	{
		setName(nam); setFlag(f);
		return GetProfile();
	};
	void save(BOOL);
	void save(char *);
	char *getKey(){return key;};
	char *getName(){return name;};
	char *getInitfile(){return initfile;};
	BOOL flag(){return fl;};
	void setKey(char *cat) { key =cat;};
	void setName(char *na) {sprintf(name, "%s", na);};
	void setFlag(BOOL f) {fl =f; };
	void flagSw() { fl = !fl; };
	void setInit(char *f) { initfile =f; };
	BOOL GetProfile() ;
};


void sw::save(BOOL f)
{
	if(f) save("TRUE");
	else save("FALSE");
}
void sw::save(char *val)
{
	WritePrivateProfileString(key, name, val, initfile);
}


BOOL sw::GetProfile()
{
	char newword[100];
	if(fl) GetPrivateProfileString(key, name, "TRUE", newword, 100, initfile);
	else GetPrivateProfileString(key, name, "FALSE", newword, 100, initfile);
	if(strcmp(newword,"TRUE")==0) fl =TRUE;
	else fl =FALSE;
	return fl;
};



// switch string

class swstr : public sw
{
	char str[MAX_PATH];
public:
	swstr(){str[0]=0;};
	BOOL loadstr(char *nam, BOOL f=FALSE) 
	{
		setName(nam); setFlag(f);
		return GetProfileStr();
	};
	BOOL loadstr(char *nam, char *deflt, BOOL f=FALSE) 
	{
		setName(nam); setFlag(f);
		if( ! GetProfileStr() ) setStr(deflt);
		return TRUE;
	};
	BOOL GetProfileStr();
	void saveStr(char*c);
	void saveStr();
	void setStr(char* s) {strcpy(str, s);};
	char *getStr(){return str;};
};

void swstr::saveStr(char *s)
{
	setStr(s);
	saveStr();
};

void swstr::saveStr()
{
	WritePrivateProfileString(getKey(), getName(), str, getInitfile());
};

BOOL swstr::GetProfileStr()
{
	char buf[100];
	GetPrivateProfileString(getKey(), getName(), "", buf, 100, getInitfile());
	if(strlen(buf)==0) 
	{
		//setStr(str);
		setFlag(FALSE);
	}
	else 
	{
		setFlag(TRUE);
		strcpy(str, buf);
	}
	return flag();
};




swstr spipathStr;
swstr memoStr;
swstr memopathStr;
swstr picExtStr;
swstr fenrirStr;

sw autoeditSw;
sw editSw;
sw logSw;
sw wideSw;
sw paintSw;
sw columnheadSw;
sw maskSw;
sw mouseSw;
sw menuSw;
sw logDlgSw;
sw spipathSw;
sw clickpicSw;
sw mousegestureSw;

struct directory
{
	int num;
	char dir[MAX_PATH];
} stockdir;

int seed;
int sessionNum;

char *getFenrir()
{
	return fenrirStr.getStr();
}


BOOL ishost(char *host)
{
	BOOL flag=FALSE;
	for (int i=0 ;i<sessionNum; i++)
	{
		if(strcmp(host,namelist[i])==0) 
		{
			flag=TRUE;
			break;
		}
	}
	return flag;
}

// ----------------------------------
// ȂtH_`FbNċL^

void savedirlocal(char *dir)
{
	BOOL flag=FALSE;
	ifstream in(localdirfile);
	while(!in.eof())
	{
		in.getline(buffer,MAX_PATH);
		if(in.gcount()==0) break;
		if(strcmp(dir,buffer)==0) 
		{
			flag=TRUE;
			break;
		}
	}
	in.close();
	if(flag==FALSE)
	{
		ofstream ldir(localdirfile,ios::ate);
		ldir<<dir<<endl;
	}
}

void loaddirlocal(char *dir)
{
	ifstream in(localdirfile);
	stockdir.num++;
	int n=stockdir.num;
	while(1)
	{
		in.getline(buffer,MAX_PATH);//getline Iq͎菜
		if(in.gcount()==0) break;
		n--;
		if(n<0) break;
	}
	if(n>=0)
	{
		stockdir.num=0;
	}
	else strcpy(dir,buffer);
}

void initlog(ofstream &log)
{
	SYSTEMTIME st;
	char jikan[16];
	char form[]="%04d/%02d/%02d";

	GetLocalTime(&st);
	wsprintf(
		jikan,
		form,
	
		st.wYear,
		st.wMonth,
		st.wDay
	);
	log.open(logdirfile,ios::ate);
	if(logflag) log<<endl<<jikan<<endl;
}


void openinit()
{
	ShellExecute(NULL, "open",editor,initdirfile, NULL, SW_SHOW);
}

void openkeyfile()
{
	ShellExecute(NULL, "open",editor,keytxt, cdir, SW_SHOW);
}

void openinitdir()
{
	ShellExecute(NULL, "open","explorer",cdir, NULL, SW_SHOW);
}

void initsessionnum()
{
	sessionNum=0;
}

int getsessionNum()
{
	return sessionNum;
}

void setseed(char *s)
{
	for(int i= 0; i<5;i++)
	{
		seed += ((unsigned char*)s)[i];
	}
	seed =seed/ 5 +1;
}


//JgfBNg

void getini_cu()
{
	GetCurrentDirectory(MAX_PATH,cdir);
	wsprintf(initdirfile,"%s\\%s",cdir,initfile);
	wsprintf(listdirfile,"%s\\%s",cdir,listfile);
	wsprintf(logdirfile,"%s\\%s",cdir,logfile);
	wsprintf(localdirfile,"%s\\%s",cdir,ldirfile);
	wsprintf(autodirfile,"%s\\%s",cdir,autofile);
	wsprintf(hisldirfile,"%s\\%s",cdir,hislfile);
	wsprintf(hisrdirfile,"%s\\%s",cdir,hisrfile);
	wsprintf(keydirfile,"%s\\%s",cdir,keyfile);
}

// NtH_

char *getCdir()
{
	return cdir;
}


// spîtH_, 
// spi path=...
// default͋NtH_

char *getSpiDir()
{
	char *p =cdir;
	if( spiPath ) p =spipathStr.getStr();
	return p;
}


void setSpiPath(char *file)
{
	*strrchr(file,'\\')=0;
	SetCurrentDirectory( file);
	GetCurrentDirectory( MAX_PATH, spipathStr.getStr());
	spipathStr.saveStr();
	Mes("Suzie Plug-in ̃pXɐݒ肵܂");
}


void savePicExts(char *s)
{
	WritePrivateProfileString(keywindow, "pic ext", s, initdirfile);
}

// }EXWFX`Ŏg镶

char mgStr[]="DRLUmMHh";

BOOL mgStrCheck(char *str)
{
	for(int i=0; i<strlen(str); i++)
	{
		if(strchr(mgStr, str[i])==NULL) return FALSE;
	}
	return TRUE;
}

BOOL setMouseGesture(char *id, char *str)
{
	//char s[10];
	//sprintf(s, "%d",id);
	if(!mgStrCheck(str)) return FALSE;
	return WritePrivateProfileString(keymouseg, str, id, initdirfile);
}

void setPicExts(char *s)
{
	strcpy(picExts, s);
}

char *getPicExts()
{
	return picExts;
}


// aaa;bbb;ccc ddd;eee ǉ
void addPicExts(char *s)
{
	strcat(picExts, ";");
	strcat(picExts, s);
}


int gethostnum()
{
	char key[4]="&\0\0";
	char buffer[MAX_PATH];
	ifstream in(listdirfile);
	int ans=1;
	do
	{
		in>>buffer;
		if(buffer[0]==0 || in.eof()) break;
		strncpy(namelist[ans-1],buffer,MAX_NAME);
		if(ans<10) key[1]='0'+ans;
		else if(ans<=35) key[1]='a'+ans-10;
		else key[1]='-';
		wsprintf(buffer,"%s. %s",key,namelist[ans-1]);
		AppendMenu(hSessionMenu,MF_STRING,sessionIDBASE+ans-1,buffer);
		ans++;
	}
	while (1);
	return ans-1;
}

void savehostlist()
{
	ofstream ou(listdirfile);
	for(int i=0; i<namenummax ;i++)
	{
		if (namelist[i][0]!=0) ou<<namelist[i]<<endl;
	}
}

void setlistbox(HWND &hdlg,UINT IDC)
{
	for(int i=0; i<sessionNum && i<namenummax ; i++)
	{
		SendDlgItemMessage(hdlg,IDC,LB_ADDSTRING,0,(LPARAM)namelist[i]);
	}
}




void getprofilepos( WINPOS *lpwinpos )
{
	lpwinpos->x = GetPrivateProfileInt(keywindow, "x",0,initdirfile);
	lpwinpos->y = GetPrivateProfileInt(keywindow, "y",0,initdirfile);
	lpwinpos->wx = GetPrivateProfileInt(keywindow, "wx",0,initdirfile);
	lpwinpos->wy = GetPrivateProfileInt(keywindow, "wy",0,initdirfile);
}

void SetSendTo()
{
	char *p=getenv("userprofile");
	if( p!=NULL ) 
	{
		wsprintf(sendtoPath, "%s\\SendTo", getenv("userprofile") );
	}
	else
	{
		wsprintf(sendtoPath, "%s", sendtoPath_0 );
	}
}


void getprofiledir()
{
	int i;
	i=0;
	bothdirnum=0;
	while(1)
	{
		i++;
		wsprintf(buffer,"%d name",i);
		GetPrivateProfileString(keydirboth, buffer, "", buffer, MAX_PATH, initdirfile);
		if(strcmp(buffer,"")==0) break;
		AppendMenu(hBothMenu,MF_STRING,bothdirIDBASE+i-1,buffer);
		bothdirnum++;
	}
	i=0;
	localdirnum=0;
	while(1)
	{
		i++;
		wsprintf(buffer,"%d",i);
		GetPrivateProfileString(keydirlocal, buffer, "", buffer, MAX_PATH, initdirfile);
		if(strcmp(buffer,"")==0) break;
		AppendMenu(hLeftMenu,MF_STRING,localdirIDBASE+i-1,buffer);
		localdirnum++;
	}
	i=0;
	remotedirnum=0;
	while(1)
	{
		i++;
		wsprintf(buffer,"%d",i);
		GetPrivateProfileString(keydirremote, buffer, "", buffer, MAX_PATH, initdirfile);
		if(strlen(buffer)==0) break;
		AppendMenu(hRemoteMenu,MF_STRING,remotedirIDBASE+i-1,buffer);
		remotedirnum++;
	}
	i=0;
	findmenunum=0;
	while(1)
	{
		i++;
		wsprintf(buffer,"%d",i);
		GetPrivateProfileString(keyfilter, buffer, "", buffer, MAX_PATH, initdirfile);
		if(strlen(buffer)==0) break;
		AppendMenu(hFindMenu,MF_STRING,findIDBASE+i-1,buffer);
		findmenunum++;
	}
	i=0;
	sendmenunum=0;
	SetSendTo();
	int ans =getnextfile(sendtoPath, "*", buffer, 0);

	while(1)
	{
		if(strlen(buffer)==0) break;
		if(ans == _FILE )  //folder
		{
			i++;
			AppendMenu(hSendtoMenu,MF_STRING,sendIDBASE+i-1,buffer);
			sendmenunum++;
		}
		ans =getnextfile(sendtoPath, "*", buffer, 1);
		if(ans<0) break;
	}
}

char *loadlastdir(int i)
{
	static char buff[MAX_INFO];
	wsprintf(buffer,"%d",i);
	if(i==1) GetPrivateProfileString(keystart, buffer, cdir, buff, MAX_INFO, initdirfile);
	else GetPrivateProfileString(keystart, buffer, "c:\\", buff, MAX_INFO, initdirfile);
	return buff;
}

// VfBNgۑ

void saveprofiledir(char *key, int *num, char *dir)
{
	BOOL flag=TRUE;
	char buff[MAX_PATH];
	if(dir[0]=='\\') return;
	//if(strcmp(dir,".")==0) return;

	int i=0;
	while(1)
	{
		i++;
		wsprintf(buff,"%d",i);
		GetPrivateProfileString(key, buff, "", buffer, MAX_PATH, initdirfile);
		if(strcmp(buffer,dir)==0 )
		{
			flag=FALSE;
			break;
		}
		if( strlen(buffer)==0 )
		{
			break;
		}
	}
	if (flag==FALSE ) return;
	(*num)++;
	wsprintf(buff,"%d",*num);
	WritePrivateProfileString(key, buff, dir, initdirfile);
}

void saveremotedir(char *dir)
{
	saveprofiledir(keydirremote,&remotedirnum,dir);
}
void savelocaldir(int tab, char *dir)
{
	if(tab == 1) saveprofiledir(keydirlocal,&localdirnum,dir);
	else saveremotedir(dir);
}


static int his[2];
#define HISMAX 100

void hisInit()
{
	GetPrivateProfileInt(keyhis, "now", his[tab_l-1], hisldirfile);
	GetPrivateProfileInt(keyhis, "now", his[tab_r-1], hisrdirfile);
	GetPrivateProfileString(keyhis, "now", "",buffer, MAX_PATH,hisldirfile);
	sscanf(buffer ,"%d" ,&his[tab_l-1]);
	GetPrivateProfileString(keyhis, "now", "",buffer, MAX_PATH,hisrdirfile);
	sscanf(buffer ,"%d" ,&his[tab_r-1]);
	initflag=TRUE;
}

void hisreset()
{
	for(int i=0;i<2;i++) his[i]=1;
}

int readhispos(int tab)
{
	char *file;
	int no=0;
	file = (tab==tab_r) ? hisrdirfile : hisldirfile;
	return GetPrivateProfileInt(keyhis, "now", no, file);
}

int gethismax(int tab)
{
	return readhispos(tab);
}

void writehispos(int tab, char *file)
{
	wsprintf(buffer,"%d",his[tab-1]);
	WritePrivateProfileString(keyhis, "now", buffer, file);
}

// ۑAOƓłȂ.
// ۑƂhis[]͎wĂ

void savehisdir(int tab, char *dir)
{
	if(!initflag) return;
	if(tab<1 || tab>2) tab=1;
	if(tab ==tab_l) 
	{
		wsprintf(buffer,"%d",his[tab-1]-1);
		GetPrivateProfileString(keyhis, buffer, "", buffer, MAX_PATH, hisldirfile);
		if(strcmp(dir,buffer)==0) return;
		wsprintf(buffer,"%d",his[tab-1]);
		WritePrivateProfileString(keyhis, buffer, dir, hisldirfile);
		writehispos(tab, hisldirfile);
	}
	if(tab ==tab_r) 
	{
		wsprintf(buffer,"%d",his[tab-1]-1);
		GetPrivateProfileString(keyhis, buffer, "", buffer, MAX_PATH, hisrdirfile);
		if(strcmp(dir,buffer)==0) return;
		wsprintf(buffer,"%d",his[tab-1]);
		WritePrivateProfileString(keyhis, buffer, dir, hisrdirfile);
		writehispos(tab, hisrdirfile);
	}
	his[tab-1]++;
	if(his[tab-1]>100) his[tab-1]=1;
}

char *loadhisdir(int tab, char *dir, int pos)
{
	if(tab<1 || tab>2) tab=1;
	int po =his[tab-1]+pos-1;
	if(po>HISMAX) his[tab-1] =1;
	if(po<0) his[tab-1] =1;
	else his[tab-1]=po;
	wsprintf(buffer,"%d",his[tab-1]);
	if(tab ==tab_l) 
	{
		GetPrivateProfileString(keyhis, buffer, "", buffer, MAX_PATH, hisldirfile);
		//if(pos<0) writehispos(tab, hisldirfile);
	}
	if(tab ==tab_r) 
	{
		GetPrivateProfileString(keyhis, buffer, "", buffer, MAX_PATH, hisrdirfile);
		//if(pos<0) writehispos(tab, hisrdirfile);
	}
	if(strlen(buffer)>0) wsprintf(dir,"%s",buffer);
	his[tab-1]++;
	return dir;
}

int getbothnum()
{
	char buff[MAX_PATH];
	int i =0;
	while(1)
	{
		i++;
		wsprintf(buff,"%d name",i);
		GetPrivateProfileString(keydirboth, buff, "", buffer, MAX_PATH, initdirfile);
		if( strlen(buffer)==0 )
		{
			break;
		}

	}
	return i-1;
}

void loadbothdir(int num, char *ldir, char *rdir)
{
	BOOL flag=TRUE;
	char buff[MAX_PATH];

	wsprintf(buff,"%d right", num);
	GetPrivateProfileString(keydirboth, buff, "", rdir, MAX_PATH, initdirfile);
	wsprintf(buff,"%d left", num);
	GetPrivateProfileString(keydirboth, buff, "", ldir, MAX_PATH, initdirfile);
	
	char *p = new char[MAX_PATH];
	int tab=0;
	while(1)
	{
		wsprintf(buff,"%d tab%d", num, tab);
		GetPrivateProfileString(keydirboth, buff, "", p, MAX_PATH , initdirfile);
		if(strlen(p)==0) break;
		AddTab(hTab, p);
		tab++;
	}
	delete p;
}

void loadhomebothdir(char *ldir, char *rdir)
{
	char buff[MAX_PATH];

	wsprintf(buff,"%s right", "home");
	GetPrivateProfileString(keydirboth, buff, "", buff, MAX_PATH, initdirfile);
	if(strlen(buff)==0) return;

	wsprintf(buff,"%s right", "home");
	GetPrivateProfileString(keydirboth, buff, "", rdir, MAX_PATH, initdirfile);
	wsprintf(buff,"%s left", "home");
	GetPrivateProfileString(keydirboth, buff, "", ldir, MAX_PATH, initdirfile);
}

void savehomebothdir(char *ldir, char *rdir)
{
	
	BOOL flag=TRUE;
	char buff[MAX_PATH];

	wsprintf(buff,"%s right", "home");
	WritePrivateProfileString(keydirboth, buff, rdir, initdirfile);
	wsprintf(buff,"%s left", "home");
	WritePrivateProfileString(keydirboth, buff, ldir, initdirfile);
}

void savebothdir(char *name, char *ldir, char *rdir)
{
	
	BOOL flag=TRUE;
	char buff[MAX_PATH];

	if(strlen(name)==0) name=ldir;
	int i=0;
	i =getbothnum()+1;
	wsprintf(buff,"%d name", i);
	WritePrivateProfileString(keydirboth, buff, name, initdirfile);
	wsprintf(buff,"%d right", i);
	WritePrivateProfileString(keydirboth, buff, rdir, initdirfile);
	wsprintf(buff,"%d left", i);
	WritePrivateProfileString(keydirboth, buff, ldir, initdirfile);

	for(int tab=0;tab<GetItemCount(hTab); tab++)
	{
		wsprintf(buff,"%d tab%d", i, tab);
		WritePrivateProfileString(keydirboth, buff, GetTabPath(tab), initdirfile);
	}
}

// O̎Abv[ht@CƈႤꍇ
// sAbv[ht@C@shift āAǉ

void AddAutofile(char *file)
{
	char buff[MAX_PATH+1]="";
	char buffer[10];
	int i=autofilesavemax;
	
	wsprintf(buffer,"%d",1);
	GetPrivateProfileString("autofile", buffer, "", buff, MAX_PATH, autodirfile);
	if( strcmp(file,buff)==0 ) return;

	while(i>0)
	{
		wsprintf(buffer,"%d",i);
		GetPrivateProfileString("autofile", buffer, "", buff, MAX_PATH, autodirfile);
		if (strlen(buff)==0) break;
		wsprintf(buffer,"%d",i+1);
		WritePrivateProfileString("autofile", buffer, buff, autodirfile);
		i--;
	}
	wsprintf(buff,"%d",1);
	WritePrivateProfileString("autofile", buff, file, autodirfile);
}

BOOL SearchProfileString(char *key, char * str, char *file )
{
	int num =0;
	char buff[MAX_FILTER];
	char buffer[10];
	
	while(1)
	{
		num++;
		wsprintf(buffer,"%d",num);
		if( GetPrivateProfileString(key, buffer, "", buff, MAX_FILTER, file) ==0) break;
		if(strcmp(buff, str)==0) return TRUE;
	}
	return FALSE;
}

int GetProfileNum(char *key, char *file)
{
	int num =0;
	char buff[MAX_PATH+1]="";
	char buffer[10];
	
	while(1)
	{
		num++;
		wsprintf(buffer,"%d",num);
		GetPrivateProfileString(key, buffer, "", buff, MAX_PATH, file);
		if(buff[0]==0) break;
	}
	return num-1;
}


void GetAutoFile(int num, char *file)
{
	char buff[MAX_PATH+1]="";
	char buffer[10];
	
	wsprintf(buffer,"%d",num);
	GetPrivateProfileString("autofile", buffer, "", buff, MAX_PATH, autodirfile);
	strncpy(file,buff,MAX_PATH);
}

// }EXWFX`@@menu id 
// DUD > 40000

WORD mgTrans(char *key)
{
	if(key ==NULL) return 0;
	return GetPrivateProfileInt("mouseTrans", key, 0, initdirfile);
}


// 40000 > DUD

char * mgTransRev(char *id)
{
	static char key[1000];
	key[0]=0;
	char *p;
	ifstream in(initdirfile, ios::nocreate);
	while(in)
	{
		if(in.eof()) break;
		in.getline(buffer,BUFFER_LEN);
		if(strstr(buffer,"[mouseTrans]")==NULL) continue;
		while(1)
		{
			if(in.eof()) break;
			in.getline(buffer,BUFFER_LEN);
			p =buffer;
			if(strchr(buffer,'[')!=NULL) break;
			p =strchr(buffer,'=');
			if(p==NULL) continue;
			*p =0;
			p++;
			if(strcmp(p,id)==0) 
			{
				if(strlen(key)>0) strcat(key,",");
				strcat(key,buffer);
			}
		}
	}

	return key;
}


#include "mouseg.h"

int menuMouse::init(HMENU hMenu, HMENU hMenu2, HMENU hMenu3)
{
	menu[0] =hMenu;
	menu[1] =hMenu2;
	menu[2] =hMenu3;
	num =::PrMenuList(hMenu,0);
	return num;
};

WORD getkeybyId(UINT id)
{
	//return 0;
	WORD ans=0;
	WORD i;
	for(ans =8000; ans>0; ans--) {
		i=GetListKeyCmd( 0,ans);
		if(id ==i) break;
	}
	return ans;
}

int menuMouse::addlist(HWND list)
{
	int num=0;
	for(int m =0;m<3;m++)
	{
		for(WORD i=0;i<GetMenuItemCount(menu[m]);i++)
		{
			HMENU smenu=GetSubMenu(menu[m],i);
			for(WORD i=0;i<GetMenuItemCount(smenu);i++)
			{
				UINT id=GetMenuItemID(smenu,i);
				if(id>= MENU_MOUSEGESTURE_Len_MAX) continue;
				WORD ky =getkeybyId(id);
				GetMenuString(smenu, i, buffer, MAX_PATH,MF_BYPOSITION);
				if(strlen(buffer)>0) 
				{
					AddListItem( list, buffer, num, id, ky);
					//num++;
				}
			}
		}
	}
	return num;
};

int menuMouse::getNum()
{
	return num;
};

int menuMouse::PrintList(HMENU hMenu)
{
	num =::PrMenuList(hMenu,1); 
	return num;
};

menuMouse menuMg;

// menuꗗt@Cɏo, imode>0 Ȃ珑oj

int PrMenuList(HMENU hMenu, int mode)
{
	int num=0;
	ofstream ou;
	if(mode>0)
	{
		ou.open("menu.txt");
		ou<<"menu list:"<<endl<<endl;
	}
	for(WORD i=0;i<GetMenuItemCount(hMenu);i++)
	{
		HMENU smenu=GetSubMenu(hMenu,i);
		for(WORD i=0;i<GetMenuItemCount(smenu);i++)
		{
			UINT id=GetMenuItemID(smenu,i);
			if(id>= MENU_MOUSEGESTURE_Len_MAX) continue;
			GetMenuString(smenu, i, buffer, MAX_PATH,MF_BYPOSITION);
			if(strlen(buffer)>0) 
			{
				if(mode>0) ou<<buffer<<","<<id<<endl;
				num++;
			}
		}
	}
	return num;
}

void initkey()
{
	keytransF =exist(keydirfile);
	if( !keytransF) return;
	int c=0;
	DWORD i;
	for( i=0; i<8000 ; i++ ) keydic[i]=i;
	ifstream in(keydirfile);
	while(1)
	{
		if(in.eof()) break;
		in.getline(buffer,BUFFER_LEN);
		if(strchr(buffer,'=')!=NULL)
		{
			*strchr(buffer,'=') =0;
			sscanf(buffer,"%d",&i);
			if(i>8000) continue;
			GetPrivateProfileString(keykey, buffer, "", buffer, MAX_PATH,keydirfile);
			if(strlen(buffer)>0) sscanf(buffer,"%d",&keydic[i]);
			if(keydic[i]==0 || keydic[i]>8000) keydic[i]=i;
		}
	}
}

// vbmp3.dll ɂ鏈@-----------------------


void mp3stopMain()
{
	stopMp3();
	freeMp3();
	mciStop();
	mciPlaying =FALSE;
	setstatus(".");
}


// load error Ȃ@-1
int mp3playMain(char *file,char *path)
{
	static char lastfile[MAX_PATH];
	/* ƍĐŃG[
	static char nowfile[MAX_PATH];
	GetFullName(nowfile, file, path, MAX_PATH);
	if(playing) 
	{
		if(strcmp(nowfile,lastfile)!=0 || isMp3(file) || isWav(file))
		{
			stopMp3();
			freeMp3();
			playing =FALSE;
		}
	}
	*/
	GetFullName(lastfile, file, path, MAX_PATH);
	int stat=MciStatus();
	if(mciPlaying && stat==mci_stopped) 
	{
		mp3stopMain();
		vEnd();
		setstatus("play end..");
		mciPlaying=FALSE;
	}
	if(mciPlaying) 
	{
		mp3stopMain();
		vEnd();
		setstatus("play end");
		mciPlaying=FALSE;
		return 0;
	}
	if(!mciPlaying) 
	{
		if(loadvbmp3())
		{
			mciPlaying=TRUE;
			setstatus("play start");
			if( !playMp3(lastfile)) mciPlaying=FALSE;
			/*
			if(Mes("play")==IDOK) ;
			mp3stop();*/
		}
		else 
		{
			mciPlaying=FALSE;
			return -1;
		}
	}
	//if(playing) strcpy(lastfile,file);
	return 0;
}


typedef struct InputInfo{
    char szTrackName[128]; //    Ȗ
    char szArtistName[128]; //   èĖ
    long channels; //       ِ
    long bitRate; //     ޯڰ(kbit/s)
    long samplingRate; //   ڰ(Hz)
    long totalSec; //    t(s)
} InputInfo;

typedef BOOL (*mopen)(char* ,InputInfo *);
typedef BOOL (*mbool)();
typedef long (*mstate)(long);
mopen vbmp3_open;
mbool vbmp3_close;
mbool vbmp3_stop;
mbool vbmp3_play;
mbool vbmp3_init;
mbool vbmp3_free;
mstate vbmp3_getState;
HINSTANCE hLibm =NULL;


BOOL checkFnc()
{
	return ((hLibm !=NULL) & (vbmp3_getState != NULL) &(vbmp3_init != NULL) &(vbmp3_open != NULL) &(vbmp3_close != NULL) &(vbmp3_stop != NULL) &(vbmp3_play != NULL));
}

void checkFncState()
{
	if(checkFnc()) 
	{
		Mes("vbmp3 fnc ready.");
		//freeMp3();
	}
	else Mes("vbmp3 fnc bad.");

}


BOOL loadvbmp3()
{
	if( checkFnc()) {
		stopMp3();
		freeMp3();
		return FALSE;
	}
	BOOL ret=TRUE;
	hLibm = LoadLibrary( "vbmp3.DLL");
	if(hLibm !=NULL) 
	{
		
        vbmp3_open  = (mopen) GetProcAddress(hLibm, "vbmp3_open");
        vbmp3_close  = (mbool) GetProcAddress(hLibm, "vbmp3_close");
        vbmp3_stop  = (mbool) GetProcAddress(hLibm, "vbmp3_stop");
        vbmp3_play  = (mbool) GetProcAddress(hLibm, "vbmp3_play");
        vbmp3_init  = (mbool) GetProcAddress(hLibm, "vbmp3_init");
        vbmp3_free  = (mbool) GetProcAddress(hLibm, "vbmp3_free");
        vbmp3_getState  = (mstate) GetProcAddress(hLibm, "vbmp3_getState");
		if( checkFnc() ) ;
        else
		{
			ret=FALSE;
			Mes("vbmp3 error");
			freeMp3();
			goto end;
		}
		//long sec;
		//char buf[10];
        if(!(*vbmp3_init)()) 
		{
			Mes("mp3 init error");
			ret=FALSE;
		}
	}
	else
	{
		//Mes("library not found");
		ret=FALSE;
	}
	return ret;
	
end:
	return ret;
}

BOOL playMp3(char*file)
{
	BOOL ans=TRUE;
	if( !checkFnc()) return FALSE;
	InputInfo info;
	(*vbmp3_close)() ;
	if(!(*vbmp3_open)(file, &info)) 
	{
		Mes("mp3 open error");
		ans =FALSE;
	}
	else
	{
		//Mes(info.totalSec);
	}
    if(!(*vbmp3_play)()) ans =FALSE;//Mes("play bad");
	return ans;
}

void stopMp3()//
{
	if( !checkFnc()) return;

	if((*vbmp3_stop)()) ;//Mes("mp3stop ok");
	if((*vbmp3_close)()) ;//Mes("mp3close ok");
	if((*vbmp3_free)()) ;//Mes("mp3free ok");;
	//if((*vbmp3_init)()) Mes("mp3init ok");
}

void freeMp3()
{
	//Mes("libfree");
	if(hLibm!=NULL) 
	{
		if(FreeLibrary(hLibm)) ;
		else  Mes("library free error");
		hLibm=NULL;
	}
}
//---------------------------------------


void MyGetInitialData(WINPOS *lpwinpos)
{
	char newword[100];
	getini_cu();
	hisInit();
	initkey();

	dontoverwrite =FALSE;//㏑
	getprofilepos(lpwinpos);
	getprofiledir();
	GetPrivateProfileString(keywindow, "editor", "notepad", editor, MAX_PATH, initdirfile);
	wsprintf(defCmdstr, "%s \%s", editor);
//	GetPrivateProfileString(keywindow, "memo", "memo.txt", memofile, MAX_PATH, initdirfile);
//	GetPrivateProfileString(keywindow, "memoPath", "", memopath, MAX_PATH, initdirfile);
	GetPrivateProfileString(keywindow, "special ext", extDefSpColor, newword, 100, initdirfile);
	setExtPaint(newword);

	mouseGTransF =TRUE;
	mciPlaying =FALSE;
	mp3Playing =FALSE;
	KeyModified =FALSE;
	nanameON =TRUE;
	videoIn =FALSE;
	CurrentPicshow =FALSE;
	autoedit =autoeditSw.load( "auto edit" );
	mousegON =mousegestureSw.load( "mouse gesture" ,TRUE);
	spiPath=FALSE;
	//spiCdir =spiLoadTest("a.jpg"); // cdir@ׂ

	spiPath =spipathStr.loadstr( "spi path" );
	setPicExts("jpg");//
	if (picExtStr.loadstr( "pic ext" )) setPicExts( picExtStr.getStr() );
	editflag =editSw.load( "editflag" );
	logflag =logSw.load( "logflag" );
	paintf =paintSw.load( "paint", PAINTFLAG_DEF);
	columnhead =columnheadSw.load( "column", TRUE);
	wide =wideSw.load( "wide" );
	mousemv =mouseSw.load( "mousemv" );
	showmenu =menuSw.load( "menu" , TRUE);
	LogDialog =logDlgSw.load( "log dialog" );
	clickpic =clickpicSw.load( "click pic" );
	showpathTitle =TRUE;
	fenrirPath =fenrirStr.loadstr( "fenrir path" );
	memoStr.loadstr( "memo", "memo-.txt" );
	memopathStr.loadstr( "memopath" );
	memofile=memoStr.getStr();
	memopath=memopathStr.getStr();

	
	iconf =maskSw.load( "icon" );
	if( iconf ==FALSE ) topmask =LVIF_TEXT | LVIF_PARAM;
	else topmask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
	
	sessionNum =gethostnum();
	stockdir.num=0;

	return;
}

void GetVol(int len, char *vol)
{
    //DWORD SectorsPerCluster;
    //DWORD BytesPerSector;
    //DWORD NumberOfFreeClusters;
    //DWORD TotalNumberOfClusters;
	const int INFOBUF_SIZE=1000;
    char drives[INFOBUF_SIZE];
    GetLogicalDriveStrings(INFOBUF_SIZE, drives);   //  LȃhCüꗗ擾
    const char *ptr = drives;
	strcpy(vol,"");
    while( *ptr != '\0' ) {                         //  LȃhCucĂ
//        uint driveType = GetDriveType(ptr);
        SHFILEINFO shFileInfo;
        SHGetFileInfo(ptr, 0, &shFileInfo, sizeof(SHFILEINFO), SHGFI_DISPLAYNAME);
        strcat(vol,  ptr);
		strcat(vol, shFileInfo.szDisplayName);
		strcat(vol,"\n");
        ptr = strchr(ptr, '\0');                    //  ̃hCu
        //ASSERT(ptr);
        ptr += 1;
    }
 

}


void savelastdir(int lr, char *dir)
{
	char buffer[4];
	wsprintf(buffer,"%d",lr);
	WritePrivateProfileString(keystart, buffer, dir, initdirfile);
}

void savelastTabs()
{
	char buff[10];
	for(int tab=0;tab<GetItemCount(hTab); tab++)
	{
		wsprintf(buff,"tab%d", tab);
		WritePrivateProfileString(keystart, buff, GetTabPath(tab), initdirfile);
	}
}


void savefilter(char *str)
{
	char buffer[4];
	int num;
	if ( SearchProfileString( keyfilter, str, initdirfile ) ) return;
	num =GetProfileNum(keyfilter, initdirfile);
	wsprintf(buffer,"%d",num+1);
	WritePrivateProfileString(keyfilter, buffer, str, initdirfile);
}

void MySaveInitialData( WINPOS *lpwinpos)
{
	char buffer[MAX_INFO];
	//itoa()
	wsprintf(buffer,"%d",lpwinpos->x);
	WritePrivateProfileString(keywindow, "x", buffer, initdirfile);
	wsprintf(buffer,"%d",lpwinpos->y);
	WritePrivateProfileString(keywindow, "y", buffer, initdirfile);
	wsprintf(buffer,"%d",lpwinpos->wx);
	WritePrivateProfileString(keywindow, "wx", buffer, initdirfile);
	wsprintf(buffer,"%d",lpwinpos->wy);
	WritePrivateProfileString(keywindow, "wy", buffer, initdirfile);
	mousegestureSw.save(mousegON);
	memoStr.saveStr(memofile);
	memopathStr.saveStr(memopath);
	return;
}


WORD transkey(WORD key)
{
	if(key>=8000 || !keytransF) return key;
	return keydic[key];
}

#define LineLen 2000
#define EnvLen 100

// ini ϐĂяo

BOOL getmyenv(char *env, char *ans)
{
	GetPrivateProfileString(keyenv, env, "", ans, EnvLen, initdirfile);
	return ( strlen(ans) >0 );
}



BOOL myTransEnv(char *env, char *ans)
{
	BOOL f =FALSE;
	if( getmyenv(env, ans) ) 
	{
		f =TRUE;
	}
	else if( getenv(env) ==NULL) {}
	else 
	{
		wsprintf(ans,"%s", getenv(env));
		f =TRUE;
	}
	return f;
}

//ϐ̕ϊ
char *TransEnv(char *src, char *dest)
{
	//return src;
	wsprintf(dest,"");
	char buff[LineLen];
	char env[EnvLen];
	char envTrans[EnvLen];
	if(strlen(src) >= LineLen || strchr(src, '%') ==NULL) 
	{
		wsprintf(dest, "%s", src);
		return src;
	}
	wsprintf(buff, "%s", src);

	char *p=buff;
	int len =strlen(buff);
	while(1)
	{
		if(len<=0) break; 
		while( *p!=0 && *p!='%') {*dest=*p; dest++; p++; }
		if(*p==0) 
		{
			*dest=0;
			break;
		}
		if(*p=='%' && strlen(p)>0)
		{
			strncpy(env,p+1,EnvLen);
			char *pp=strchr(env,'%');
			if(pp!=NULL) *pp=0;
			else 
			{
				*dest ='%';
				dest++;
				p++;
				len--;
				continue;
			}
			if ( ! myTransEnv(env, envTrans)) //
			{
				p++;
				continue;
			}
			int lenenv =strlen(envTrans);
			strcpy(dest, envTrans);
			dest +=lenenv;
			p =strchr(p+1, '%');
			len -= strlen(env) +2;
		}
		p++;
		len--;
	}
	return dest;

}


// fenrir instant.inii邢͓`̂́j płΎg
// pX̓tl[Őݒt@C
// fenrir path=....


char *TransExCmd(char *cmd, char *file, char *path)
{
	//Mes("transEx");
	if (!fenrirPath) return cmd;

	swstr fnr;
	fnr.init(fenrirStr.getStr(),"InstantCommand");
	if( fnr.loadstr(cmd, TRUE) )
		wsprintf(cmd, fnr.getStr());
	
	return cmd;
}

// R}hC̒$PȂǂ̏

char *TransCmd(char *cmd, char *file, char *path)
{
	TransExCmd(cmd, file, path);
	char *cmdstr =cmd;
	char *buf =buffer2;
	char buff[LineLen];

	TransEnv(cmd, buff);
	wsprintf(cmd, "%s", buff);
	//M2("env",buff);

	while(1)
	{
		if(*cmdstr!='$') *buf++ = *cmdstr++ ;
		else
		{
			cmdstr++;
			if ( *cmdstr == 'F' ) 
			{
				strcpy( buf, file);
				buf += strlen(file);
				cmdstr++;
			}
			else if ( *cmdstr == 'P' ) 
			{
				strcpy( buf, path);
				buf += strlen(path);
				cmdstr++;
			}
			else if ( *cmdstr == 'O' ) 
			{
				strcpy( buf, GetNXPath());
				buf += strlen(GetNXPath());
				cmdstr++;
			}
			else if ( *cmdstr == 'L' ) 
			{
				strcpy( buf, GetLPath());
				buf += strlen(GetLPath());
				cmdstr++;
			}
			else if ( *cmdstr == 'R' ) 
			{
				strcpy( buf, GetRPath());
				buf += strlen(GetRPath());
				cmdstr++;
			}
		}
		if(*cmdstr == 0 ) break;
	}
	*buf = 0;
	strcpy(cmd, buffer2);
	return cmd;
}

char *GetMyCmdStr( int mode )
{
	char buff[10];
	wsprintf(buff,"%d",mode);
	GetPrivateProfileString(keycommand, buff, defCmdstr, cmdstr, MAX_PATH, initdirfile);
	return cmdstr;
}

// o^R}hŎs

char *cmd(char *file, char *path, int mode)
{
	strcpy(cmdline,TransCmd(GetMyCmdStr(mode), file, path));
	wsprintf(buffer, cmdline, quote( GetFullName(buffer2, file, path, MAX_PATH) ) );
	return buffer;
}

// ڎwR}hŎs
char *cmdDirect(char *file, char *path, char *com)
{
	strcpy(cmdline,TransCmd(com, file, path));

	wsprintf(buffer, cmdline, quote( GetFullName(buffer2, file, path, MAX_PATH) ) );
	return buffer;
}

// R}hԍŌĂяos
char *cmdByNum(char *file, char *path, char *num)
{
	GetPrivateProfileString(keycommand, num, defCmdstr, cmdstr, MAX_PATH, initdirfile);
	return cmdDirect(file, path, cmdstr);
}


// ""̓`FbNA''̓`FbNĂȂ
// 󔒈ꕶŋ؂

BOOL getfirst( char *cmd, char *buf,char *buf2)
{
	char *p;
	if(strlen(cmd)<3) return FALSE;
	strcpy(buf,cmd);
	p=buf;
	while(1)
	{
		if(*p==0) return FALSE;
		if(*p!='\"' && *p!=' ') 
		{
			p++;
			continue;
		}
		if(*p=='\"') //"..."Ƃ΂
		{
			p=strchr(p+1,'\"');
			if(p==NULL) return FALSE;
			p++;
			continue;
		}
		// ' 'Ő؂
		if(strlen(p)==1) return FALSE;
		strcpy(buf2, p+1);
		*p=0;
		return TRUE;
	}
}

BOOL splitcmd( char *cmd, char *buf, char *buf2)
{
	strcpy(buf,cmd);
	if (strchr(cmd,' ')==NULL) return FALSE;
	return getfirst(cmd,buf,buf2);
}

void myexec( char *cmd)
{
	//system(cmd);
	char buffer[BUFFER_LEN];
	char buffer2[BUFFER_LEN];
	strcpy(buffer,"");
	strcpy(buffer2,"");
	setstatus("cmd ", cmd);
	if( splitcmd(cmd, buffer,buffer2) )
	{
		ShellExecute(NULL, "open", buffer,buffer2, NULL, SW_SHOW);
		LogWin(cmd);
	}
	else 
	{
		ShellExecute(NULL, NULL, cmd, NULL, NULL, SW_SHOW);
	}
}


// mode =0@ȊOZbg

int getnextpath(int id, char *buf, char *written, int mode)
{
	static int lastid;//Oid(list)
	static char path[MAX_PATH];
	static char currentWritten[MAX_PATH];
	char newdir[MAX_PATH];
	static int ans=0;
	int _ERR =_FILE;

	if (mode !=0) 
	{
		ans =0;
		getnextfile(path, "*", newdir, _closeOnly);
		return 0;
	}
	if (ans ==0 || id!=lastid) 
	{
		ans =0;
		wsprintf(currentWritten,"%s",written);
		wsprintf(path,"%s", buf);
	}
	lastid =id;
	if (ans ==0 || ans == _END)
	{
		ans =getnextfile(path, "*", newdir, 0);
		if (ans==_DIR)
		{
			if( newdir[0] !='.') 
			{
				wsprintf(buf, "%s\\%s", path, newdir);
				if(strstr(buf, currentWritten) ==NULL ) ans =_ERR;
				return ans;
			}
		}
	}
	while( 1 )
	{
		ans =getnextfile(path, "*", newdir, 1);
		if( ans ==_END ) 
		{
			break;
		}
		if( ans == _DIR ) 
		{	
			if ( newdir[0] !='.' )
			{
				wsprintf(buf, "%s\\%s", path, newdir);
				if(strstr(buf, currentWritten) ==NULL ) 
				{
					ans =_ERR;
					continue;
				}
				break;
			}
			continue;
		}
		if( ans == _FILE ) 
		{
		}
	}
	return ans;
}