/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IWorkbenchPage;

public class PageListenerList {
    private ListenerList listeners = new ListenerList();

    public void addPageListener(IPageListener l) {
        this.listeners.add((Object)l);
    }

    public void firePageActivated(final IWorkbenchPage page) {
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final IPageListener l = (IPageListener)array[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.pageActivated(page);
                }
            });
            ++i;
        }
    }

    public void firePageClosed(final IWorkbenchPage page) {
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final IPageListener l = (IPageListener)array[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.pageClosed(page);
                }
            });
            ++i;
        }
    }

    public void firePageOpened(final IWorkbenchPage page) {
        Object[] listeners = this.listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IPageListener l = (IPageListener)listeners[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.pageOpened(page);
                }
            });
            ++i;
        }
    }

    public void removePageListener(IPageListener l) {
        this.listeners.remove((Object)l);
    }
}

