/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FeatureParser
extends DefaultHandler {
    private SAXParser parser;
    private FeatureEntry feature;
    private URL url;
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    public FeatureParser() {
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            System.out.println(e);
        }
        catch (SAXException e) {
            System.out.println(e);
        }
    }

    /*
     * Exception decompiling
     */
    public FeatureEntry parse(URL featureURL) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 76->79)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Utils.debug("Start Element: uri:" + uri + " local Name:" + localName + " qName:" + qName);
        if ("feature".equals(localName)) {
            this.processFeature(attributes);
            throw new SAXException("");
        }
    }

    private void processFeature(Attributes attributes) {
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        if (id == null || id.trim().equals("") || ver == null || ver.trim().equals("")) {
            System.out.println(Messages.getString("FeatureParser.IdOrVersionInvalid", new String[]{id, ver}));
        } else {
            String os = attributes.getValue("os");
            String ws = attributes.getValue("ws");
            String nl = attributes.getValue("nl");
            String arch = attributes.getValue("arch");
            if (!Utils.isValidEnvironment(os, ws, arch, nl)) {
                return;
            }
            String primary = attributes.getValue("primary");
            boolean isPrimary = "true".equals(primary);
            String application = attributes.getValue("application");
            String plugin = attributes.getValue("plugin");
            this.feature = new FeatureEntry(id, ver, plugin, "", isPrimary, application, null);
            if ("file".equals(this.url.getProtocol())) {
                File f = new File(this.url.getFile().replace('/', File.separatorChar));
                this.feature.setURL("features/" + f.getParentFile().getName() + "/");
            } else {
                this.feature.setURL(this.url.toExternalForm());
            }
            Utils.debug("End process DefaultFeature tag: id:" + id + " ver:" + ver + " url:" + this.feature.getURL());
        }
    }
}

