/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.OutputStream;
import jp.gr.java_conf.dangan.io.BitOutputStream;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;

public class PostLzsEncoder
implements PostLzssEncoder {
    private static final int DictionarySize = 2048;
    private static final int MaxMatch = 17;
    private static final int Threshold = 2;
    private static final int PositionBits = Bits.len(2047);
    private static final int LengthBits = Bits.len(15);
    private BitOutputStream out;
    private int position;
    private int matchLength;

    private PostLzsEncoder() {
    }

    public PostLzsEncoder(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("out");
        }
        this.out = outputStream instanceof BitOutputStream ? (BitOutputStream)outputStream : new BitOutputStream(outputStream);
        this.position = 0;
        this.matchLength = 0;
    }

    public void writeCode(int n) throws IOException {
        if (n < 256) {
            this.out.writeBit(1);
            this.out.writeBits(8, n);
            ++this.position;
        } else {
            this.out.writeBit(0);
            this.matchLength = n - 256;
        }
    }

    public void writeOffset(int n) throws IOException {
        int n2 = this.position - n - 1 - 17 & 0x7FF;
        this.position += this.matchLength + 2;
        this.out.writeBits(PositionBits, n2);
        this.out.writeBits(LengthBits, this.matchLength);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
        this.out = null;
    }

    public int getDictionarySize() {
        return 2048;
    }

    public int getMaxMatch() {
        return 17;
    }

    public int getThreshold() {
        return 2;
    }
}

