/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JApplet;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class FileLauncher
extends JApplet {
    private static final long serialVersionUID = 1L;
    private String message;
    private transient ResourceBundle resources;
    private File file;

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        Color frontColor = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, d.width, d.height);
        g.setColor(frontColor);
        g.drawString(this.message, 0, 20);
    }

    @Override
    public void init() {
        this.resources = ResourceBundle.getBundle("messages", this.getLocale());
        try {
            this.file = this.getFile();
        }
        catch (Exception e) {
            this.message = e.getLocalizedMessage();
        }
    }

    @Override
    public void start() {
        if (this.file != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (Desktop.isDesktopSupported()) {
                        int ret = JOptionPane.showConfirmDialog(FileLauncher.this.getContentPane().getParent(), FileLauncher.this.getMsg("dialog.message"), FileLauncher.this.getMsg("dialog.title"), 0, -1);
                        if (ret == 0) {
                            FileLauncher.this.launch(FileLauncher.this.file);
                        } else if (ret == 1) {
                            FileLauncher.this.message = FileLauncher.this.getMsg("msg.cancel_open_file");
                        }
                    } else {
                        FileLauncher.this.saveFile(FileLauncher.this.file);
                    }
                }
            }).start();
        }
        if (this.message == null) {
            this.message = "";
        }
    }

    private String getMsg(String key) {
        return this.resources.getString(key);
    }

    private String getMsg(String key, Object ... arguments) {
        return MessageFormat.format(this.resources.getString(key), arguments);
    }

    private File getFile() {
        String uriParam = this.getRequestParameter("uri");
        if (this.isBlank(uriParam)) {
            this.message = this.getMsg("msg.no_uri");
            return null;
        }
        File targetFile = null;
        String path = uriParam.replaceFirst("file:/+", "");
        int pos1 = path.indexOf(58);
        int pos2 = path.indexOf(47);
        targetFile = pos1 > 0 && pos2 > 0 && pos1 < pos2 ? new File(path) : new File(uriParam.replace("file:", ""));
        if (!targetFile.exists()) {
            this.message = this.getMsg("msg.not_found", targetFile.getAbsolutePath());
            return null;
        }
        this.message = this.getMsg("msg.open_file", targetFile.getAbsolutePath());
        return targetFile;
    }

    private void launch(File file) {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.open(file);
            this.message = this.getMsg("msg.opened_file", file.getAbsolutePath());
        }
        catch (Exception e) {
            this.message = this.getMsg("msg.save_file", file.getAbsolutePath());
            this.repaint();
            this.saveFile(file);
        }
    }

    private void saveFile(File file) {
        JFileChooser filechooser = new JFileChooser();
        filechooser.setSelectedFile(new File(file.getName()));
        int selected = filechooser.showSaveDialog(this.getContentPane().getParent());
        if (selected == 0) {
            File outputFile = filechooser.getSelectedFile();
            try {
                this.copyFile(file, outputFile);
                this.message = this.getMsg("msg.save_file", outputFile.getAbsolutePath());
            }
            catch (IOException e) {
                this.message = e.getLocalizedMessage();
            }
        } else if (selected == 1) {
            this.message = this.getMsg("msg.cancel_save_dialog");
        } else if (selected == -1) {
            this.message = this.getMsg("msg.error_save_file");
        }
        this.repaint();
    }

    private String getRequestParameter(String key) {
        String value = this.getParameter(key);
        if (this.isBlank(value)) {
            return null;
        }
        return value;
    }

    private boolean isBlank(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File inFile, File outFile) throws IOException {
        byte[] bytes = new byte[8192];
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(inFile));
            bos = new BufferedOutputStream(new FileOutputStream(outFile));
            int length = bis.read(bytes);
            while (length != -1) {
                if (length != 0) {
                    ((BufferedOutputStream)bos).write(bytes, 0, length);
                }
                length = bis.read(bytes);
            }
            ((BufferedOutputStream)bos).flush();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

