/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.ObjectUtils;
import org.carrot2.util.StreamUtils;
import org.carrot2.util.resource.IResource;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="class-loader-resource")
public final class ClassLoaderResource
implements IResource {
    private ClassLoader clazzLoader;
    @Attribute
    private String resource;

    ClassLoaderResource() {
        this(null);
    }

    public ClassLoaderResource(String resource) {
        this(Thread.currentThread().getContextClassLoader(), resource);
    }

    public ClassLoaderResource(ClassLoader cl, String resource) {
        this.clazzLoader = cl;
        this.resource = resource;
    }

    @Override
    public InputStream open() throws IOException {
        return StreamUtils.prefetch(this.clazzLoader.getResourceAsStream(this.resource));
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassLoaderResource) {
            return ObjectUtils.equals((Object)((ClassLoaderResource)obj).resource, (Object)this.resource) && ObjectUtils.equals((Object)((ClassLoaderResource)obj).clazzLoader, (Object)this.clazzLoader);
        }
        return false;
    }

    public int hashCode() {
        return ObjectUtils.hashCode((Object)this.clazzLoader) ^ ObjectUtils.hashCode((Object)this.resource);
    }

    public String toString() {
        return "[CLASSPATH RESOURCE: " + this.resource + "@" + this.clazzLoader.toString() + "]";
    }
}

