/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.carrot2.util.attribute.AttributeValueSet;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persist;
import org.simpleframework.xml.core.Persister;

@Root(name="attribute-sets")
public class AttributeValueSets {
    @ElementMap(name="attribute-sets", entry="attribute-set", key="id", inline=true, attribute=true, required=false)
    Map<String, AttributeValueSet> attributeValueSets = Maps.newLinkedHashMap();
    @Attribute(name="default", required=false)
    String defaultAttributeValueSetId;

    public void addAttributeValueSet(String id, AttributeValueSet attributeValueSet) {
        if (this.attributeValueSets.containsKey(id)) {
            throw new IllegalArgumentException("Attribute value set with id=" + id + " already exists");
        }
        this.attributeValueSets.put(id, attributeValueSet);
    }

    public void addAttributeValueSet(String id, AttributeValueSet attributeValueSet, String newLabel, String newDescription) {
        AttributeValueSet newAttributeValueSet = new AttributeValueSet(newLabel, newDescription, attributeValueSet.baseAttributeValueSet);
        newAttributeValueSet.overridenAttributeValues.putAll(attributeValueSet.overridenAttributeValues);
        this.addAttributeValueSet(id, newAttributeValueSet);
    }

    public Set<String> getAttributeValueSetIds() {
        return this.attributeValueSets.keySet();
    }

    public String getDefaultAttributeValueSetId() {
        return this.defaultAttributeValueSetId;
    }

    public void setDefaultAttributeValueSetId(String defaultAttributeValueSetId) {
        if (defaultAttributeValueSetId != null && !this.attributeValueSets.containsKey(defaultAttributeValueSetId)) {
            throw new IllegalArgumentException("Attribute value set with id: " + defaultAttributeValueSetId + " does not exist.");
        }
        this.defaultAttributeValueSetId = defaultAttributeValueSetId;
    }

    public AttributeValueSet getAttributeValueSet(String id) {
        return this.getAttributeValueSet(id, false);
    }

    public AttributeValueSet getAttributeValueSet(String id, boolean useDefault) {
        if (this.attributeValueSets.containsKey(id)) {
            return this.attributeValueSets.get(id);
        }
        return useDefault ? this.getDefaultAttributeValueSet() : null;
    }

    public AttributeValueSet getDefaultAttributeValueSet() {
        Iterator<AttributeValueSet> iterator;
        AttributeValueSet result = null;
        if (this.defaultAttributeValueSetId != null) {
            result = this.getAttributeValueSet(this.defaultAttributeValueSetId);
        }
        if (result == null && (iterator = this.attributeValueSets.values().iterator()).hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    public void removeAttributeValueSet(String id) {
        AttributeValueSet attributeValueSet = this.attributeValueSets.get(id);
        if (attributeValueSet == null) {
            return;
        }
        this.attributeValueSets.remove(id);
        AttributeValueSet newBaseAttributeValueSet = attributeValueSet.baseAttributeValueSet;
        for (AttributeValueSet set : this.attributeValueSets.values()) {
            set.baseAttributeValueSet = newBaseAttributeValueSet;
        }
        if (id.equals(this.defaultAttributeValueSetId)) {
            this.defaultAttributeValueSetId = null;
        }
    }

    public Set<AttributeValueSet> getAttributeValueSetsBasedOn(AttributeValueSet baseAttributeValueSet) {
        HashSet result = Sets.newHashSet();
        for (AttributeValueSet set : this.attributeValueSets.values()) {
            if (set.baseAttributeValueSet != baseAttributeValueSet) continue;
            result.add(set);
            result.addAll(this.getAttributeValueSetsBasedOn(set));
        }
        return result;
    }

    @Persist
    private void updateBaseAttributeValueSetIds() {
        block0: for (AttributeValueSet attributeValueSet : this.attributeValueSets.values()) {
            if (attributeValueSet.baseAttributeValueSet == null) continue;
            for (Map.Entry<String, AttributeValueSet> entry : this.attributeValueSets.entrySet()) {
                if (attributeValueSet.baseAttributeValueSet != entry.getValue()) continue;
                attributeValueSet.baseAttributeValueSetId = entry.getKey();
                continue block0;
            }
        }
    }

    @Commit
    private void restoreBaseAttributeValueSets() {
        for (AttributeValueSet attributeValueSet : this.attributeValueSets.values()) {
            attributeValueSet.baseAttributeValueSet = this.attributeValueSets.get(attributeValueSet.baseAttributeValueSetId);
        }
    }

    public void serialize(OutputStream stream) throws Exception {
        new Persister().write((Object)this, stream);
    }

    public static AttributeValueSets deserialize(InputStream inputStream) throws Exception {
        AttributeValueSets attributeValueSet = (AttributeValueSets)new Persister().read(AttributeValueSets.class, inputStream);
        AttributeValueSets.checkDefaultAttributeValueSetExists(attributeValueSet);
        return attributeValueSet;
    }

    private static void checkDefaultAttributeValueSetExists(AttributeValueSets attributeValueSet) {
        if (attributeValueSet.defaultAttributeValueSetId != null && !attributeValueSet.attributeValueSets.containsKey(attributeValueSet.defaultAttributeValueSetId)) {
            throw new RuntimeException("Default attribute value set not found: " + attributeValueSet.defaultAttributeValueSetId);
        }
    }

    public String toString() {
        return "AttributeValueSet [set IDs: " + Arrays.toString(this.getAttributeValueSetIds().toArray()) + "]";
    }
}

