/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.ObjectOpenHashSet;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import org.carrot2.core.Document;
import org.carrot2.text.linguistic.LanguageModel;
import org.carrot2.text.preprocessing.SparseArray;
import org.carrot2.text.util.MutableCharArray;
import org.carrot2.text.util.TabularOutput;

public final class PreprocessingContext {
    private static final String UNINITIALIZED = "[uninitialized]";
    public final String query;
    public final List<Document> documents;
    public final LanguageModel language;
    private ObjectOpenHashSet<MutableCharArray> tokenCache = ObjectOpenHashSet.newInstance();
    public final AllTokens allTokens = new AllTokens();
    public final AllFields allFields = new AllFields();
    public final AllWords allWords = new AllWords();
    public final AllStems allStems = new AllStems();
    public AllPhrases allPhrases = new AllPhrases();
    public final AllLabels allLabels = new AllLabels();
    private static final int[][] bitsCache = new int[256][];

    public PreprocessingContext(LanguageModel languageModel, List<Document> documents, String query) {
        this.query = query;
        this.documents = documents;
        this.language = languageModel;
    }

    public boolean hasWords() {
        return this.allWords.image.length > 0;
    }

    public boolean hasLabels() {
        return this.allLabels.featureIndex != null && this.allLabels.featureIndex.length > 0;
    }

    public String toString() {
        return "PreprocessingContext 0x" + Integer.toHexString(this.hashCode()) + "\n" + "== Fields:\n" + this.allFields.toString() + "== Tokens:\n" + this.allTokens.toString() + "== Words:\n" + this.allWords.toString() + "== Stems:\n" + this.allStems.toString() + "== Phrases:\n" + this.allPhrases.toString() + "== Labels:\n" + this.allLabels.toString();
    }

    public static int[] toFieldIndexes(byte b) {
        return bitsCache[b & 0xFF];
    }

    public void preprocessingFinished() {
        this.tokenCache = null;
    }

    public char[] intern(MutableCharArray chs) {
        if (this.tokenCache.contains((Object)chs)) {
            return ((MutableCharArray)this.tokenCache.lget()).getBuffer();
        }
        char[] tokenImage = new char[chs.length()];
        System.arraycopy(chs.getBuffer(), chs.getStart(), tokenImage, 0, chs.length());
        this.tokenCache.add((Object)new MutableCharArray(tokenImage));
        return tokenImage;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            PreprocessingContext.bitsCache[i] = new int[Integer.bitCount(i & 0xFF)];
            int v = 0;
            int bit = 0;
            int j = i & 0xFF;
            while (j != 0) {
                if ((j & 1) != 0) {
                    PreprocessingContext.bitsCache[i][v++] = bit;
                }
                j >>>= 1;
                ++bit;
            }
        }
    }

    public class AllLabels {
        public int[] featureIndex;
        public BitSet[] documentIndices;
        public int firstPhraseIndex;

        public String toString() {
            if (this.featureIndex == null) {
                return PreprocessingContext.UNINITIALIZED;
            }
            StringWriter sw = new StringWriter();
            TabularOutput t = new TabularOutput(sw);
            t.flushEvery(Integer.MAX_VALUE);
            t.addColumn("#");
            t.addColumn("featureIdx");
            t.addColumn("=>feature").alignLeft();
            t.addColumn("documentIdx").alignLeft();
            for (int i = 0; i < this.featureIndex.length; ++i) {
                t.rowData(i, this.featureIndex[i], this.getLabel(i), this.documentIndices != null ? this.documentIndices[i].toString().replace(" ", "") : "");
                t.nextRow();
            }
            t.flush();
            sw.append("\n");
            return t.toString();
        }

        private CharSequence getLabel(int index) {
            int wordsSize = PreprocessingContext.this.allWords.image.length;
            if (this.featureIndex[index] < wordsSize) {
                return new String(PreprocessingContext.this.allWords.image[this.featureIndex[index]]);
            }
            return PreprocessingContext.this.allPhrases.getPhrase(this.featureIndex[index] - wordsSize);
        }
    }

    public class AllPhrases {
        public int[][] wordIndices;
        public int[] tf;
        public int[][] tfByDocument;

        public String toString() {
            if (this.wordIndices == null) {
                return "";
            }
            StringWriter sw = new StringWriter();
            TabularOutput t = new TabularOutput(sw);
            t.flushEvery(Integer.MAX_VALUE);
            t.addColumn("#");
            t.addColumn("wordIndices");
            t.addColumn("=>words").alignLeft();
            t.addColumn("tf");
            t.addColumn("tfByDocument").alignLeft();
            for (int i = 0; i < this.wordIndices.length; ++i) {
                t.rowData(i, Arrays.toString(this.wordIndices[i]).replace(" ", ""), this.getPhrase(i), this.tf[i], SparseArray.sparseToString(this.tfByDocument[i]));
                t.nextRow();
            }
            t.flush();
            sw.append("\n");
            return sw.toString();
        }

        public CharSequence getPhrase(int index) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.wordIndices[index].length; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(new String(PreprocessingContext.this.allWords.image[this.wordIndices[index][i]]));
            }
            return sb;
        }

        public int size() {
            return this.wordIndices.length;
        }
    }

    public class AllStems {
        public char[][] image;
        public int[] mostFrequentOriginalWordIndex;
        public int[] tf;
        public int[][] tfByDocument;
        public byte[] fieldIndices;

        public String toString() {
            StringWriter sw = new StringWriter();
            TabularOutput t = new TabularOutput(sw);
            t.flushEvery(Integer.MAX_VALUE);
            t.addColumn("#");
            t.addColumn("stem");
            t.addColumn("mostFrqWord");
            t.addColumn("=>mostFrqWord").alignLeft();
            t.addColumn("tf");
            t.addColumn("tfByDocument").alignLeft();
            t.addColumn("fieldIndices");
            for (int i = 0; i < this.image.length; ++i) {
                t.rowData(i, this.image[i] == null ? "<null>" : new String(this.image[i]), this.mostFrequentOriginalWordIndex[i], new String(PreprocessingContext.this.allWords.image[this.mostFrequentOriginalWordIndex[i]]), this.tf[i], SparseArray.sparseToString(this.tfByDocument[i]), Arrays.toString(PreprocessingContext.toFieldIndexes(this.fieldIndices[i])).replace(" ", ""));
                t.nextRow();
            }
            t.flush();
            sw.append("\n");
            return sw.toString();
        }
    }

    public class AllWords {
        public char[][] image;
        public short[] type;
        public int[] tf;
        public int[][] tfByDocument;
        public int[] stemIndex;
        public byte[] fieldIndices;

        public String toString() {
            StringWriter sw = new StringWriter();
            TabularOutput t = new TabularOutput(sw);
            t.flushEvery(Integer.MAX_VALUE);
            t.addColumn("#");
            t.addColumn("image").alignLeft();
            t.addColumn("type");
            t.addColumn("tf");
            t.addColumn("tfByDocument").alignLeft();
            t.addColumn("fieldIndices");
            if (this.stemIndex != null) {
                t.addColumn("stemIndex");
                t.addColumn("=>stem").alignLeft();
            }
            for (int i = 0; i < this.image.length; ++i) {
                t.rowData(i, this.image[i] == null ? "<null>" : new String(this.image[i]), this.type[i], this.tf[i], SparseArray.sparseToString(this.tfByDocument[i]));
                t.rowData(Arrays.toString(PreprocessingContext.toFieldIndexes(this.fieldIndices[i])).replace(" ", ""));
                if (this.stemIndex != null) {
                    t.rowData(this.stemIndex[i]);
                    t.rowData(new String(PreprocessingContext.this.allStems.image[this.stemIndex[i]]));
                }
                t.nextRow();
            }
            t.flush();
            sw.append("\n");
            return sw.toString();
        }
    }

    public static class AllFields {
        public String[] name;

        public String toString() {
            StringWriter sw = new StringWriter();
            TabularOutput t = new TabularOutput(sw);
            t.flushEvery(Integer.MAX_VALUE);
            t.addColumn("#");
            t.addColumn("name").format("%-10s").alignLeft();
            int i = 0;
            for (String n : this.name) {
                t.rowData(i++, n).nextRow();
            }
            t.flush();
            sw.append("\n");
            return sw.toString();
        }
    }

    public class AllTokens {
        public char[][] image;
        public short[] type;
        public byte[] fieldIndex;
        public int[] documentIndex;
        public int[] wordIndex;
        public int[] suffixOrder;
        public int[] lcp;

        public String toString() {
            StringWriter sw = new StringWriter();
            TabularOutput t = new TabularOutput(sw);
            t.flushEvery(Integer.MAX_VALUE);
            t.addColumn("#");
            t.addColumn("token").alignLeft();
            t.addColumn("type");
            t.addColumn("fieldIndex");
            t.addColumn("=>field").alignLeft();
            t.addColumn("docIdx");
            t.addColumn("wordIdx");
            t.addColumn("=>word").alignLeft();
            for (int i = 0; i < this.image.length; ++i) {
                t.rowData(i, this.image[i] == null ? "<null>" : new String(this.image[i]), this.type[i], this.fieldIndex[i], this.fieldIndex[i] >= 0 ? PreprocessingContext.this.allFields.name[this.fieldIndex[i]] : null, this.documentIndex[i], this.wordIndex[i], this.wordIndex[i] >= 0 ? new String(PreprocessingContext.this.allWords.image[this.wordIndex[i]]) : null);
                t.nextRow();
            }
            if (this.suffixOrder != null) {
                t = new TabularOutput(sw);
                t.addColumn("#");
                t.addColumn("sa");
                t.addColumn("lcp");
                t.addColumn("=>words").alignLeft();
                sw.append("\n");
                StringBuilder suffixImage = new StringBuilder();
                for (int i = 0; i < this.suffixOrder.length; ++i) {
                    t.rowData(i, this.suffixOrder[i], this.lcp[i]);
                    int windowLength = 5;
                    int j = this.suffixOrder[i];
                    int max = Math.min(this.suffixOrder[i] + windowLength, this.wordIndex.length);
                    while (j < max) {
                        suffixImage.append(this.wordIndex[j] >= 0 ? new String(PreprocessingContext.this.allWords.image[this.wordIndex[j]]) : "|").append(" ");
                        if (++j != max || j == this.wordIndex.length) continue;
                        suffixImage.append(" [...]");
                    }
                    t.rowData(suffixImage.toString());
                    suffixImage.setLength(0);
                    t.nextRow();
                }
                sw.append("\n");
            }
            t.flush();
            sw.append("\n");
            return sw.toString();
        }
    }
}

