/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.opensearch;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.fetcher.FeedFetcher;
import com.sun.syndication.fetcher.FetcherException;
import com.sun.syndication.io.FeedException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.carrot2.core.Document;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.util.StringUtils;

public class RomeFetcherUtils {
    public static SearchEngineResponse fetchUrl(String url, FeedFetcher feedFetcher) throws IOException, FeedException, FetcherException, MalformedURLException {
        SyndFeed feed = feedFetcher.retrieveFeed(new URL(url));
        SearchEngineResponse response = new SearchEngineResponse();
        if (feed != null) {
            List entries = feed.getEntries();
            for (SyndEntry entry : entries) {
                Document document = new Document();
                document.setField("title", RomeFetcherUtils.clean(entry.getTitle()));
                document.setField("snippet", RomeFetcherUtils.clean(entry.getDescription().getValue()));
                document.setField("url", entry.getLink());
                response.results.add(document);
            }
        }
        return response;
    }

    private static String clean(String string) {
        return StringUtils.removeHtmlTags(StringEscapeUtils.unescapeHtml((String)string));
    }
}

