/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.opensearch;

import com.google.common.collect.Maps;
import com.sun.syndication.fetcher.FeedFetcher;
import com.sun.syndication.fetcher.impl.HttpURLFeedFetcher;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngine;
import org.carrot2.source.MultipageSearchEngineMetadata;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.opensearch.RomeFetcherUtils;
import org.carrot2.util.StringUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.IntRange;
import org.carrot2.util.resource.URLResourceWithParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bindable(prefix="OpenSearchDocumentSource")
public class OpenSearchDocumentSource
extends MultipageSearchEngine {
    static final Logger logger = LoggerFactory.getLogger(OpenSearchDocumentSource.class);
    private static final int MAX_CONCURRENT_THREADS = 10;
    @Input
    @Processing
    @Init
    @Attribute
    @Required
    @Label(value="Feed URL template")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Service")
    public String feedUrlTemplate;
    @Input
    @Processing
    @Init
    @Attribute
    @Required
    @IntRange(min=1)
    @Label(value="Results per page")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Service")
    public int resultsPerPage = 50;
    @Input
    @Processing
    @Init
    @Attribute
    @IntRange(min=1)
    @Label(value="Maximum results")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Service")
    public int maximumResults = 1000;
    @Input
    @Init
    @Processing
    @Attribute
    @Label(value="Feed URL parameters")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public Map<String, String> feedUrlParams = null;
    @Input
    @Init
    @Processing
    @Attribute
    @Label(value="User agent")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public String userAgent = null;
    private MultipageSearchEngineMetadata metadata;
    private FeedFetcher feedFetcher;
    private static final String SEARCH_TERMS_VARIABLE_NAME = "searchTerms";
    private static final String START_INDEX_VARIABLE_NAME = "startIndex";
    private static final String START_PAGE_VARIABLE_NAME = "startPage";
    private static final String COUNT_VARIABLE_NAME = "count";

    @Override
    public void beforeProcessing() {
        boolean hasStartIndex;
        boolean hasStartPage = URLResourceWithParams.containsAttributePlaceholder(this.feedUrlTemplate, START_PAGE_VARIABLE_NAME);
        if (!(hasStartPage ^ (hasStartIndex = URLResourceWithParams.containsAttributePlaceholder(this.feedUrlTemplate, START_INDEX_VARIABLE_NAME)))) {
            throw new ProcessingException("The feedUrlTemplate must contain either " + URLResourceWithParams.formatAttributePlaceholder(START_INDEX_VARIABLE_NAME) + " or " + URLResourceWithParams.formatAttributePlaceholder(START_PAGE_VARIABLE_NAME) + " variable");
        }
        if (!URLResourceWithParams.containsAttributePlaceholder(this.feedUrlTemplate, SEARCH_TERMS_VARIABLE_NAME)) {
            throw new ProcessingException("The feedUrlTemplate must contain " + URLResourceWithParams.formatAttributePlaceholder(SEARCH_TERMS_VARIABLE_NAME) + " variable");
        }
        if (this.resultsPerPage == 0) {
            throw new ProcessingException("resultsPerPage must be set");
        }
        this.metadata = new MultipageSearchEngineMetadata(this.resultsPerPage, this.maximumResults, hasStartPage);
        this.feedFetcher = new HttpURLFeedFetcher();
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.userAgent)) {
            this.feedFetcher.setUserAgent(this.userAgent);
        }
    }

    @Override
    public void process() throws ProcessingException {
        super.process(this.metadata, this.getSharedExecutor(10, this.getClass()));
    }

    @Override
    protected Callable<SearchEngineResponse> createFetcher(final MultipageSearchEngine.SearchRange bucket) {
        return new MultipageSearchEngine.SearchEngineResponseCallable(){

            @Override
            public SearchEngineResponse search() throws Exception {
                HashMap values = Maps.newHashMap();
                values.put(OpenSearchDocumentSource.SEARCH_TERMS_VARIABLE_NAME, OpenSearchDocumentSource.this.query);
                values.put(OpenSearchDocumentSource.START_INDEX_VARIABLE_NAME, bucket.start + 1);
                values.put(OpenSearchDocumentSource.START_PAGE_VARIABLE_NAME, bucket.start + 1);
                values.put(OpenSearchDocumentSource.COUNT_VARIABLE_NAME, bucket.results);
                StringBuilder urlExtension = new StringBuilder(URLResourceWithParams.substituteAttributes(OpenSearchDocumentSource.this.feedUrlTemplate, values));
                if (OpenSearchDocumentSource.this.feedUrlParams != null) {
                    for (Map.Entry<String, String> entry : OpenSearchDocumentSource.this.feedUrlParams.entrySet()) {
                        urlExtension.append('&');
                        urlExtension.append(entry.getKey());
                        urlExtension.append('=');
                        urlExtension.append(StringUtils.urlEncodeWrapException(entry.getValue(), "UTF-8"));
                    }
                }
                String url = urlExtension.toString();
                logger.debug("Fetching URL: " + url);
                return RomeFetcherUtils.fetchUrl(url, OpenSearchDocumentSource.this.feedFetcher);
            }
        };
    }
}

