/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.lucene;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.CommonAttributesDescriptor;
import org.carrot2.source.lucene.IFieldMapper;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

public final class LuceneDocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.lucene.LuceneDocumentSource";
    public final String prefix = "LuceneDocumentSource";
    public final String title = "A <code>IDocumentSource</code> fetching <code>Document</code>s from a local Apache Lucene index";
    public final String label = "";
    public final String description = "The index should be binary-compatible with the Lucene version actually imported by this plugin.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "LuceneDocumentSource";
    }

    public String getTitle() {
        return "A <code>IDocumentSource</code> fetching <code>Document</code>s from a local Apache Lucene index";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "The index should be binary-compatible with the Lucene version actually imported by this plugin.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(LuceneDocumentSourceDescriptor.attributes.results);
        ownAttrs.add(LuceneDocumentSourceDescriptor.attributes.resultsTotal);
        ownAttrs.add(LuceneDocumentSourceDescriptor.attributes.documents);
        ownAttrs.add(LuceneDocumentSourceDescriptor.attributes.directory);
        ownAttrs.add(LuceneDocumentSourceDescriptor.attributes.analyzer);
        ownAttrs.add(LuceneDocumentSourceDescriptor.attributes.fieldMapper);
        ownAttrs.add(LuceneDocumentSourceDescriptor.attributes.query);
        ownAttrs.add(LuceneDocumentSourceDescriptor.attributes.keepLuceneDocuments);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(LuceneDocumentSourceDescriptor.attributes.results);
        allAttrs.add(LuceneDocumentSourceDescriptor.attributes.resultsTotal);
        allAttrs.add(LuceneDocumentSourceDescriptor.attributes.documents);
        allAttrs.add(LuceneDocumentSourceDescriptor.attributes.directory);
        allAttrs.add(LuceneDocumentSourceDescriptor.attributes.analyzer);
        allAttrs.add(LuceneDocumentSourceDescriptor.attributes.fieldMapper);
        allAttrs.add(LuceneDocumentSourceDescriptor.attributes.query);
        allAttrs.add(LuceneDocumentSourceDescriptor.attributes.keepLuceneDocuments);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder results(int value) {
            this.map.put("results", value);
            return this;
        }

        public long resultsTotal() {
            return (Long)this.map.get("results-total");
        }

        public Collection<Document> documents() {
            return (Collection)this.map.get("documents");
        }

        public AttributeBuilder directory(Directory value) {
            this.map.put("LuceneDocumentSource.directory", value);
            return this;
        }

        public AttributeBuilder directory(Class<? extends Directory> clazz) {
            this.map.put("LuceneDocumentSource.directory", clazz);
            return this;
        }

        public AttributeBuilder analyzer(Analyzer value) {
            this.map.put("LuceneDocumentSource.analyzer", value);
            return this;
        }

        public AttributeBuilder analyzer(Class<? extends Analyzer> clazz) {
            this.map.put("LuceneDocumentSource.analyzer", clazz);
            return this;
        }

        public AttributeBuilder fieldMapper(IFieldMapper value) {
            this.map.put("LuceneDocumentSource.fieldMapper", value);
            return this;
        }

        public AttributeBuilder fieldMapper(Class<? extends IFieldMapper> clazz) {
            this.map.put("LuceneDocumentSource.fieldMapper", clazz);
            return this;
        }

        public AttributeBuilder query(Object value) {
            this.map.put("query", value);
            return this;
        }

        public AttributeBuilder keepLuceneDocuments(boolean value) {
            this.map.put("LuceneDocumentSource.keepLuceneDocuments", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo results;
        public final AttributeInfo resultsTotal;
        public final AttributeInfo documents;
        public final AttributeInfo directory;
        public final AttributeInfo analyzer;
        public final AttributeInfo fieldMapper;
        public final AttributeInfo query;
        public final AttributeInfo keepLuceneDocuments;

        private Attributes() {
            this.results = new AttributeInfo("results", "org.carrot2.source.lucene.LuceneDocumentSource", "results", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.results);
            this.resultsTotal = new AttributeInfo("results-total", "org.carrot2.source.lucene.LuceneDocumentSource", "resultsTotal", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.resultsTotal);
            this.documents = new AttributeInfo("documents", "org.carrot2.source.lucene.LuceneDocumentSource", "documents", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.documents);
            this.directory = new AttributeInfo("LuceneDocumentSource.directory", "org.carrot2.source.lucene.LuceneDocumentSource", "directory", "Search index {@link org.apache.lucene.store.Directory}. Must be unlocked for\nreading.", "Index directory", "Search index <code>org.apache.lucene.store.Directory</code>", "Must be unlocked for reading.", "Index properties", AttributeLevel.BASIC, null);
            this.analyzer = new AttributeInfo("LuceneDocumentSource.analyzer", "org.carrot2.source.lucene.LuceneDocumentSource", "analyzer", "{@link org.apache.lucene.analysis.Analyzer} used at indexing time. The same\nanalyzer should be used for querying.", "Analyzer", "<code>org.apache.lucene.analysis.Analyzer</code> used at indexing time", "The same analyzer should be used for querying.", "Index properties", AttributeLevel.MEDIUM, null);
            this.fieldMapper = new AttributeInfo("LuceneDocumentSource.fieldMapper", "org.carrot2.source.lucene.LuceneDocumentSource", "fieldMapper", "{@link IFieldMapper} provides the link between Carrot2\n{@link org.carrot2.core.Document} fields and Lucene index fields.", "Field mapper", "<code>IFieldMapper</code> provides the link between Carrot2 <code>org.carrot2.core.Document</code> fields and Lucene index fields", null, "Index field mapping", AttributeLevel.ADVANCED, null);
            this.query = new AttributeInfo("query", "org.carrot2.source.lucene.LuceneDocumentSource", "query", "A pre-parsed {@link org.apache.lucene.search.Query} object or a {@link String}\nparsed using the built-in {@link org.apache.lucene.queryParser.QueryParser} over a\nset of search fields returned from the {@link org.carrot2.source.lucene.LuceneDocumentSource#fieldMapper}.", "Query", "A pre-parsed <code>org.apache.lucene.search.Query</code> object or a <code>String</code> parsed using the built-in <code>org.apache.lucene.queryParser.QueryParser</code> over a set of search fields returned from the <code>org.carrot2.source.lucene.LuceneDocumentSource.fieldMapper</code>", null, "Search query", AttributeLevel.BASIC, null);
            this.keepLuceneDocuments = new AttributeInfo("LuceneDocumentSource.keepLuceneDocuments", "org.carrot2.source.lucene.LuceneDocumentSource", "keepLuceneDocuments", "Keeps references to Lucene document instances in Carrot2 documents. Please bear in\nmind two limitations:\n<ul>\n<li><strong>Lucene documents will not be serialized to XML/JSON.</strong>\nTherefore, they can only be accessed when invoking clustering through Carrot2 Java\nAPI. To pass some of the fields of Lucene documents to Carrot2 XML/JSON output,\nimplement a custom {@link IFieldMapper} that will store those fields as regular\nCarrot2 fields.</li>\n<li><strong>Increased memory usage</strong> when using a {@link org.carrot2.core.Controller}\n{@link org.carrot2.core.ControllerFactory#createCachingPooling(Class...) configured to cache} the\noutput from {@link LuceneDocumentSource}.</li>\n</ul>", "Keep Lucene documents", "Keeps references to Lucene document instances in Carrot2 documents", "Please bear in mind two limitations: <ul> <li><strong>Lucene documents will not be serialized to XML/JSON.</strong> Therefore, they can only be accessed when invoking clustering through Carrot2 Java API. To pass some of the fields of Lucene documents to Carrot2 XML/JSON output, implement a custom <code>IFieldMapper</code> that will store those fields as regular Carrot2 fields.</li> <li><strong>Increased memory usage</strong> when using a <code>org.carrot2.core.Controller</code> <code>org.carrot2.core.ControllerFactory.createCachingPooling(Class...) configured to cache</code> the output from <code>LuceneDocumentSource</code>.</li> </ul>", "Search result information", AttributeLevel.ADVANCED, null);
        }
    }

    public static class Keys {
        public static final String RESULTS = "results";
        public static final String RESULTS_TOTAL = "results-total";
        public static final String DOCUMENTS = "documents";
        public static final String DIRECTORY = "LuceneDocumentSource.directory";
        public static final String ANALYZER = "LuceneDocumentSource.analyzer";
        public static final String FIELD_MAPPER = "LuceneDocumentSource.fieldMapper";
        public static final String QUERY = "query";
        public static final String KEEP_LUCENE_DOCUMENTS = "LuceneDocumentSource.keepLuceneDocuments";

        protected Keys() {
        }
    }
}

