/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.idol;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.source.MultipageSearchEngineDescriptor;
import org.carrot2.source.SearchEngineBaseDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

public final class IdolDocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.idol.IdolDocumentSource";
    public final String prefix = "IdolDocumentSource";
    public final String title = "A <code>IDocumentSource</code> fetching <code>Document</code>s (search results) from an IDOL Search Engine";
    public final String label = "";
    public final String description = "Please note that you will need to install an XSLT stylesheet in your IDOL instance that transforms the search results into the OpenSearch format. The XSLT stylesheet is available under the <tt>org.carrot2.source.idol</tt> package, next to the binaries of this class. <p> Based on code donated by Julien Nioche. Autonomy IDOL support contributed by James Sealey. </p>";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "IdolDocumentSource";
    }

    public String getTitle() {
        return "A <code>IDocumentSource</code> fetching <code>Document</code>s (search results) from an IDOL Search Engine";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "Please note that you will need to install an XSLT stylesheet in your IDOL instance that transforms the search results into the OpenSearch format. The XSLT stylesheet is available under the <tt>org.carrot2.source.idol</tt> package, next to the binaries of this class. <p> Based on code donated by Julien Nioche. Autonomy IDOL support contributed by James Sealey. </p>";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(IdolDocumentSourceDescriptor.attributes.idolServerName);
        ownAttrs.add(IdolDocumentSourceDescriptor.attributes.idolServerPort);
        ownAttrs.add(IdolDocumentSourceDescriptor.attributes.xslTemplateName);
        ownAttrs.add(IdolDocumentSourceDescriptor.attributes.otherSearchAttributes);
        ownAttrs.add(IdolDocumentSourceDescriptor.attributes.resultsPerPage);
        ownAttrs.add(IdolDocumentSourceDescriptor.attributes.minScore);
        ownAttrs.add(IdolDocumentSourceDescriptor.attributes.maximumResults);
        ownAttrs.add(IdolDocumentSourceDescriptor.attributes.userAgent);
        ownAttrs.add(IdolDocumentSourceDescriptor.attributes.userName);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(IdolDocumentSourceDescriptor.attributes.idolServerName);
        allAttrs.add(IdolDocumentSourceDescriptor.attributes.idolServerPort);
        allAttrs.add(IdolDocumentSourceDescriptor.attributes.xslTemplateName);
        allAttrs.add(IdolDocumentSourceDescriptor.attributes.otherSearchAttributes);
        allAttrs.add(IdolDocumentSourceDescriptor.attributes.resultsPerPage);
        allAttrs.add(IdolDocumentSourceDescriptor.attributes.minScore);
        allAttrs.add(IdolDocumentSourceDescriptor.attributes.maximumResults);
        allAttrs.add(IdolDocumentSourceDescriptor.attributes.userAgent);
        allAttrs.add(IdolDocumentSourceDescriptor.attributes.userName);
        allAttrs.add(MultipageSearchEngineDescriptor.attributes.searchMode);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.start);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.results);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.query);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.documents);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.compressed);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder
    extends MultipageSearchEngineDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder idolServerName(String value) {
            this.map.put("IdolDocumentSource.idolServerName", value);
            return this;
        }

        public AttributeBuilder idolServerPort(int value) {
            this.map.put("IdolDocumentSource.idolServerPort", value);
            return this;
        }

        public AttributeBuilder xslTemplateName(String value) {
            this.map.put("IdolDocumentSource.xslTemplateName", value);
            return this;
        }

        public AttributeBuilder otherSearchAttributes(String value) {
            this.map.put("IdolDocumentSource.otherSearchAttributes", value);
            return this;
        }

        public AttributeBuilder resultsPerPage(int value) {
            this.map.put("IdolDocumentSource.resultsPerPage", value);
            return this;
        }

        public AttributeBuilder minScore(int value) {
            this.map.put("IdolDocumentSource.minScore", value);
            return this;
        }

        public AttributeBuilder maximumResults(int value) {
            this.map.put("IdolDocumentSource.maximumResults", value);
            return this;
        }

        public AttributeBuilder userAgent(String value) {
            this.map.put("IdolDocumentSource.userAgent", value);
            return this;
        }

        public AttributeBuilder userName(String value) {
            this.map.put("IdolDocumentSource.userName", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo idolServerName = new AttributeInfo("IdolDocumentSource.idolServerName", "org.carrot2.source.idol.IdolDocumentSource", "idolServerName", "URL of the IDOL Server.", "IDOL server address", "URL of the IDOL Server", null, "Service", AttributeLevel.BASIC, null);
        public final AttributeInfo idolServerPort = new AttributeInfo("IdolDocumentSource.idolServerPort", "org.carrot2.source.idol.IdolDocumentSource", "idolServerPort", "IDOL Server Port.", "IDOL server port", "IDOL Server Port", null, "Service", AttributeLevel.BASIC, null);
        public final AttributeInfo xslTemplateName = new AttributeInfo("IdolDocumentSource.xslTemplateName", "org.carrot2.source.idol.IdolDocumentSource", "xslTemplateName", "IDOL XSL Template Name. The Reference of an IDOL XSL template that outputs the\nresults in OpenSearch format.", "IDOL XSL template name", "IDOL XSL Template Name", "The Reference of an IDOL XSL template that outputs the results in OpenSearch format.", "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo otherSearchAttributes = new AttributeInfo("IdolDocumentSource.otherSearchAttributes", "org.carrot2.source.idol.IdolDocumentSource", "otherSearchAttributes", "Any other search attributes (separated by &amp;) from the Autonomy Query Search\nAPI's Ensure all the attributes are entered to satisfy XSL that will be applied.", "Other IDOLSearch attributes", "Any other search attributes (separated by &amp;) from the Autonomy Query Search API's Ensure all the attributes are entered to satisfy XSL that will be applied", null, "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo resultsPerPage = new AttributeInfo("IdolDocumentSource.resultsPerPage", "org.carrot2.source.idol.IdolDocumentSource", "resultsPerPage", "Results per page. The number of results per page the document source will expect\nthe feed to return.", "Results per page", "Results per page", "The number of results per page the document source will expect the feed to return.", "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo minScore = new AttributeInfo("IdolDocumentSource.minScore", "org.carrot2.source.idol.IdolDocumentSource", "minScore", "Minimum IDOL Score. The minimum score of the results returned by IDOL.", "Minimum score", "Minimum IDOL Score", "The minimum score of the results returned by IDOL.", "Service", AttributeLevel.BASIC, null);
        public final AttributeInfo maximumResults = new AttributeInfo("IdolDocumentSource.maximumResults", "org.carrot2.source.idol.IdolDocumentSource", "maximumResults", "Maximum number of results. The maximum number of results the document source can\ndeliver.", "Maximum results", "Maximum number of results", "The maximum number of results the document source can deliver.", "Service", AttributeLevel.BASIC, null);
        public final AttributeInfo userAgent = new AttributeInfo("IdolDocumentSource.userAgent", "org.carrot2.source.idol.IdolDocumentSource", "userAgent", "User agent header. The contents of the User-Agent HTTP header to use when making\nrequests to the feed URL. If empty or <code>null</code> value is provided, the\nfollowing User-Agent will be sent:\n<code>Rome Client (http://tinyurl.com/64t5n) Ver: UNKNOWN</code>.", "User agent", "User agent header", "The contents of the User-Agent HTTP header to use when making requests to the feed URL. If empty or <code>null</code> value is provided, the following User-Agent will be sent: <code>Rome Client (http://tinyurl.com/64t5n) Ver: UNKNOWN</code>.", "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo userName = new AttributeInfo("IdolDocumentSource.userName", "org.carrot2.source.idol.IdolDocumentSource", "userName", "User name to use for authentication.", "User name", "User name to use for authentication", null, "Service", AttributeLevel.MEDIUM, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends MultipageSearchEngineDescriptor.Keys {
        public static final String IDOL_SERVER_NAME = "IdolDocumentSource.idolServerName";
        public static final String IDOL_SERVER_PORT = "IdolDocumentSource.idolServerPort";
        public static final String XSL_TEMPLATE_NAME = "IdolDocumentSource.xslTemplateName";
        public static final String OTHER_SEARCH_ATTRIBUTES = "IdolDocumentSource.otherSearchAttributes";
        public static final String RESULTS_PER_PAGE = "IdolDocumentSource.resultsPerPage";
        public static final String MIN_SCORE = "IdolDocumentSource.minScore";
        public static final String MAXIMUM_RESULTS = "IdolDocumentSource.maximumResults";
        public static final String USER_AGENT = "IdolDocumentSource.userAgent";
        public static final String USER_NAME = "IdolDocumentSource.userName";

        protected Keys() {
        }
    }
}

