/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.idol;

import com.sun.syndication.fetcher.FeedFetcher;
import com.sun.syndication.fetcher.impl.HttpURLFeedFetcher;
import java.net.URL;
import java.net.URLEncoder;
import java.util.concurrent.Callable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngine;
import org.carrot2.source.MultipageSearchEngineMetadata;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.opensearch.RomeFetcherUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.IntRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Bindable(prefix="IdolDocumentSource")
public class IdolDocumentSource
extends MultipageSearchEngine {
    static final Logger logger = LoggerFactory.getLogger(IdolDocumentSource.class);
    private static final int MAX_CONCURRENT_THREADS = 10;
    @Input
    @Processing
    @Init
    @Attribute
    @Required
    @Label(value="IDOL server address")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Service")
    public String idolServerName;
    @Input
    @Processing
    @Init
    @Attribute
    @Required
    @Label(value="IDOL server port")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Service")
    public int idolServerPort;
    @Input
    @Processing
    @Init
    @Attribute
    @Required
    @Label(value="IDOL XSL template name")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public String xslTemplateName;
    @Input
    @Processing
    @Init
    @Attribute
    @Label(value="Other IDOLSearch attributes")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public String otherSearchAttributes;
    @Input
    @Processing
    @Init
    @Attribute
    @Required
    @IntRange(min=1)
    @Label(value="Results per page")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public int resultsPerPage = 50;
    @Input
    @Processing
    @Init
    @Attribute
    @IntRange(min=1)
    @Label(value="Minimum score")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Service")
    public int minScore = 50;
    @Input
    @Processing
    @Init
    @Attribute
    @IntRange(min=1)
    @Label(value="Maximum results")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Service")
    public int maximumResults = 100;
    @Input
    @Init
    @Processing
    @Attribute
    @Label(value="User agent")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public String userAgent = null;
    @Input
    @Processing
    @Attribute
    @Label(value="User name")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Service")
    public String userName;
    private MultipageSearchEngineMetadata metadata;
    private FeedFetcher feedFetcher;

    @Override
    public void beforeProcessing() {
        this.metadata = new MultipageSearchEngineMetadata(this.resultsPerPage, this.maximumResults, false);
        this.feedFetcher = new HttpURLFeedFetcher();
        if (StringUtils.isNotBlank((String)this.userAgent)) {
            this.feedFetcher.setUserAgent(this.userAgent);
        }
    }

    @Override
    public void process() throws ProcessingException {
        super.process(this.metadata, this.getSharedExecutor(10, this.getClass()));
    }

    @Override
    protected Callable<SearchEngineResponse> createFetcher(MultipageSearchEngine.SearchRange bucket) {
        return new MultipageSearchEngine.SearchEngineResponseCallable(){

            @Override
            public SearchEngineResponse search() throws Exception {
                String url = IdolDocumentSource.this.getURL();
                logger.debug("Fetching URL: " + url);
                return RomeFetcherUtils.fetchUrl(url, IdolDocumentSource.this.feedFetcher);
            }
        };
    }

    private String getURL() {
        String securityToken;
        StringBuilder url = new StringBuilder();
        url.append("http://");
        url.append(this.idolServerName);
        url.append(":");
        url.append(this.idolServerPort);
        url.append("/action=Query&");
        url.append("Text=" + this.query + "&");
        url.append("MinScore=" + this.minScore + "&");
        url.append("maxresults=" + this.maximumResults + "&");
        url.append("template=" + this.xslTemplateName + "&");
        url.append(this.otherSearchAttributes);
        if (this.userName != null && (securityToken = this.getSecurityToken()) != "") {
            url.append("&SecurityInfo=" + securityToken);
        }
        return url.toString();
    }

    private String getSecurityToken() {
        String rtn = "";
        try {
            String url = "http://" + this.idolServerName + ":" + this.idolServerPort + "/" + "action=userread&username=" + this.userName + "&securityinfo=true";
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new URL(url).openStream());
            rtn = URLEncoder.encode(this.getSecurityInfo(doc), "UTF-8");
        }
        catch (Exception e) {
            logger.error("Could not get security token", (Throwable)e);
        }
        return rtn;
    }

    private String getSecurityInfo(Document document) {
        String rtn = "";
        Element e = document.getDocumentElement();
        NodeList nodeList = e.getElementsByTagName("responsedata");
        for (int temp = 0; temp < nodeList.getLength(); ++temp) {
            Node nNode = nodeList.item(temp);
            if (nNode.getNodeType() != 1) continue;
            Element eElement = (Element)nNode;
            rtn = IdolDocumentSource.getTagValue("autn:securityinfo", eElement);
        }
        return rtn;
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getElementsByTagName(sTag).item(0).getChildNodes();
        Node nValue = nlList.item(0);
        return nValue.getNodeValue();
    }
}

