/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.google;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.source.MultipageSearchEngineDescriptor;
import org.carrot2.source.SearchEngineBaseDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

public final class GoogleDocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.google.GoogleDocumentSource";
    public final String prefix = "GoogleDocumentSource";
    public final String title = "A <code>IDocumentSource</code> fetching search results from Google JSON API";
    public final String label = "";
    public final String description = "Please note that this document source cannot deliver more than 32 search results.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "GoogleDocumentSource";
    }

    public String getTitle() {
        return "A <code>IDocumentSource</code> fetching search results from Google JSON API";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "Please note that this document source cannot deliver more than 32 search results.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(GoogleDocumentSourceDescriptor.attributes.serviceUrl);
        ownAttrs.add(GoogleDocumentSourceDescriptor.attributes.referer);
        ownAttrs.add(GoogleDocumentSourceDescriptor.attributes.keepHighlights);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(GoogleDocumentSourceDescriptor.attributes.serviceUrl);
        allAttrs.add(GoogleDocumentSourceDescriptor.attributes.referer);
        allAttrs.add(GoogleDocumentSourceDescriptor.attributes.keepHighlights);
        allAttrs.add(MultipageSearchEngineDescriptor.attributes.searchMode);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.start);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.results);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.query);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.documents);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.compressed);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder
    extends MultipageSearchEngineDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder serviceUrl(String value) {
            this.map.put("GoogleDocumentSource.serviceUrl", value);
            return this;
        }

        public AttributeBuilder referer(String value) {
            this.map.put("GoogleDocumentSource.referer", value);
            return this;
        }

        public AttributeBuilder keepHighlights(boolean value) {
            this.map.put("GoogleDocumentSource.keepHighlights", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo serviceUrl = new AttributeInfo("GoogleDocumentSource.serviceUrl", "org.carrot2.source.google.GoogleDocumentSource", "serviceUrl", "Service URL. Google web search service URL.", "Service URL", "Service URL", "Google web search service URL.", "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo referer = new AttributeInfo("GoogleDocumentSource.referer", "org.carrot2.source.google.GoogleDocumentSource", "referer", "Request referrer. Please do not use the default value when deploying this\ncomponent in production environments. Instead, put the URL to your application\nhere.", "Referrer", "Request referrer", "Please do not use the default value when deploying this component in production environments. Instead, put the URL to your application here.", "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo keepHighlights = new AttributeInfo("GoogleDocumentSource.keepHighlights", "org.carrot2.source.google.GoogleDocumentSource", "keepHighlights", "Keep query word highlighting. Google by default highlights query words in snippets\nusing the bold HTML tag. Set this attribute to <code>true</code> to keep these\nhighlights.", "Keep highlights", "Keep query word highlighting", "Google by default highlights query words in snippets using the bold HTML tag. Set this attribute to <code>true</code> to keep these highlights.", "Postprocessing", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends MultipageSearchEngineDescriptor.Keys {
        public static final String SERVICE_URL = "GoogleDocumentSource.serviceUrl";
        public static final String REFERER = "GoogleDocumentSource.referer";
        public static final String KEEP_HIGHLIGHTS = "GoogleDocumentSource.keepHighlights";

        protected Keys() {
        }
    }
}

